/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ArraysAsListSerializer
extends Serializer {
    private final Kryo _kryo;
    private Field _arrayField;

    public ArraysAsListSerializer(Kryo kryo) {
        this._kryo = kryo;
        try {
            this._arrayField = Class.forName("java.util.Arrays$ArrayList").getDeclaredField("a");
            this._arrayField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T readObjectData(ByteBuffer buffer, Class<T> clazz) {
        int length = IntSerializer.get((ByteBuffer)buffer, (boolean)true);
        Class componentType = this._kryo.readClass(buffer).getType();
        try {
            Object[] items = (Object[])Array.newInstance(componentType, length);
            for (int i = 0; i < length; ++i) {
                items[i] = this._kryo.readClassAndObject(buffer);
            }
            return (T)Arrays.asList(items);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeObjectData(ByteBuffer buffer, Object obj) {
        try {
            Object[] array = (Object[])this._arrayField.get(obj);
            IntSerializer.put((ByteBuffer)buffer, (int)array.length, (boolean)true);
            Class<?> componentType = array.getClass().getComponentType();
            this._kryo.writeClass(buffer, componentType);
            for (Object item : array) {
                this._kryo.writeClassAndObject(buffer, item);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

