/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers;

import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import com.esotericsoftware.kryo.serialize.StringSerializer;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Locale;

public class LocaleSerializer
extends SimpleSerializer<Locale> {
    private static Method getInstance;
    private final boolean useReflection;

    public LocaleSerializer() {
        this(true);
    }

    public LocaleSerializer(boolean useReflection) {
        this.useReflection = getInstance != null && useReflection;
    }

    public Locale read(ByteBuffer buffer) {
        String language = StringSerializer.get((ByteBuffer)buffer);
        String country = StringSerializer.get((ByteBuffer)buffer);
        String variant = StringSerializer.get((ByteBuffer)buffer);
        if (this.useReflection) {
            try {
                return (Locale)getInstance.invoke(null, language, country, variant);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get Locale using Locale.getInstance", e);
            }
        }
        return new Locale(language, country, variant);
    }

    public void write(ByteBuffer buffer, Locale object) {
        StringSerializer.put((ByteBuffer)buffer, (String)object.getLanguage());
        StringSerializer.put((ByteBuffer)buffer, (String)object.getCountry());
        StringSerializer.put((ByteBuffer)buffer, (String)object.getVariant());
    }

    static {
        try {
            getInstance = Locale.class.getDeclaredMethod("getInstance", String.class, String.class, String.class);
            getInstance.setAccessible(true);
        }
        catch (Exception e) {
            if (Log.TRACE) {
                Log.trace((String)"kryo", (String)"java.util.Locale.getInstance is not available");
            }
            getInstance = null;
        }
    }
}

