/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.kryo;

import com.esotericsoftware.kryo.ClassResolver;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.ReferenceResolver;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.StreamFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import de.javakaffee.kryoserializers.ArraysAsListSerializer;
import de.javakaffee.kryoserializers.CopyForIterateCollectionSerializer;
import de.javakaffee.kryoserializers.CopyForIterateMapSerializer;
import de.javakaffee.kryoserializers.EnumMapSerializer;
import de.javakaffee.kryoserializers.JdkProxySerializer;
import de.javakaffee.kryoserializers.SubListSerializers;
import de.javakaffee.kryoserializers.SynchronizedCollectionsSerializer;
import de.javakaffee.kryoserializers.UnmodifiableCollectionsSerializer;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.TranscoderDeserializationException;
import de.javakaffee.web.msm.serializer.kryo.DefaultFieldSerializerFactory;
import de.javakaffee.web.msm.serializer.kryo.KryoBuilder;
import de.javakaffee.web.msm.serializer.kryo.KryoBuilderConfiguration;
import de.javakaffee.web.msm.serializer.kryo.KryoCustomization;
import de.javakaffee.web.msm.serializer.kryo.KryoDefaultSerializerFactory;
import de.javakaffee.web.msm.serializer.kryo.SerializerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.StdInstantiatorStrategy;

public class KryoTranscoder
implements SessionAttributesTranscoder {
    private static final Log LOG = LogFactory.getLog(KryoTranscoder.class);
    public static final int DEFAULT_INITIAL_BUFFER_SIZE = 102400;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 2048000;
    public static final String DEFAULT_SERIALIZER_FACTORY_CLASS = DefaultFieldSerializerFactory.class.getName();
    private final KryoPool _kryoPool;
    private final int _initialBufferSize;
    private final int _maxBufferSize;
    private final KryoDefaultSerializerFactory _defaultSerializerFactory;

    public KryoTranscoder() {
        this(null, null, false);
    }

    public KryoTranscoder(ClassLoader classLoader, String[] customConverterClassNames, boolean copyCollectionsForSerialization) {
        this(classLoader, customConverterClassNames, copyCollectionsForSerialization, 102400, 2048000, DEFAULT_SERIALIZER_FACTORY_CLASS);
    }

    public KryoTranscoder(ClassLoader classLoader, String[] customConverterClassNames, boolean copyCollectionsForSerialization, int initialBufferSize, int maxBufferSize, String defaultSerializerFactoryClass) {
        LOG.info((Object)("Starting with initialBufferSize " + initialBufferSize + ", maxBufferSize " + maxBufferSize + " and defaultSerializerFactory " + defaultSerializerFactoryClass));
        KryoFactory kryoFactory = this.createKryoFactory(classLoader, customConverterClassNames, copyCollectionsForSerialization);
        this._kryoPool = new KryoPool.Builder(kryoFactory).softReferences().build();
        this._initialBufferSize = initialBufferSize;
        this._maxBufferSize = maxBufferSize;
        this._defaultSerializerFactory = this.loadDefaultSerializerFactory(classLoader, defaultSerializerFactoryClass);
    }

    protected KryoDefaultSerializerFactory loadDefaultSerializerFactory(ClassLoader classLoader, String defaultSerializerFactoryClass) {
        try {
            ClassLoader loader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(defaultSerializerFactoryClass, true, loader);
            return (KryoDefaultSerializerFactory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load default serializer factory: " + defaultSerializerFactoryClass, e);
        }
    }

    private KryoFactory createKryoFactory(final ClassLoader classLoader, final String[] customConverterClassNames, final boolean copyCollectionsForSerialization) {
        final KryoBuilder kryoBuilder = new KryoBuilder(){

            @Override
            protected Kryo createKryo(ClassResolver classResolver, ReferenceResolver referenceResolver, StreamFactory streamFactory) {
                return KryoTranscoder.this.createKryo(classResolver, referenceResolver, streamFactory, classLoader, customConverterClassNames, copyCollectionsForSerialization);
            }
        }.withInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new StdInstantiatorStrategy()));
        List<KryoBuilderConfiguration> builderConfigs = this.load(KryoBuilderConfiguration.class, customConverterClassNames, classLoader);
        for (KryoBuilderConfiguration config : builderConfigs) {
            config.configure(kryoBuilder);
        }
        return new KryoFactory(){

            public Kryo create() {
                Kryo kryo = kryoBuilder.build();
                kryo.setDefaultSerializer((com.esotericsoftware.kryo.factories.SerializerFactory)new KryoDefaultSerializerFactory.SerializerFactoryAdapter(KryoTranscoder.this._defaultSerializerFactory));
                if (classLoader != null) {
                    kryo.setClassLoader(classLoader);
                }
                kryo.setRegistrationRequired(false);
                kryo.register(Arrays.asList("").getClass(), (Serializer)new ArraysAsListSerializer());
                kryo.register(InvocationHandler.class, (Serializer)new JdkProxySerializer());
                UnmodifiableCollectionsSerializer.registerSerializers((Kryo)kryo);
                SynchronizedCollectionsSerializer.registerSerializers((Kryo)kryo);
                kryo.addDefaultSerializer(EnumMap.class, EnumMapSerializer.class);
                SubListSerializers.addDefaultSerializers((Kryo)kryo);
                List customizations = KryoTranscoder.this.load(KryoCustomization.class, customConverterClassNames, classLoader, kryo);
                if (customizations != null) {
                    for (KryoCustomization customization : customizations) {
                        try {
                            LOG.info((Object)("Executing KryoCustomization " + customization.getClass().getName()));
                            customization.customize(kryo);
                        }
                        catch (Throwable e) {
                            LOG.error((Object)("Could not execute customization " + customization), e);
                        }
                    }
                }
                return kryo;
            }
        };
    }

    protected Kryo createKryo(ClassResolver classResolver, ReferenceResolver referenceResolver, StreamFactory streamFactory, final ClassLoader classLoader, final String[] customConverterClassNames, final boolean copyCollectionsForSerialization) {
        return new Kryo(classResolver, referenceResolver, streamFactory){
            private final List<SerializerFactory> serializerFactories;
            {
                super(x0, x1, x2);
                this.serializerFactories = KryoTranscoder.this.load(SerializerFactory.class, customConverterClassNames, classLoader, this);
            }

            public Serializer getDefaultSerializer(Class clazz) {
                Serializer copyCollectionSerializer;
                Serializer customSerializer = this.loadCustomSerializer(clazz, this.serializerFactories);
                if (customSerializer != null) {
                    return customSerializer;
                }
                if (copyCollectionsForSerialization && (copyCollectionSerializer = KryoTranscoder.this.loadCopyCollectionSerializer(clazz)) != null) {
                    return copyCollectionSerializer;
                }
                return super.getDefaultSerializer(clazz);
            }

            private Serializer loadCustomSerializer(Class<?> clazz, List<SerializerFactory> serializerFactories) {
                if (serializerFactories != null) {
                    for (SerializerFactory serializerFactory : serializerFactories) {
                        Serializer serializer = serializerFactory.newSerializer(clazz);
                        if (serializer == null) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Loading custom serializer " + serializer.getClass().getName() + " for class " + clazz));
                        }
                        return serializer;
                    }
                }
                return null;
            }
        };
    }

    private Serializer loadCopyCollectionSerializer(Class<?> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading CopyForIterateCollectionSerializer for class " + clazz));
            }
            return new CopyForIterateCollectionSerializer();
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading CopyForIterateMapSerializer for class " + clazz));
            }
            return new CopyForIterateMapSerializer();
        }
        return null;
    }

    public Map<String, Object> deserializeAttributes(byte[] data) {
        Kryo kryo = this._kryoPool.borrow();
        try {
            Map map = (Map)kryo.readObject(new Input(data), ConcurrentHashMap.class);
            return map;
        }
        catch (RuntimeException e) {
            throw new TranscoderDeserializationException((Throwable)e);
        }
        finally {
            this._kryoPool.release(kryo);
        }
    }

    public byte[] serializeAttributes(MemcachedBackupSession session, Map<String, Object> attributes) {
        Kryo kryo = this._kryoPool.borrow();
        try {
            Output out = new Output(this._initialBufferSize, this._maxBufferSize);
            kryo.writeObject(out, attributes);
            byte[] byArray = out.toBytes();
            return byArray;
        }
        catch (RuntimeException e) {
            throw new TranscoderDeserializationException((Throwable)e);
        }
        finally {
            this._kryoPool.release(kryo);
        }
    }

    private <T> List<T> load(Class<T> type, String[] customConverterClassNames, ClassLoader classLoader) {
        return this.load(type, customConverterClassNames, classLoader, null);
    }

    private <T> List<T> load(Class<T> type, String[] customConverterClassNames, ClassLoader classLoader, Kryo kryo) {
        if (customConverterClassNames == null || customConverterClassNames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>();
        ClassLoader loader = classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
        for (String element : customConverterClassNames) {
            try {
                Class<?> clazz = Class.forName(element, true, loader);
                if (!type.isAssignableFrom(clazz)) continue;
                LOG.info((Object)("Loading " + type.getSimpleName() + " " + element));
                T item = KryoTranscoder.createInstance(clazz.asSubclass(type), kryo);
                result.add(item);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not instantiate " + element + ", omitting this " + type.getSimpleName() + "."), (Throwable)e);
                throw new RuntimeException("Could not load " + type.getSimpleName() + " " + element, e);
            }
        }
        return result;
    }

    private static <T> T createInstance(Class<? extends T> clazz, Kryo kryo) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        try {
            Constructor<T> constructor = clazz.getConstructor(Kryo.class);
            return constructor.newInstance(kryo);
        }
        catch (NoSuchMethodException nsme) {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
    }
}

