/*
 * Decompiled with CFR 0.152.
 */
package de.felixroske.jfxsupport;

import de.felixroske.jfxsupport.FXMLView;
import de.felixroske.jfxsupport.PropertyReaderHelper;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.StringUtils;

public abstract class AbstractFxmlView
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFxmlView.class);
    private final ObjectProperty<Object> presenterProperty;
    private final ResourceBundle bundle;
    private final URL resource;
    private final FXMLView annotation;
    private FXMLLoader fxmlLoader;
    private ApplicationContext applicationContext;
    private String fxmlRoot;

    public AbstractFxmlView() {
        LOGGER.debug("AbstractFxmlView construction");
        String filePathFromPackageName = PropertyReaderHelper.determineFilePathFromPackageName(this.getClass());
        this.setFxmlRootPath(filePathFromPackageName);
        this.annotation = this.getFXMLAnnotation();
        this.resource = this.getURLResource(this.annotation);
        this.presenterProperty = new SimpleObjectProperty();
        this.bundle = this.getResourceBundle(this.getBundleName());
    }

    private URL getURLResource(FXMLView annotation) {
        if (annotation != null && !annotation.value().equals("")) {
            return this.getClass().getResource(annotation.value());
        }
        return this.getClass().getResource(this.getFxmlPath());
    }

    private FXMLView getFXMLAnnotation() {
        Class<?> theClass = this.getClass();
        FXMLView annotation = theClass.getAnnotation(FXMLView.class);
        return annotation;
    }

    private Object createControllerForType(Class<?> type) {
        return this.applicationContext.getBean(type);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.applicationContext != null) {
            return;
        }
        this.applicationContext = applicationContext;
    }

    private void setFxmlRootPath(String path) {
        this.fxmlRoot = path;
    }

    private FXMLLoader loadSynchronously(URL resource, ResourceBundle bundle) throws IllegalStateException {
        FXMLLoader loader = new FXMLLoader(resource, bundle);
        loader.setControllerFactory(this::createControllerForType);
        try {
            loader.load();
        }
        catch (IOException | IllegalStateException e) {
            throw new IllegalStateException("Cannot load " + this.getConventionalName(), e);
        }
        return loader;
    }

    private void ensureFxmlLoaderInitialized() {
        if (this.fxmlLoader != null) {
            return;
        }
        this.fxmlLoader = this.loadSynchronously(this.resource, this.bundle);
        this.presenterProperty.set(this.fxmlLoader.getController());
    }

    public Parent getView() {
        this.ensureFxmlLoaderInitialized();
        Parent parent = (Parent)this.fxmlLoader.getRoot();
        this.addCSSIfAvailable(parent);
        return parent;
    }

    public void getView(Consumer<Parent> consumer) {
        CompletableFuture.supplyAsync(this::getView, Platform::runLater).thenAccept((Consumer)consumer);
    }

    public Node getViewWithoutRootContainer() {
        ObservableList children = this.getView().getChildrenUnmodifiable();
        if (children.isEmpty()) {
            return null;
        }
        return (Node)children.listIterator().next();
    }

    void addCSSIfAvailable(Parent parent) {
        List<String> list = PropertyReaderHelper.get(this.applicationContext.getEnvironment(), "javafx.css");
        if (!list.isEmpty()) {
            list.forEach(css -> parent.getStylesheets().add((Object)this.getClass().getResource((String)css).toExternalForm()));
        }
        this.addCSSFromAnnotation(parent, this.annotation);
        URL uri = this.getClass().getResource(this.getStyleSheetName());
        if (uri == null) {
            return;
        }
        String uriToCss = uri.toExternalForm();
        parent.getStylesheets().add((Object)uriToCss);
    }

    private void addCSSFromAnnotation(Parent parent, FXMLView annotation) {
        if (annotation != null && annotation.css().length > 0) {
            for (String cssFile : annotation.css()) {
                URL uri = this.getClass().getResource(cssFile);
                if (uri != null) {
                    String uriToCss = uri.toExternalForm();
                    parent.getStylesheets().add((Object)uriToCss);
                    LOGGER.debug("css file added to parent: {}", (Object)cssFile);
                    continue;
                }
                LOGGER.warn("referenced {} css file could not be located", (Object)cssFile);
            }
        }
    }

    private String getStyleSheetName() {
        return this.fxmlRoot + this.getConventionalName(".css");
    }

    public Object getPresenter() {
        this.ensureFxmlLoaderInitialized();
        return this.presenterProperty.get();
    }

    public void getPresenter(Consumer<Object> presenterConsumer) {
        this.presenterProperty.addListener((o, oldValue, newValue) -> presenterConsumer.accept(newValue));
    }

    private String getConventionalName(String ending) {
        return this.getConventionalName() + ending;
    }

    private String getConventionalName() {
        return AbstractFxmlView.stripEnding(this.getClass().getSimpleName().toLowerCase());
    }

    private String getBundleName() {
        if (!StringUtils.isEmpty((Object)this.annotation)) {
            String lbundle = this.annotation.bundle();
            LOGGER.debug("Annotated bundle: {}", (Object)lbundle);
            return lbundle;
        }
        String lbundle = this.getClass().getPackage().getName() + "." + this.getConventionalName();
        LOGGER.debug("Bundle: {} based on conventional name.", (Object)lbundle);
        return lbundle;
    }

    private static String stripEnding(String clazz) {
        if (!clazz.endsWith("view")) {
            return clazz;
        }
        return clazz.substring(0, clazz.lastIndexOf("view"));
    }

    final String getFxmlPath() {
        String fxmlPath = this.fxmlRoot + this.getConventionalName(".fxml");
        LOGGER.debug("Determined fxmlPath: " + fxmlPath);
        return fxmlPath;
    }

    private ResourceBundle getResourceBundle(String name) {
        try {
            LOGGER.debug("Resource bundle: " + name);
            return ResourceBundle.getBundle(name);
        }
        catch (MissingResourceException ex) {
            LOGGER.debug("No resource bundle could be determined: " + ex.getMessage());
            return null;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public String toString() {
        return "AbstractFxmlView [presenterProperty=" + this.presenterProperty + ", bundle=" + this.bundle + ", resource=" + this.resource + ", fxmlRoot=" + this.fxmlRoot + "]";
    }
}

