/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.OpenAiClient;
import dev.ai4j.openai4j.completion.CompletionChoice;
import dev.ai4j.openai4j.completion.CompletionRequest;
import dev.ai4j.openai4j.completion.CompletionResponse;
import dev.langchain4j.internal.RetryUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.Tokenizer;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.language.TokenCountEstimator;
import dev.langchain4j.model.openai.InternalOpenAiHelper;
import dev.langchain4j.model.openai.OpenAiLanguageModelName;
import dev.langchain4j.model.openai.OpenAiTokenizer;
import dev.langchain4j.model.openai.spi.OpenAiLanguageModelBuilderFactory;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.spi.ServiceHelper;
import java.net.Proxy;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;

public class OpenAiLanguageModel
implements LanguageModel,
TokenCountEstimator {
    private final OpenAiClient client;
    private final String modelName;
    private final Double temperature;
    private final Integer maxRetries;
    private final Tokenizer tokenizer;

    public OpenAiLanguageModel(String baseUrl, String apiKey, String organizationId, String modelName, Double temperature, Duration timeout, Integer maxRetries, Proxy proxy, Boolean logRequests, Boolean logResponses, Tokenizer tokenizer, Map<String, String> customHeaders) {
        timeout = (Duration)Utils.getOrDefault((Object)timeout, (Object)Duration.ofSeconds(60L));
        this.client = OpenAiClient.builder().baseUrl((String)Utils.getOrDefault((Object)baseUrl, (Object)"https://api.openai.com/v1")).openAiApiKey(apiKey).organizationId(organizationId).callTimeout(timeout).connectTimeout(timeout).readTimeout(timeout).writeTimeout(timeout).proxy(proxy).logRequests(logRequests).logResponses(logResponses).userAgent("langchain4j-openai").customHeaders(customHeaders).build();
        this.modelName = (String)Utils.getOrDefault((Object)modelName, (Object)"gpt-3.5-turbo-instruct");
        this.temperature = (Double)Utils.getOrDefault((Object)temperature, (Object)0.7);
        this.maxRetries = (Integer)Utils.getOrDefault((Object)maxRetries, (Object)3);
        this.tokenizer = (Tokenizer)Utils.getOrDefault((Object)tokenizer, OpenAiTokenizer::new);
    }

    public String modelName() {
        return this.modelName;
    }

    public Response<String> generate(String prompt) {
        CompletionRequest request = CompletionRequest.builder().model(this.modelName).prompt(prompt).temperature(this.temperature).build();
        CompletionResponse response = (CompletionResponse)RetryUtils.withRetry(() -> (CompletionResponse)this.client.completion(request).execute(), (int)this.maxRetries);
        CompletionChoice completionChoice = (CompletionChoice)response.choices().get(0);
        return Response.from((Object)completionChoice.text(), (TokenUsage)InternalOpenAiHelper.tokenUsageFrom(response.usage()), (FinishReason)InternalOpenAiHelper.finishReasonFrom(completionChoice.finishReason()));
    }

    public int estimateTokenCount(String prompt) {
        return this.tokenizer.estimateTokenCountInText(prompt);
    }

    @Deprecated(forRemoval=true)
    public static OpenAiLanguageModel withApiKey(String apiKey) {
        return OpenAiLanguageModel.builder().apiKey(apiKey).build();
    }

    public static OpenAiLanguageModelBuilder builder() {
        Iterator iterator = ServiceHelper.loadFactories(OpenAiLanguageModelBuilderFactory.class).iterator();
        if (iterator.hasNext()) {
            OpenAiLanguageModelBuilderFactory factory = (OpenAiLanguageModelBuilderFactory)iterator.next();
            return (OpenAiLanguageModelBuilder)factory.get();
        }
        return new OpenAiLanguageModelBuilder();
    }

    public static class OpenAiLanguageModelBuilder {
        private String baseUrl;
        private String apiKey;
        private String organizationId;
        private String modelName;
        private Double temperature;
        private Duration timeout;
        private Integer maxRetries;
        private Proxy proxy;
        private Boolean logRequests;
        private Boolean logResponses;
        private Tokenizer tokenizer;
        private Map<String, String> customHeaders;

        public OpenAiLanguageModelBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public OpenAiLanguageModelBuilder modelName(OpenAiLanguageModelName modelName) {
            this.modelName = modelName.toString();
            return this;
        }

        public OpenAiLanguageModelBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public OpenAiLanguageModelBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiLanguageModelBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public OpenAiLanguageModelBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public OpenAiLanguageModelBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OpenAiLanguageModelBuilder maxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public OpenAiLanguageModelBuilder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public OpenAiLanguageModelBuilder logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this;
        }

        public OpenAiLanguageModelBuilder logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this;
        }

        public OpenAiLanguageModelBuilder tokenizer(Tokenizer tokenizer) {
            this.tokenizer = tokenizer;
            return this;
        }

        public OpenAiLanguageModelBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public OpenAiLanguageModel build() {
            return new OpenAiLanguageModel(this.baseUrl, this.apiKey, this.organizationId, this.modelName, this.temperature, this.timeout, this.maxRetries, this.proxy, this.logRequests, this.logResponses, this.tokenizer, this.customHeaders);
        }

        public String toString() {
            return new StringJoiner(", ", OpenAiLanguageModelBuilder.class.getSimpleName() + "[", "]").add("baseUrl='" + this.baseUrl + "'").add("organizationId='" + this.organizationId + "'").add("modelName='" + this.modelName + "'").add("temperature=" + this.temperature).add("timeout=" + String.valueOf(this.timeout)).add("maxRetries=" + this.maxRetries).add("proxy=" + String.valueOf(this.proxy)).add("logRequests=" + this.logRequests).add("logResponses=" + this.logResponses).add("tokenizer=" + String.valueOf(this.tokenizer)).add("customHeaders=" + String.valueOf(this.customHeaders)).toString();
        }
    }
}

