/**
 * DSS - Digital Signature Services
 * Copyright (C) 2015 European Commission, provided under the CEF programme
 * 
 * This file is part of the "DSS - Digital Signature Services" project.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package eu.europa.esig.dss.model.x509.extension;

import eu.europa.esig.dss.enumerations.CertificateExtensionEnum;

/**
 * ETSI EN 319 412-1: "5.2.2 Validity Assured - Short Term"
 * This extension indicates that the validity of the certificate is assured because the certificate is a "short-term
 * certificate". That is, the time as indicated in the certificate attribute from notBefore through notAfter, inclusive,
 * is shorter than the maximum time to process a revocation request as specified by the certificate practice statement
 * or certificate policy.
 */
public class ValidityAssuredShortTerm extends CertificateExtension {

    private static final long serialVersionUID = -5778233789227661204L;

    /** Defines the value of ext-etsi-valassured-ST-certs extension */
    private boolean valAssuredSTCerts;

    /**
     * Default constructor
     */
    public ValidityAssuredShortTerm() {
        super(CertificateExtensionEnum.VALIDITY_ASSURED_SHORT_TERM.getOid());
    }

    /**
     * Returns the ext-etsi-valassured-ST-certs extension value
     *
     * @return TRUE if ext-etsi-valassured-ST-certs extension is present, FALSE otherwise
     */
    public boolean isValAssuredSTCerts() {
        return valAssuredSTCerts;
    }

    /**
     * Sets the ext-etsi-valassured-ST-certs extension value
     *
     * @param valAssuredSTCerts whether ext-etsi-valassured-ST-certs extension is present
     */
    public void setValAssuredSTCerts(boolean valAssuredSTCerts) {
        this.valAssuredSTCerts = valAssuredSTCerts;
    }

}
