/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.x509;

import eu.europa.esig.dss.enumerations.X520Attributes;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;

public class X500PrincipalHelper {
    private final X500Principal principal;

    public X500PrincipalHelper(X500Principal principal) {
        Objects.requireNonNull(principal, "X500Principal cannot be null!");
        this.principal = principal;
    }

    public X500Principal getPrincipal() {
        return this.principal;
    }

    public String getCanonical() {
        return this.principal.getName("CANONICAL");
    }

    public String getRFC2253() {
        return this.principal.getName("RFC2253");
    }

    public String getPrettyPrintRFC2253() {
        return this.principal.getName("RFC2253", X520Attributes.getOidDescriptions());
    }

    public byte[] getEncoded() {
        return this.principal.getEncoded();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.principal == null ? 0 : this.principal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X500PrincipalHelper other = (X500PrincipalHelper)obj;
        return !(this.principal == null ? other.principal != null : !this.principal.equals(other.principal));
    }
}

