/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime.standalone;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.quarkus.resteasy.runtime.ResteasyVertxConfig;
import io.quarkus.resteasy.runtime.standalone.BufferAllocator;
import io.quarkus.resteasy.runtime.standalone.ResteasyConfigurationMPConfig;
import io.quarkus.resteasy.runtime.standalone.VertxRequestHandler;
import io.quarkus.resteasy.runtime.standalone.VertxUtil;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.security.AuthenticationCompletionException;
import io.quarkus.security.AuthenticationException;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.AuthenticationRedirectException;
import io.quarkus.security.ForbiddenException;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import io.quarkus.vertx.http.runtime.HttpCompressionHandler;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.quarkus.vertx.http.runtime.security.HttpSecurityRecorder;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;

@Recorder
public class ResteasyStandaloneRecorder {
    static final String RESTEASY_URI_INFO = ResteasyUriInfo.class.getName();
    private static boolean useDirect = true;
    private static ResteasyDeployment deployment;
    private static String contextPath;
    final RuntimeValue<HttpConfiguration> readTimeout;

    public ResteasyStandaloneRecorder(RuntimeValue<HttpConfiguration> readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void staticInit(ResteasyDeployment dep, String path) {
        if (dep != null) {
            deployment = dep;
            deployment.getDefaultContextObjects().put(ResteasyConfiguration.class, new ResteasyConfigurationMPConfig());
            deployment.start();
        }
        contextPath = path;
    }

    public void start(ShutdownContext shutdown, boolean isVirtual) {
        shutdown.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                if (deployment != null) {
                    deployment.stop();
                }
            }
        });
        useDirect = !isVirtual;
    }

    public Handler<RoutingContext> vertxRequestHandler(Supplier<Vertx> vertx, Executor executor, ResteasyVertxConfig config, HttpBuildTimeConfig httpBuildTimeConfig) {
        if (deployment != null) {
            VertxRequestHandler handler = new VertxRequestHandler(vertx.get(), deployment, contextPath, new ResteasyVertxAllocator(config.responseBufferSize), executor, ((HttpConfiguration)this.readTimeout.getValue()).readTimeout.toMillis());
            Set compressMediaTypes = httpBuildTimeConfig.compressMediaTypes.map(Set::copyOf).orElse(Set.of());
            if (httpBuildTimeConfig.enableCompression && !compressMediaTypes.isEmpty()) {
                handler = new HttpCompressionHandler((Handler)handler, compressMediaTypes);
            }
            return handler;
        }
        return null;
    }

    public Handler<RoutingContext> vertxFailureHandler(Supplier<Vertx> vertx, Executor executor, ResteasyVertxConfig config, final boolean noCustomAuthCompletionExMapper, final boolean noCustomAuthFailureExMapper, final boolean noCustomAuthRedirectExMapper, final boolean proactive) {
        if (deployment == null) {
            return null;
        }
        return new VertxRequestHandler(vertx.get(), deployment, contextPath, new ResteasyVertxAllocator(config.responseBufferSize), executor, ((HttpConfiguration)this.readTimeout.getValue()).readTimeout.toMillis()){

            @Override
            public void handle(RoutingContext request) {
                if (proactive && request.get("io.quarkus.vertx.http.auth-failure-handler") instanceof HttpSecurityRecorder.DefaultAuthFailureHandler) {
                    if (request.failure() instanceof AuthenticationFailedException) {
                        if (noCustomAuthFailureExMapper) {
                            request.next();
                        } else {
                            super.handle(request);
                        }
                        return;
                    }
                    if (request.failure() instanceof AuthenticationCompletionException) {
                        if (noCustomAuthCompletionExMapper) {
                            request.next();
                        } else {
                            super.handle(request);
                        }
                        return;
                    }
                    if (request.failure() instanceof AuthenticationRedirectException) {
                        if (noCustomAuthRedirectExMapper) {
                            request.next();
                        } else {
                            super.handle(request);
                        }
                        return;
                    }
                }
                if (request.failure() instanceof AuthenticationException || request.failure() instanceof ForbiddenException) {
                    super.handle(request);
                } else {
                    request.next();
                }
            }

            @Override
            protected void setCurrentIdentityAssociation(RoutingContext routingContext) {
            }
        };
    }

    public Handler<RoutingContext> defaultAuthFailureHandler() {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext event) {
                if (deployment != null && event.get("io.quarkus.vertx.http.auth-failure-handler") instanceof HttpSecurityRecorder.DefaultAuthFailureHandler) {
                    try {
                        event.put(RESTEASY_URI_INFO, (Object)VertxUtil.extractUriInfo(event.request(), contextPath));
                    }
                    catch (Exception e) {
                        event.next();
                        return;
                    }
                    event.put("io.quarkus.vertx.http.auth-failure-handler", (Object)new BiConsumer<RoutingContext, Throwable>(){

                        @Override
                        public void accept(RoutingContext event, Throwable throwable) {
                            if (!event.failed()) {
                                event.fail(HttpSecurityRecorder.DefaultAuthFailureHandler.extractRootCause((Throwable)throwable));
                            }
                        }
                    });
                }
                event.next();
            }
        };
    }

    private static class ResteasyVertxAllocator
    implements BufferAllocator {
        private final int bufferSize;

        private ResteasyVertxAllocator(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        public ByteBuf allocateBuffer() {
            return this.allocateBuffer(useDirect);
        }

        @Override
        public ByteBuf allocateBuffer(boolean direct) {
            return this.allocateBuffer(direct, this.bufferSize);
        }

        @Override
        public ByteBuf allocateBuffer(int bufferSize) {
            return this.allocateBuffer(useDirect, bufferSize);
        }

        @Override
        public ByteBuf allocateBuffer(boolean direct, int bufferSize) {
            if (direct) {
                return PooledByteBufAllocator.DEFAULT.directBuffer(bufferSize);
            }
            return PooledByteBufAllocator.DEFAULT.heapBuffer(bufferSize);
        }

        @Override
        public int getBufferSize() {
            return this.bufferSize;
        }
    }
}

