/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Engine;
import io.quarkus.qute.ErrorCode;
import io.quarkus.qute.Qute;
import io.quarkus.qute.ReflectionValueResolver;
import io.quarkus.qute.TemplateInstance;
import io.quarkus.qute.TemplateNode;
import io.quarkus.qute.ValueResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class TemplateException
extends RuntimeException {
    private static final long serialVersionUID = 1336799943548973690L;
    private static Engine engine = Engine.builder().addDefaults().addValueResolver(new ReflectionValueResolver()).addValueResolver(ValueResolver.builder().applyToBaseClass(TemplateNode.Origin.class).applyToName("hasNonGeneratedTemplateId").resolveSync(ec -> ((TemplateNode.Origin)ec.getBase()).hasNonGeneratedTemplateId()).build()).addParserHook(new Qute.IndexedArgumentsParserHook(null)).build();
    private final TemplateNode.Origin origin;
    private final ErrorCode code;
    private final Map<String, Object> arguments;
    private final String messageTemplate;

    public static Builder builder() {
        return new Builder();
    }

    public TemplateException(Throwable cause) {
        this(null, null, null, null, cause);
    }

    public TemplateException(String message) {
        this(null, null, message, null, null);
    }

    public TemplateException(TemplateNode.Origin origin, String message) {
        this(null, origin, message, null, null);
    }

    public TemplateException(ErrorCode code, TemplateNode.Origin origin, String messageTemplate, Map<String, Object> arguments, Throwable cause) {
        super(TemplateException.toMessage(messageTemplate, arguments, origin), cause);
        this.origin = origin;
        this.code = code;
        this.messageTemplate = messageTemplate;
        this.arguments = arguments;
    }

    public TemplateNode.Origin getOrigin() {
        return this.origin;
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public Map<String, Object> getArguments() {
        return this.arguments;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public Optional<String> getCodeName() {
        return this.code == null ? Optional.empty() : Optional.ofNullable(this.code.getName());
    }

    private static String toMessage(String messageTemplate, Map<String, Object> arguments, TemplateNode.Origin origin) {
        if ((arguments == null || arguments.isEmpty()) && origin == null) {
            return messageTemplate;
        }
        try {
            TemplateInstance template = engine.parse(messageTemplate).instance();
            if (arguments != null) {
                arguments.forEach(template::data);
            }
            return template.data("origin", origin).render();
        }
        catch (Throwable t) {
            return "Cannot render error message: " + t;
        }
    }

    public static class Builder {
        private String message;
        private Throwable cause;
        private TemplateNode.Origin origin;
        private ErrorCode code;
        private final Map<String, Object> arguments = new HashMap<String, Object>();

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public Builder origin(TemplateNode.Origin origin) {
            this.origin = origin;
            return this;
        }

        public Builder code(ErrorCode code) {
            this.code = code;
            return this;
        }

        public Builder argument(String key, Object value) {
            this.arguments.put(key, value);
            return this;
        }

        public Builder arguments(Map<String, Object> arguments) {
            this.arguments.putAll(arguments);
            return this;
        }

        public Builder arguments(Object ... arguments) {
            return this.argument("data", arguments);
        }

        public TemplateException build() {
            return new TemplateException(this.code, this.origin, this.message, this.arguments, this.cause);
        }
    }
}

