/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.map.text.sourcemapper;

import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.SiddhiAppRuntimeException;
import io.siddhi.core.stream.input.source.AttributeMapping;
import io.siddhi.core.stream.input.source.InputEventHandler;
import io.siddhi.core.stream.input.source.SourceMapper;
import io.siddhi.core.util.AttributeConverter;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.query.api.annotation.Annotation;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import io.siddhi.query.api.exception.SiddhiAppValidationException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

@Extension(name="text", namespace="sourceMapper", description="This extension is a text to Siddhi event input mapper. Transports that accept text messages can utilize this extension to convert the incoming text message to Siddhi event. Users can either use a pre-defined text format where event conversion happens without any additional configurations, or specify a regex to map a text message using custom configurations.", parameters={@Parameter(name="regex.groupid", description="This parameter specifies a regular expression group. The `groupid` can be any capital letter (e.g., regex.A,regex.B .. etc). You can specify any number of regular expression groups. In the attribute annotation, you need to map all attributes to the regular expression group with the matching group index. If you need to to enable custom mapping, it is required to specifythe matching group for each and every attribute.", type={DataType.STRING}), @Parameter(name="fail.on.missing.attribute", description="This parameter specifies how unknown attributes should be handled. If it is set to `true` a message is dropped if its execution fails, or if one or more attributes do not have values. If this parameter is set to `false`, null values are assigned to attributes with missing values, and messages with such attributes are not dropped.", defaultValue="true", optional=true, type={DataType.BOOL}), @Parameter(name="event.grouping.enabled", description="This parameter specifies whether event grouping is enabled or not. To receive a group of events together and generate multiple events, this parameter must be set to `true`.", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="delimiter", description="This parameter specifies how events must be separated when multiple events are received. This must be whole line and not a single character.", type={DataType.STRING}, optional=true, defaultValue="~~~~~~~~~~"), @Parameter(name="new.line.character", description="This attribute indicates the new line character of the event that is expected to be received. This is used mostly when communication between 2 types of operating systems is expected. For example, Linux uses `\\n` as the end of line character whereas windows uses `\\r\\n`.", type={DataType.STRING}, optional=true, defaultValue="\\n")}, examples={@Example(syntax="@source(type='inMemory', topic='stock', @map(type='text'))\ndefine stream FooStream (symbol string, price float, volume long);", description="This query performs a default text input mapping. The expected input is as follows:\nsymbol:\"WSO2\",\nprice:55.6,\nvolume:100\nOR\nsymbol:'WSO2',\nprice:55.6,\nvolume:100\n\nIf group events is enabled then input should be as follows: \nsymbol:\"WSO2\",\nprice:55.6,\nvolume:100\n~~~~~~~~~~\nsymbol:\"WSO2\",\nprice:55.6,\nvolume:100"), @Example(syntax="@source(type='inMemory', topic='stock', @map(type='text', fail.on.missing.attribute = 'true', regex.A='(\\w+)\\s([-0-9]+)',regex.B='volume\\s([-0-9]+)', @attributes(symbol = 'A[1]',price = 'A[2]',volume = 'B')))\ndefine stream FooStream (symbol string, price float, volume long);", description="This query performs a custom text mapping. The expected input is as follows:\nwos2 550 volume 100\n\nIf group events is enabled then input should be as follows: \nwos2 550 volume 100\n~~~~~~~~~~\nwos2 550 volume 100\n~~~~~~~~~~\nwos2 550 volume 100\n")})
public class TextSourceMapper
extends SourceMapper {
    private static final Logger log = Logger.getLogger(TextSourceMapper.class);
    private static final String FAIL_ON_MISSING_ATTRIBUTE = "fail.on.missing.attribute";
    private static final String OPTION_GROUP_EVENTS = "event.grouping.enabled";
    private static final String OPTION_NEW_LINE = "new.line.character";
    private static final String REGULAR_EXPRESSION_GROUP = "regex.";
    private static final String OPTION_GROUP_EVENTS_DELIMITER = "delimiter";
    private static final String DEFAULT_NEW_LINE = "\n";
    private static final String DEFAULT_DELIMITER = "~~~~~~~~~~";
    private static final String DEFAULT_EVENT_GROUP = "false";
    private static final String DEFAULT_FALLON_MISSING_ATTRIBUTE = "true";
    private static final String REGEX_GROUP_OPENING_ELEMENT = "[";
    private static final String REGEX_GROUP_CLOSING_ELEMENT = "]";
    private static final String KEY_VALUE_SEPARATOR = ":";
    private static final String ATTRIBUTE_SEPARATOR = ",";
    private static final String EMPTY_STRING = "";
    private static final String REGEX_GROUP_SPLIT_REGEX_ELEMENT = "\\[";
    private static final String STRING_ENCLOSING_ELEMENT = "\"";
    private Map<String, Attribute.Type> attributeTypeMap = new HashMap<String, Attribute.Type>();
    private Map<String, Integer> attributePositionMap = new HashMap<String, Integer>();
    private Map<String, String> regexGroupMap = new HashMap<String, String>();
    private List<Attribute> attributeList;
    private AttributeConverter attributeConverter;
    private boolean isCustomMappingEnabled = false;
    private boolean eventGroupEnabled = false;
    private boolean failOnMissingAttribute;
    private StreamDefinition streamDefinition;
    private String eventDelimiter;
    private String endOfLine;
    private BitSet assignedPositionsBitSet;
    private String streamID;
    private List<AttributeMapping> attributeMappingList;

    public void init(StreamDefinition streamDefinition, OptionHolder optionHolder, List<AttributeMapping> attributeMappingList, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        this.streamID = streamDefinition.getId();
        this.attributeMappingList = attributeMappingList;
        this.attributeConverter = new AttributeConverter();
        this.streamDefinition = streamDefinition;
        this.attributeList = streamDefinition.getAttributeList();
        this.attributeTypeMap = new HashMap<String, Attribute.Type>(this.attributeList.size());
        this.attributePositionMap = new HashMap<String, Integer>(this.attributeList.size());
        this.eventGroupEnabled = Boolean.valueOf(optionHolder.validateAndGetStaticValue(OPTION_GROUP_EVENTS, DEFAULT_EVENT_GROUP));
        this.endOfLine = optionHolder.validateAndGetStaticValue(OPTION_NEW_LINE, DEFAULT_NEW_LINE);
        this.eventDelimiter = optionHolder.validateAndGetStaticValue(OPTION_GROUP_EVENTS_DELIMITER, DEFAULT_DELIMITER) + this.endOfLine;
        this.failOnMissingAttribute = Boolean.parseBoolean(optionHolder.validateAndGetStaticValue(FAIL_ON_MISSING_ATTRIBUTE, DEFAULT_FALLON_MISSING_ATTRIBUTE));
        for (Attribute attribute : this.attributeList) {
            this.attributeTypeMap.put(attribute.getName(), attribute.getType());
            this.attributePositionMap.put(attribute.getName(), streamDefinition.getAttributePosition(attribute.getName()));
        }
        if (attributeMappingList != null && attributeMappingList.size() > 0) {
            this.isCustomMappingEnabled = true;
            for (Element el : ((Annotation)((Annotation)streamDefinition.getAnnotations().get(0)).getAnnotations().get(0)).getElements()) {
                if (!el.getKey().contains(REGULAR_EXPRESSION_GROUP)) continue;
                this.regexGroupMap.put(el.getKey().replaceFirst(REGULAR_EXPRESSION_GROUP, EMPTY_STRING), el.getValue());
            }
            if (streamDefinition.getAttributeList().size() < attributeMappingList.size()) {
                throw new SiddhiAppValidationException("Stream: '" + streamDefinition.getId() + "' has " + streamDefinition.getAttributeList().size() + " attributes, but " + attributeMappingList.size() + " attribute mappings found. Each attribute should have one and only one mapping in the stream " + this.streamID + " of siddhi text input mapper.");
            }
        }
        this.assignedPositionsBitSet = new BitSet(this.attributePositionMap.size());
    }

    protected void mapAndProcess(Object eventObject, InputEventHandler inputEventHandler) throws InterruptedException {
        Object result = null;
        if (eventObject instanceof byte[]) {
            try {
                result = new String((byte[])eventObject, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)("Error is encountered while decoding the byte stream. Therefore, event is dropped by the testSource mapper. Please note that only UTF-8 encoding is supported. " + e.getMessage()), (Throwable)e);
            }
        } else {
            result = eventObject;
        }
        if (null != result) {
            if (!this.eventGroupEnabled) {
                this.onEventHandler(inputEventHandler, result);
            } else {
                int i;
                String[] allEvents = String.valueOf(result).split(this.eventDelimiter);
                for (i = 0; i < allEvents.length - 1; ++i) {
                    this.onEventHandler(inputEventHandler, allEvents[i].substring(0, allEvents[i].length() - this.endOfLine.length()));
                }
                this.onEventHandler(inputEventHandler, allEvents[i]);
            }
        }
    }

    protected boolean allowNullInTransportProperties() {
        return !this.failOnMissingAttribute;
    }

    public Class[] getSupportedInputEventClasses() {
        return new Class[]{String.class, byte[].class};
    }

    private void onEventHandler(InputEventHandler inputEventHandler, Object eventObject) {
        try {
            Event[] result = this.isCustomMappingEnabled ? this.convertToCustomEvents(String.valueOf(eventObject)) : this.convertToDefaultEvents(String.valueOf(eventObject));
            if (result.length != 0) {
                inputEventHandler.sendEvents(result);
            }
        }
        catch (Throwable e) {
            log.error((Object)("Exception occurred when converting Text message:" + eventObject + " to Siddhi Event in the stream " + this.streamID + " of siddhi text input mapper."), e);
        }
    }

    private String match(String text, int groupIndex, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        String matchedText = matcher.find() ? matcher.group(groupIndex) : null;
        return matchedText;
    }

    private Event[] convertToCustomEvents(Object eventObject) {
        AtomicBoolean isValidEvent = new AtomicBoolean();
        isValidEvent.set(true);
        ArrayList<Event> eventList = new ArrayList<Event>();
        Event event = new Event(this.streamDefinition.getAttributeList().size());
        Object[] data = event.getData();
        if (this.isCustomMappingEnabled) {
            String matchText = null;
            for (AttributeMapping attributeMapping : this.attributeMappingList) {
                if (attributeMapping.getMapping().contains(REGEX_GROUP_OPENING_ELEMENT) && attributeMapping.getMapping().contains(REGEX_GROUP_CLOSING_ELEMENT)) {
                    String[] regexGroupElements = attributeMapping.getMapping().replace(REGEX_GROUP_CLOSING_ELEMENT, EMPTY_STRING).split(REGEX_GROUP_SPLIT_REGEX_ELEMENT, 2);
                    String regexGroup = regexGroupElements[0];
                    int regexPosition = Integer.parseInt(regexGroupElements[1]);
                    String regex = this.regexGroupMap.get(regexGroup);
                    if (regex != null) {
                        try {
                            matchText = this.match((String)eventObject, regexPosition, this.regexGroupMap.get(regexGroup));
                        }
                        catch (IndexOutOfBoundsException e) {
                            log.error((Object)("Could not find group for " + regexPosition + " in the stream " + this.streamID + " of siddhi text input mapper."), (Throwable)e);
                            isValidEvent.set(false);
                        }
                    } else {
                        log.error((Object)("Could not find machine regular expression group for " + regexGroup + " for attribute " + attributeMapping.getName() + " in the stream " + this.streamID + " of siddhi text input mapper."));
                        isValidEvent.set(false);
                    }
                } else {
                    String regex = this.regexGroupMap.get(attributeMapping.getMapping());
                    if (regex != null) {
                        try {
                            matchText = this.match((String)eventObject, 1, this.regexGroupMap.get(attributeMapping.getMapping()));
                        }
                        catch (IndexOutOfBoundsException e) {
                            log.error((Object)("Could not find regular expression group index for " + attributeMapping.getMapping() + " in the stream " + this.streamID + " of siddhi text input mapper."), (Throwable)e);
                            isValidEvent.set(false);
                        }
                    } else {
                        log.error((Object)("Could not find machine regular expression group for " + attributeMapping.getMapping() + " for attribute " + attributeMapping.getMapping() + " in the stream " + this.streamID + " of siddhi text input mapper."));
                        isValidEvent.set(false);
                    }
                }
                if (this.failOnMissingAttribute && matchText == null) {
                    log.error((Object)("Invalid format of event " + eventObject + " for attribute " + attributeMapping.getName() + " could not find proper value while fail on missing attribute is 'true' in the stream " + this.streamID + " of siddhi text input mapper."));
                    isValidEvent.set(false);
                }
                int position = this.attributePositionMap.get(attributeMapping.getName());
                if (Attribute.Type.STRING != this.attributeTypeMap.get(attributeMapping.getName()) && matchText != null) {
                    data[position] = this.attributeConverter.getPropertyValue(matchText.replaceAll(ATTRIBUTE_SEPARATOR, EMPTY_STRING), this.attributeTypeMap.get(attributeMapping.getName()));
                    continue;
                }
                data[position] = matchText;
            }
        }
        if (isValidEvent.get()) {
            eventList.add(event);
        }
        return eventList.toArray(new Event[0]);
    }

    private Event[] convertToDefaultEvents(String eventObject) {
        AtomicBoolean isValidEvent = new AtomicBoolean();
        isValidEvent.set(true);
        ArrayList<Event> eventList = new ArrayList<Event>();
        Event event = new Event(this.streamDefinition.getAttributeList().size());
        Object[] data = event.getData();
        String[] events = eventObject.split(ATTRIBUTE_SEPARATOR + this.endOfLine);
        if (events.length < this.attributeList.size() && this.failOnMissingAttribute) {
            log.error((Object)("Invalid format of event because some required attributes are missing in event " + eventObject + " while needed attributes are " + this.attributeList.toString() + " in the stream " + this.streamID + " of siddhi text input mapper."));
            isValidEvent.set(false);
        }
        for (String event1 : events) {
            String[] eventObjects = event1.split(KEY_VALUE_SEPARATOR, 2);
            if (eventObjects.length != 2) continue;
            String key = eventObjects[0].trim();
            String value = eventObjects[1].trim();
            Integer position = this.attributePositionMap.get(key.trim());
            if (position == null || this.assignedPositionsBitSet.get(position)) continue;
            try {
                Attribute.Type attributeType = this.attributeTypeMap.get(key.trim());
                data[position.intValue()] = attributeType != Attribute.Type.STRING ? this.attributeConverter.getPropertyValue(value.replaceAll(ATTRIBUTE_SEPARATOR, EMPTY_STRING).trim(), attributeType) : value.trim().substring(STRING_ENCLOSING_ELEMENT.length(), value.length() - STRING_ENCLOSING_ELEMENT.length());
            }
            catch (SiddhiAppRuntimeException | ClassCastException | NumberFormatException e) {
                log.error((Object)("Incompatible data format. Because value is " + value + " and attribute type is " + this.attributeTypeMap.get(key.trim()).name() + " in the stream " + this.streamID + " of siddhi text input mapper."));
                isValidEvent.set(false);
            }
            this.assignedPositionsBitSet.flip(position);
        }
        if (events.length > this.assignedPositionsBitSet.length() && this.assignedPositionsBitSet.length() < this.attributeList.size() && this.failOnMissingAttribute) {
            log.error((Object)("Invalid format of event because some required attributes are missing while some unnecessary mappings are present" + eventObject + " in the stream " + this.streamID + " of siddhi text input mapper."));
            isValidEvent.set(false);
        }
        this.assignedPositionsBitSet.clear();
        if (isValidEvent.get()) {
            eventList.add(event);
        }
        return eventList.toArray(new Event[0]);
    }
}

