/*
 * Decompiled with CFR 0.152.
 */
package io.siddhi.extension.map.text.sinkmapper;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import io.siddhi.annotation.Example;
import io.siddhi.annotation.Extension;
import io.siddhi.annotation.Parameter;
import io.siddhi.annotation.util.DataType;
import io.siddhi.core.config.SiddhiAppContext;
import io.siddhi.core.event.Event;
import io.siddhi.core.exception.NoSuchAttributeException;
import io.siddhi.core.exception.SiddhiAppCreationException;
import io.siddhi.core.stream.output.sink.SinkListener;
import io.siddhi.core.stream.output.sink.SinkMapper;
import io.siddhi.core.util.config.ConfigReader;
import io.siddhi.core.util.transport.OptionHolder;
import io.siddhi.core.util.transport.TemplateBuilder;
import io.siddhi.query.api.annotation.Element;
import io.siddhi.query.api.definition.Attribute;
import io.siddhi.query.api.definition.StreamDefinition;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Extension(name="text", namespace="sinkMapper", description="This extension is a Event to Text output mapper. Transports that publish text messages can utilize this extension to convert the Siddhi events to text messages. Users can use a pre-defined text format where event conversion is carried out without any additional configurations, or use custom placeholder(using `{{` and `}}`) to map custom text messages. Again, you can also enable mustache based custom mapping. In mustache based custom mapping you can use custom placeholder (using `{{` and `}}` or `{{{` and `}}}`) to map custom text. In mustache based custom mapping, all variables are HTML escaped by default.\nFor example:\n`&` is replaced with `&amp;amp;`\n`\"` is replaced with `&amp;quot;`\n`=` is replaced with `&amp;#61;`\nIf you want to return unescaped HTML, use the triple mustache `{{{` instead of double `{{`.", parameters={@Parameter(name="event.grouping.enabled", description="If this parameter is set to `true`, events are grouped via a delimiter when multiple events are received. It is required to specify a value for the `delimiter` parameter when the value for this parameter is `true`.", type={DataType.BOOL}, optional=true, defaultValue="false"), @Parameter(name="delimiter", description="This parameter specifies how events are separated when a grouped event is received. This must be a whole line and not a single character.", type={DataType.STRING}, optional=true, defaultValue="~~~~~~~~~~"), @Parameter(name="new.line.character", description="This attribute indicates the new line character of the event that is expected to be received. This is used mostly when communication between 2 types of operating systems is expected. For example, Linux uses `\\n` whereas Windows uses `\\r\\n` as the end of line character.", type={DataType.STRING}, optional=true, defaultValue="\\n"), @Parameter(name="mustache.enabled", description="If this parameter is set to `true`, then mustache mapping gets enabled forcustom text mapping.", type={DataType.BOOL}, optional=true, defaultValue="false")}, examples={@Example(syntax="@sink(type='inMemory', topic='stock', @map(type='text'))\ndefine stream FooStream (symbol string, price float, volume long);", description="This query performs a default text input mapping. The expected output is as follows:\nsymbol:\"WSO2\",\nprice:55.6,\nvolume:100"), @Example(syntax="@sink(type='inMemory', topic='stock', @map(type='text', event.grouping.enabled='true'))\ndefine stream FooStream (symbol string, price float, volume long);", description="This query performs a default text input mapping with event grouping. The expected output is as follows:\nsymbol:\"WSO2\",\nprice:55.6,\nvolume:100\n~~~~~~~~~~\nsymbol:\"WSO2\",\nprice:55.6,\nvolume:100"), @Example(syntax="@sink(type='inMemory', topic='stock', @map(type='text',  @payload(\"SensorID : {{symbol}}/{{volume}}, SensorPrice : Rs{{price}}/=, Value : {{volume}}ml\")))\ndefine stream FooStream (symbol string, price float, volume long);", description="This query performs a custom text mapping. The expected output is as follows:\nSensorID : wso2/100, SensorPrice : Rs1000/=, Value : 100ml \nfor the following siddhi event.\n{wso2,1000,100}"), @Example(syntax="@sink(type='inMemory', topic='stock', @map(type='text', event.grouping.enabled='true', @payload(\"Stock price of {{symbol}} is {{price}}\")))\ndefine stream FooStream (symbol string, price float, volume long);", description="This query performs a custom text mapping with event grouping. The expected output is as follows:\nStock price of WSO2 is 55.6\n~~~~~~~~~~\nStock price of WSO2 is 55.6\n~~~~~~~~~~\nStock price of WSO2 is 55.6\nfor the following siddhi event.\n{WSO2,55.6,10}"), @Example(syntax="@sink(type='inMemory', topic='stock', @map(type='text', mustache.enabled='true',  @payload(\"SensorID : {{{symbol}}}/{{{volume}}}, SensorPrice : Rs{{{price}}}/=, Value : {{{volume}}}ml\")))\ndefine stream FooStream (symbol string, price float, volume long);", description="This query performs a custom text mapping to return unescaped HTML. The expected output is as follows:\nSensorID : a&b/100, SensorPrice : Rs1000/=, Value : 100ml \nfor the following siddhi event.\n{a&b,1000,100}")})
public class TextSinkMapper
extends SinkMapper {
    private static final Logger log = LogManager.getLogger(TextSinkMapper.class);
    private static final String EVENT_ATTRIBUTE_SEPARATOR = ",";
    private static final String STRING_ENCLOSING_ELEMENT = "\"";
    private static final String EVENT_ATTRIBUTE_VALUE_SEPARATOR = ":";
    private static final String OPTION_GROUP_EVENTS = "event.grouping.enabled";
    private static final String OPTION_MUSTACHE_MAPPING_ENABLED = "mustache.enabled";
    private static final String OPTION_GROUP_EVENTS_DELIMITER = "delimiter";
    private static final String DEFAULT_EVENTS_DELIMITER = "~~~~~~~~~~";
    private static final String DEFAULT_GROUP_EVENTS = "false";
    private static final String DEFAULT_MUSTACHE_MAPPING_ENABLED = "false";
    private static final String OPTION_NEW_LINE = "new.line.character";
    private static final String DEFAULT_NEW_LINE = "\n";
    private boolean eventGroupEnabled;
    private String eventDelimiter;
    private List<Attribute> attributeList;
    private String endOfLine;
    private String streamID;
    private Mustache mustache;
    private boolean mustacheMappingEnabled;
    private Map<String, Object> scopes = new HashMap<String, Object>();
    private List<Element> unmappedPayloadList;
    private boolean customMappingEnabled;

    public void init(StreamDefinition streamDefinition, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, ConfigReader mapperConfigReader, SiddhiAppContext siddhiAppContext) {
        this.mustacheMappingEnabled = Boolean.parseBoolean(optionHolder.validateAndGetStaticValue(OPTION_MUSTACHE_MAPPING_ENABLED, "false"));
        if (!this.mustacheMappingEnabled) {
            super.buildMapperTemplate(streamDefinition, this.unmappedPayloadList);
        }
        this.streamID = streamDefinition.getId();
        this.attributeList = streamDefinition.getAttributeList();
        this.eventGroupEnabled = Boolean.parseBoolean(optionHolder.validateAndGetStaticValue(OPTION_GROUP_EVENTS, "false"));
        this.endOfLine = optionHolder.validateAndGetStaticValue(OPTION_NEW_LINE, DEFAULT_NEW_LINE);
        this.eventDelimiter = optionHolder.validateAndGetStaticValue(OPTION_GROUP_EVENTS_DELIMITER, DEFAULT_EVENTS_DELIMITER) + this.endOfLine;
        if (payloadTemplateBuilderMap != null && payloadTemplateBuilderMap.size() != 1) {
            throw new SiddhiAppCreationException("Text sink-mapper does not support multiple @payload mappings, error at the mapper of '" + streamDefinition.getId() + "'");
        }
        if (payloadTemplateBuilderMap != null && payloadTemplateBuilderMap.get(payloadTemplateBuilderMap.keySet().iterator().next()).isObjectMessage()) {
            throw new SiddhiAppCreationException("Text sink-mapper does not support object @payload mappings, error at the mapper of '" + streamDefinition.getId() + "'");
        }
        if (this.mustacheMappingEnabled && this.unmappedPayloadList != null && this.unmappedPayloadList.size() > 0) {
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            String customTemplate = this.createCustomTemplate(this.getTemplateFromPayload(streamDefinition), this.eventGroupEnabled);
            this.mustache = mf.compile(new StringReader(customTemplate), "customEvent");
        }
    }

    protected void buildMapperTemplate(StreamDefinition streamDefinition, List<Element> unmappedPayloadList) {
        this.unmappedPayloadList = unmappedPayloadList;
        if (unmappedPayloadList != null && unmappedPayloadList.size() > 0) {
            this.customMappingEnabled = true;
        }
    }

    public String[] getSupportedDynamicOptions() {
        return new String[0];
    }

    public Class[] getOutputEventClasses() {
        return new Class[]{String.class};
    }

    public void mapAndSend(Event[] events, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, SinkListener sinkListener) {
        if (!this.eventGroupEnabled) {
            if (this.customMappingEnabled) {
                for (Event event : events) {
                    if (event == null) continue;
                    if (!this.mustacheMappingEnabled) {
                        sinkListener.publish(payloadTemplateBuilderMap.get(payloadTemplateBuilderMap.keySet().iterator().next()).build(event));
                        continue;
                    }
                    sinkListener.publish(this.constructCustomMapping(event));
                }
            } else {
                for (Event event : events) {
                    if (event == null) continue;
                    sinkListener.publish(this.constructDefaultMapping(event, false));
                }
            }
        } else {
            StringBuilder eventData = new StringBuilder();
            if (this.customMappingEnabled) {
                for (Event event : events) {
                    if (event == null) continue;
                    if (!this.mustacheMappingEnabled) {
                        eventData.append(payloadTemplateBuilderMap.get(payloadTemplateBuilderMap.keySet().iterator().next()).build(event)).append(this.endOfLine).append(this.eventDelimiter);
                        continue;
                    }
                    eventData.append(this.constructCustomMapping(event));
                }
            } else {
                for (Event event : events) {
                    if (event == null) continue;
                    eventData.append(this.constructDefaultMapping(event, true)).append(this.eventDelimiter);
                }
            }
            int idx = eventData.lastIndexOf(this.eventDelimiter);
            eventData.delete(idx - this.endOfLine.length(), idx + this.eventDelimiter.length());
            sinkListener.publish((Object)eventData.toString());
        }
    }

    public void mapAndSend(Event event, OptionHolder optionHolder, Map<String, TemplateBuilder> payloadTemplateBuilderMap, SinkListener sinkListener) {
        if (this.customMappingEnabled) {
            if (event != null) {
                if (!this.mustacheMappingEnabled) {
                    try {
                        sinkListener.publish(payloadTemplateBuilderMap.get(payloadTemplateBuilderMap.keySet().iterator().next()).build(event));
                    }
                    catch (NoSuchAttributeException e) {
                        log.error("Malformed event " + event.toString() + ". Hence proceed with null values in the stream " + this.streamID + " of siddhi text output mapper.");
                    }
                } else if (!this.eventGroupEnabled) {
                    sinkListener.publish(this.constructCustomMapping(event));
                } else {
                    StringBuilder eventData = new StringBuilder();
                    eventData.append(this.constructCustomMapping(event));
                    int idx = eventData.lastIndexOf(this.eventDelimiter);
                    eventData.delete(idx - this.endOfLine.length(), idx + this.eventDelimiter.length());
                    sinkListener.publish((Object)eventData.toString());
                }
            }
        } else if (event != null) {
            sinkListener.publish(this.constructDefaultMapping(event, false));
        }
    }

    private Object constructDefaultMapping(Event event, boolean isEventGroup) {
        StringBuilder eventText = new StringBuilder();
        Object[] data = event.getData();
        for (int i = 0; i < data.length; ++i) {
            Object attributeValue = data[i];
            Attribute attribute = this.attributeList.get(i);
            if (attributeValue != null && attribute.getType().equals((Object)Attribute.Type.STRING)) {
                eventText.append(attribute.getName()).append(EVENT_ATTRIBUTE_VALUE_SEPARATOR).append(STRING_ENCLOSING_ELEMENT).append(attributeValue.toString()).append(STRING_ENCLOSING_ELEMENT).append(EVENT_ATTRIBUTE_SEPARATOR).append(this.endOfLine);
                continue;
            }
            eventText.append(attribute.getName()).append(EVENT_ATTRIBUTE_VALUE_SEPARATOR).append(attributeValue).append(EVENT_ATTRIBUTE_SEPARATOR).append(this.endOfLine);
        }
        int idx = eventText.lastIndexOf(EVENT_ATTRIBUTE_SEPARATOR);
        if (!isEventGroup) {
            eventText.delete(idx, idx + (EVENT_ATTRIBUTE_SEPARATOR + this.endOfLine).length());
        } else {
            eventText.delete(idx, idx + EVENT_ATTRIBUTE_SEPARATOR.length());
        }
        return eventText.toString();
    }

    private Object constructCustomMapping(Event event) {
        StringWriter writer = new StringWriter();
        Object[] data = event.getData();
        for (int i = 0; i < data.length; ++i) {
            Object attributeValue = data[i];
            Attribute attribute = this.attributeList.get(i);
            this.scopes.put(attribute.getName(), attributeValue);
        }
        this.mustache.execute((Writer)writer, this.scopes);
        return ((Object)writer).toString();
    }

    private String getTemplateFromPayload(StreamDefinition streamDefinition) {
        return this.unmappedPayloadList.get(0).getValue();
    }

    private String createCustomTemplate(String customTemplate, boolean isEventGroup) {
        StringBuilder template = new StringBuilder();
        if (!isEventGroup) {
            template.append(customTemplate);
        } else {
            template.append(customTemplate).append(this.endOfLine).append(this.eventDelimiter);
        }
        return template.toString();
    }
}

