/*
 * Decompiled with CFR 0.152.
 */
package it.svario.xpathapi.jaxp;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

class NodeListIterator
implements NodeIterator {
    private final int INVALID = -2;
    private int position;
    private NodeList list;
    private int length;

    protected NodeListIterator(NodeList list) {
        this.list = list;
        this.length = list.getLength();
        this.position = 0;
    }

    @Override
    public void detach() {
        this.position = -2;
        this.list = null;
        this.length = 0;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return true;
    }

    @Override
    public NodeFilter getFilter() {
        return null;
    }

    @Override
    public Node getRoot() {
        return this.list.item(0);
    }

    @Override
    public int getWhatToShow() {
        return -1;
    }

    @Override
    public Node nextNode() throws DOMException {
        this.checkValidState("next");
        if (this.position >= this.length) {
            return null;
        }
        Node node = this.list.item(this.position);
        ++this.position;
        return node;
    }

    @Override
    public Node previousNode() throws DOMException {
        this.checkValidState("previous");
        if (this.position == 0) {
            return null;
        }
        --this.position;
        Node node = this.list.item(this.position);
        return node;
    }

    private void checkValidState(String direction) throws DOMException {
        if (this.position == -2) {
            String msg = "Called " + direction + "Node() after detach()";
            throw new DOMException(11, msg);
        }
    }
}

