/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component;

import com.sun.faces.facelets.tag.faces.ComponentSupport;
import com.sun.faces.util.Util;
import jakarta.el.ValueExpression;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.ContextCallback;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.SavedState;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIColumn;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.UniqueIdVendor;
import jakarta.faces.component.WrapperEvent;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PostValidateEvent;
import jakarta.faces.event.PreValidateEvent;
import jakarta.faces.model.ArrayDataModel;
import jakarta.faces.model.CollectionDataModel;
import jakarta.faces.model.DataModel;
import jakarta.faces.model.FacesDataModel;
import jakarta.faces.model.IterableDataModel;
import jakarta.faces.model.ListDataModel;
import jakarta.faces.model.ResultSetDataModel;
import jakarta.faces.model.ScalarDataModel;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UIData
extends UIComponentBase
implements NamingContainer,
UniqueIdVendor {
    public static final String COMPONENT_TYPE = "jakarta.faces.Data";
    public static final String COMPONENT_FAMILY = "jakarta.faces.Data";
    private static final ListDataModel EMPTY_DATA_MODEL = new ListDataModel(Collections.emptyList());
    private DataModel model = null;
    private Object oldVar;
    private String baseClientId = null;
    private int baseClientIdLength;
    private StringBuilder clientIdBuilder = null;
    private Boolean isNested = null;
    private Map<String, Object> _rowDeltaStates = new HashMap<String, Object>();
    private Map<String, Object> _rowTransientStates = new HashMap<String, Object>();
    private Object _initialDescendantFullComponentState = null;

    public UIData() {
        this.setRendererType("jakarta.faces.Table");
    }

    @Override
    public String getFamily() {
        return "jakarta.faces.Data";
    }

    public int getFirst() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.first), 0);
    }

    public void setFirst(int first) {
        if (first < 0) {
            throw new IllegalArgumentException(String.valueOf(first));
        }
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.first), first);
    }

    public UIComponent getFooter() {
        return this.getFacet("footer");
    }

    public void setFooter(UIComponent footer) {
        this.getFacets().put("footer", footer);
    }

    public UIComponent getHeader() {
        return this.getFacet("header");
    }

    public void setHeader(UIComponent header) {
        this.getFacets().put("header", header);
    }

    public boolean isRowAvailable() {
        return this.getDataModel().isRowAvailable();
    }

    public int getRowCount() {
        return this.getDataModel().getRowCount();
    }

    public Object getRowData() {
        return this.getDataModel().getRowData();
    }

    public int getRowIndex() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rowIndex), -1);
    }

    public void setRowIndex(int rowIndex) {
        if (this.isRowStatePreserved()) {
            this.setRowIndexRowStatePreserved(rowIndex);
        } else {
            this.setRowIndexWithoutRowStatePreserved(rowIndex);
        }
    }

    private void setRowIndexWithoutRowStatePreserved(int rowIndex) {
        String var;
        this.saveDescendantState();
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndex), rowIndex);
        DataModel localModel = this.getDataModel();
        localModel.setRowIndex(rowIndex);
        if (rowIndex == -1) {
            this.setDataModel(null);
        }
        if ((var = (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.var))) != null) {
            Map<String, Object> requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (rowIndex == -1) {
                this.oldVar = requestMap.remove(var);
            } else if (this.isRowAvailable()) {
                requestMap.put(var, this.getRowData());
            } else {
                requestMap.remove(var);
                if (null != this.oldVar) {
                    requestMap.put(var, this.oldVar);
                    this.oldVar = null;
                }
            }
        }
        this.restoreDescendantState();
    }

    private void setRowIndexRowStatePreserved(int rowIndex) {
        String var;
        if (rowIndex < -1) {
            throw new IllegalArgumentException("rowIndex is less than -1");
        }
        if (this.getRowIndex() == rowIndex) {
            return;
        }
        FacesContext facesContext = this.getFacesContext();
        if (this._initialDescendantFullComponentState != null) {
            Map sm = ComponentSupport.saveDescendantComponentStates((FacesContext)facesContext, null, this.getChildren().iterator(), StateHolder::saveState, (boolean)false);
            if (sm != null && !sm.isEmpty()) {
                this._rowDeltaStates.put(this.getContainerClientId(facesContext), sm);
            }
            if (this.getRowIndex() != -1) {
                this._rowTransientStates.put(this.getContainerClientId(facesContext), ComponentSupport.saveDescendantComponentStates((FacesContext)facesContext, null, this.getChildren().iterator(), UIComponent::saveTransientState, (boolean)false));
            }
        }
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowIndex), rowIndex);
        DataModel localModel = this.getDataModel();
        localModel.setRowIndex(rowIndex);
        if (rowIndex == -1) {
            this.setDataModel(null);
        }
        if ((var = (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.var))) != null) {
            Map<String, Object> requestMap = this.getFacesContext().getExternalContext().getRequestMap();
            if (rowIndex == -1) {
                this.oldVar = requestMap.remove(var);
            } else if (this.isRowAvailable()) {
                requestMap.put(var, this.getRowData());
            } else {
                requestMap.remove(var);
                if (null != this.oldVar) {
                    requestMap.put(var, this.oldVar);
                    this.oldVar = null;
                }
            }
        }
        if (this._initialDescendantFullComponentState != null) {
            Object rowState = this._rowDeltaStates.get(this.getContainerClientId(facesContext));
            if (rowState == null) {
                ComponentSupport.restoreFullDescendantComponentStates((FacesContext)facesContext, this.getChildren().iterator(), (Object)this._initialDescendantFullComponentState, (boolean)false);
            } else {
                ComponentSupport.restoreFullDescendantComponentDeltaStates((FacesContext)facesContext, this.getChildren().iterator(), (Object)rowState, (Object)this._initialDescendantFullComponentState, (boolean)false);
            }
            if (this.getRowIndex() == -1) {
                ComponentSupport.restoreTransientDescendantComponentStates((FacesContext)facesContext, this.getChildren().iterator(), null, (boolean)false);
            } else {
                rowState = this._rowTransientStates.get(this.getContainerClientId(facesContext));
                if (rowState == null) {
                    ComponentSupport.restoreTransientDescendantComponentStates((FacesContext)facesContext, this.getChildren().iterator(), null, (boolean)false);
                } else {
                    ComponentSupport.restoreTransientDescendantComponentStates((FacesContext)facesContext, this.getChildren().iterator(), (Map)((Map)rowState), (boolean)false);
                }
            }
        }
    }

    public int getRows() {
        return (Integer)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.rows), 0);
    }

    public void setRows(int rows) {
        if (rows < 0) {
            throw new IllegalArgumentException(String.valueOf(rows));
        }
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rows), rows);
    }

    public String getVar() {
        return (String)this.getStateHelper().get((Serializable)((Object)PropertyKeys.var));
    }

    public void setVar(String var) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.var), var);
    }

    public boolean isRowStatePreserved() {
        Boolean b = (Boolean)this.getStateHelper().get((Serializable)((Object)PropertyKeys.rowStatePreserved));
        return b != null && b != false;
    }

    public void setRowStatePreserved(boolean preserveComponentState) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.rowStatePreserved), preserveComponentState);
    }

    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)PropertyKeys.value));
    }

    public void setValue(Object value) {
        this.setDataModel(null);
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.value), value);
    }

    @Override
    public void setValueExpression(String name, ValueExpression binding) {
        if (null != name) {
            switch (name) {
                case "value": {
                    this.model = null;
                    break;
                }
                case "var": 
                case "rowIndex": {
                    throw new IllegalArgumentException();
                }
            }
        }
        super.setValueExpression(name, binding);
    }

    @Override
    public String getClientId(FacesContext context) {
        int rowIndex;
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.baseClientId == null && this.clientIdBuilder == null) {
            if (!this.isNestedWithinIterator(context).booleanValue()) {
                this.clientIdBuilder = new StringBuilder(super.getClientId(context));
                this.baseClientId = this.clientIdBuilder.toString();
                this.baseClientIdLength = this.baseClientId.length() + 1;
                this.clientIdBuilder.append(UINamingContainer.getSeparatorChar(context));
                this.clientIdBuilder.setLength(this.baseClientIdLength);
            } else {
                this.clientIdBuilder = new StringBuilder();
            }
        }
        if ((rowIndex = this.getRowIndex()) >= 0) {
            String cid;
            if (!this.isNestedWithinIterator(context).booleanValue()) {
                cid = this.clientIdBuilder.append(rowIndex).toString();
                this.clientIdBuilder.setLength(this.baseClientIdLength);
            } else {
                cid = this.clientIdBuilder.append(super.getClientId(context)).append(UINamingContainer.getSeparatorChar(context)).append(rowIndex).toString();
                this.clientIdBuilder.setLength(0);
            }
            return cid;
        }
        if (!this.isNestedWithinIterator(context).booleanValue()) {
            return this.baseClientId;
        }
        return super.getClientId(context);
    }

    @Override
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        if (null == context || null == clientId || null == callback) {
            throw new NullPointerException();
        }
        String myId = super.getClientId(context);
        boolean found = false;
        if (clientId.equals(myId)) {
            try {
                this.pushComponentToEL(context, this.compositeParent);
                callback.invokeContextCallback(context, this);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
            finally {
                this.popComponentFromEL(context);
            }
        }
        if (this.getFacetCount() > 0) {
            for (UIComponent c : this.getFacets().values()) {
                if (!clientId.equals(c.getClientId(context))) continue;
                callback.invokeContextCallback(context, c);
                return true;
            }
        }
        if (this.getChildCount() > 0) {
            for (UIComponent column : this.getChildren()) {
                if (!(column instanceof UIColumn) || column.getFacetCount() <= 0) continue;
                for (UIComponent facet : column.getFacets().values()) {
                    if (!facet.invokeOnComponent(context, clientId, callback)) continue;
                    return true;
                }
            }
        }
        if (this.getChildCount() > 0) {
            for (UIComponent column : this.getChildren()) {
                if (!(column instanceof UIColumn) || !column.invokeOnComponent(context, clientId, callback)) continue;
                return true;
            }
        }
        int savedRowIndex = this.getRowIndex();
        char sepChar = UINamingContainer.getSeparatorChar(context);
        if (myId.endsWith(sepChar + Integer.toString(savedRowIndex, 10))) {
            int lastSep = myId.lastIndexOf(sepChar);
            assert (-1 != lastSep);
            myId = myId.substring(0, lastSep);
        }
        if (clientId.startsWith(myId)) {
            try {
                int newRow;
                try {
                    newRow = Util.extractFirstNumericSegment((String)clientId.substring(myId.length()), (char)sepChar);
                }
                catch (NumberFormatException ex) {
                    String message = "Trying to extract rowIndex from clientId '" + clientId + "' " + ex.getMessage();
                    throw new NumberFormatException(message);
                }
                this.setRowIndex(newRow);
                if (this.isRowAvailable()) {
                    found = super.invokeOnComponent(context, clientId, callback);
                }
            }
            catch (FacesException fe) {
                throw fe;
            }
            catch (NumberFormatException e) {
                throw new FacesException(e);
            }
            finally {
                this.setRowIndex(savedRowIndex);
            }
        }
        return found;
    }

    @Override
    public void queueEvent(FacesEvent event) {
        super.queueEvent(new WrapperEvent(this, event, this.getRowIndex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcast(FacesEvent event) throws AbortProcessingException {
        boolean needsToSetIndex;
        if (!(event instanceof WrapperEvent)) {
            super.broadcast(event);
            return;
        }
        FacesContext context = event.getFacesContext();
        WrapperEvent revent = (WrapperEvent)event;
        if (this.isNestedWithinIterator(context).booleanValue()) {
            this.setDataModel(null);
        }
        int currentRowIndex = this.getRowIndex();
        int broadcastedRowIndex = revent.getRowIndex();
        boolean bl = needsToSetIndex = currentRowIndex != -1 || broadcastedRowIndex != -1;
        if (needsToSetIndex) {
            this.setRowIndex(broadcastedRowIndex);
        }
        FacesEvent rowEvent = revent.getFacesEvent();
        UIComponent source = rowEvent.getComponent();
        UIComponent compositeParent = null;
        try {
            if (!UIComponent.isCompositeComponent(source)) {
                compositeParent = UIComponent.getCompositeComponentParent(source);
            }
            if (compositeParent != null) {
                compositeParent.pushComponentToEL(context, null);
            }
            source.pushComponentToEL(context, null);
            source.broadcast(rowEvent);
        }
        finally {
            source.popComponentFromEL(context);
            if (compositeParent != null) {
                compositeParent.popComponentFromEL(context);
            }
        }
        if (needsToSetIndex) {
            this.setRowIndex(currentRowIndex);
        }
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        this.preEncode(context);
        super.encodeBegin(context);
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, this);
        this.preDecode(context);
        this.iterate(context, PhaseId.APPLY_REQUEST_VALUES);
        this.decode(context);
        this.popComponentFromEL(context);
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, this);
        Application app = context.getApplication();
        app.publishEvent(context, PreValidateEvent.class, this);
        this.preValidate(context);
        this.iterate(context, PhaseId.PROCESS_VALIDATIONS);
        app.publishEvent(context, PostValidateEvent.class, this);
        this.popComponentFromEL(context);
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, this);
        this.preUpdate(context);
        this.iterate(context, PhaseId.UPDATE_MODEL_VALUES);
        this.popComponentFromEL(context);
    }

    @Override
    public String createUniqueId(FacesContext context, String seed) {
        Integer i = (Integer)this.getStateHelper().get((Serializable)((Object)PropertyKeys.lastId));
        int lastId = i != null ? i : 0;
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.lastId), ++lastId);
        return "j_id" + (Serializable)(seed == null ? Integer.valueOf(lastId) : seed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        if (!this.isVisitable(context)) {
            return false;
        }
        FacesContext facesContext = context.getFacesContext();
        boolean visitRows = this.requiresRowIteration(context);
        int oldRowIndex = -1;
        if (visitRows) {
            oldRowIndex = this.getRowIndex();
            this.setRowIndex(-1);
        }
        this.pushComponentToEL(facesContext, null);
        try {
            VisitResult result = context.invokeVisitCallback(this, callback);
            if (result == VisitResult.COMPLETE) {
                boolean bl = true;
                return bl;
            }
            if (result == VisitResult.ACCEPT && this.doVisitChildren(context, visitRows)) {
                if (this.visitFacets(context, callback, visitRows)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.visitColumnsAndColumnFacets(context, callback, visitRows)) {
                    boolean bl = true;
                    return bl;
                }
                if (this.visitRows(context, callback, visitRows)) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            this.popComponentFromEL(facesContext);
            if (visitRows) {
                this.setRowIndex(oldRowIndex);
            }
        }
        return false;
    }

    @Override
    public void markInitialState() {
        if (this.isRowStatePreserved() && this.getFacesContext().getAttributes().containsKey("jakarta.faces.IS_BUILDING_INITIAL_STATE")) {
            this._initialDescendantFullComponentState = ComponentSupport.saveDescendantInitialComponentStates((FacesContext)this.getFacesContext(), this.getChildren().iterator(), (boolean)false);
        }
        super.markInitialState();
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        Object restoredRowStates = UIComponentBase.restoreAttachedState(context, values[1]);
        if (restoredRowStates == null) {
            if (!this._rowDeltaStates.isEmpty()) {
                this._rowDeltaStates.clear();
            }
        } else {
            this._rowDeltaStates = (Map)restoredRowStates;
        }
    }

    private void resetClientIds(UIComponent component) {
        Iterator<UIComponent> iterator = component.getFacetsAndChildren();
        while (iterator.hasNext()) {
            UIComponent child = iterator.next();
            this.resetClientIds(child);
            child.setId(child.getId());
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        this.resetClientIds(this);
        if (this.initialStateMarked()) {
            Object superState = super.saveState(context);
            if (superState == null && this._rowDeltaStates.isEmpty()) {
                return null;
            }
            Object[] values = null;
            Object attachedState = UIComponentBase.saveAttachedState(context, this._rowDeltaStates);
            if (superState != null || attachedState != null) {
                values = new Object[]{superState, attachedState};
            }
            return values;
        }
        Object[] values = new Object[]{super.saveState(context), UIComponentBase.saveAttachedState(context, this._rowDeltaStates)};
        return values;
    }

    protected DataModel getDataModel() {
        if (this.model != null) {
            return this.model;
        }
        Object current = this.getValue();
        if (current == null) {
            this.setDataModel(EMPTY_DATA_MODEL);
        } else if (current instanceof DataModel) {
            this.setDataModel((DataModel)current);
        } else if (current instanceof List) {
            this.setDataModel(new ListDataModel((List)current));
        } else if (Object[].class.isAssignableFrom(current.getClass())) {
            this.setDataModel(new ArrayDataModel<Object>((Object[])current));
        } else if (current instanceof ResultSet) {
            this.setDataModel(new ResultSetDataModel((ResultSet)current));
        } else if (current instanceof Collection) {
            this.setDataModel(new CollectionDataModel((Collection)current));
        } else if (current instanceof Iterable) {
            this.setDataModel(new IterableDataModel((Iterable)current));
        } else if (current instanceof Map) {
            this.setDataModel(new IterableDataModel(((Map)current).entrySet()));
        } else {
            DataModel<?> dataModel = this.createDataModel(current.getClass());
            if (dataModel != null) {
                dataModel.setWrappedData(current);
                this.setDataModel(dataModel);
            } else {
                this.setDataModel(new ScalarDataModel<Object>(current));
            }
        }
        return this.model;
    }

    private DataModel<?> createDataModel(Class<?> forClass) {
        ArrayList dataModel = new ArrayList(1);
        CDI cdi = CDI.current();
        this.getDataModelClassesMap((CDI<Object>)cdi).entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(forClass)).findFirst().ifPresent(e -> dataModel.add((DataModel)cdi.select((Class)e.getValue(), new Annotation[]{new FacesDataModelAnnotationLiteral((Class)e.getKey())}).get()));
        return dataModel.isEmpty() ? null : (DataModel)dataModel.get(0);
    }

    private Map<Class<?>, Class<? extends DataModel<?>>> getDataModelClassesMap(CDI<Object> cdi) {
        BeanManager beanManager = cdi.getBeanManager();
        Bean bean = beanManager.resolve(beanManager.getBeans("comSunFacesDataModelClassesMap"));
        Object beanReference = beanManager.getReference(bean, Map.class, beanManager.createCreationalContext((Contextual)bean));
        return (Map)beanReference;
    }

    protected void setDataModel(DataModel dataModel) {
        this.model = dataModel;
    }

    private boolean requiresRowIteration(VisitContext ctx) {
        return !ctx.getHints().contains((Object)VisitHint.SKIP_ITERATION);
    }

    private void preDecode(FacesContext context) {
        this.setDataModel(null);
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (null == saved || !this.keepSaved(context)) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.saved));
        }
    }

    private void preValidate(FacesContext context) {
        if (this.isNestedWithinIterator(context).booleanValue()) {
            this.setDataModel(null);
        }
    }

    private void preUpdate(FacesContext context) {
        if (this.isNestedWithinIterator(context).booleanValue()) {
            this.setDataModel(null);
        }
    }

    private void preEncode(FacesContext context) {
        this.setDataModel(null);
        if (!this.keepSaved(context)) {
            this.getStateHelper().remove((Serializable)((Object)PropertyKeys.saved));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void iterate(FacesContext context, PhaseId phaseId) {
        void var4_9;
        this.setRowIndex(-1);
        if (this.getFacetCount() > 0) {
            for (UIComponent uIComponent : this.getFacets().values()) {
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    uIComponent.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    uIComponent.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    uIComponent.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        ArrayList<UIColumn> renderedColumns = new ArrayList<UIColumn>(this.getChildCount());
        if (this.getChildCount() > 0) {
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UIColumn) || !child.isRendered()) continue;
                renderedColumns.add((UIColumn)child);
            }
        }
        this.setRowIndex(-1);
        for (UIColumn column : renderedColumns) {
            if (column.getFacetCount() <= 0) continue;
            for (UIComponent columnFacet : column.getFacets().values()) {
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    columnFacet.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    columnFacet.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    columnFacet.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        boolean bl = false;
        int rowIndex = this.getFirst() - 1;
        int rows = this.getRows();
        while (rows <= 0 || ++var4_9 <= rows) {
            this.setRowIndex(++rowIndex);
            if (!this.isRowAvailable()) break;
            for (UIColumn kid : renderedColumns) {
                if (kid.getChildCount() <= 0) continue;
                for (UIComponent grandkid : kid.getChildren()) {
                    if (!grandkid.isRendered()) continue;
                    if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                        grandkid.processDecodes(context);
                        continue;
                    }
                    if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                        grandkid.processValidators(context);
                        continue;
                    }
                    if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                        grandkid.processUpdates(context);
                        continue;
                    }
                    throw new IllegalArgumentException();
                }
            }
        }
        this.setRowIndex(-1);
    }

    private boolean doVisitChildren(VisitContext context, boolean visitRows) {
        if (visitRows) {
            this.setRowIndex(-1);
        }
        Collection<String> idsToVisit = context.getSubtreeIdsToVisit(this);
        assert (idsToVisit != null);
        return !idsToVisit.isEmpty();
    }

    private boolean visitFacets(VisitContext context, VisitCallback callback, boolean visitRows) {
        if (visitRows) {
            this.setRowIndex(-1);
        }
        if (this.getFacetCount() > 0) {
            for (UIComponent facet : this.getFacets().values()) {
                if (!facet.visitTree(context, callback)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean visitColumnsAndColumnFacets(VisitContext context, VisitCallback callback, boolean visitRows) {
        if (visitRows) {
            this.setRowIndex(-1);
        }
        if (this.getChildCount() > 0) {
            for (UIComponent column : this.getChildren()) {
                if (!(column instanceof UIColumn)) continue;
                VisitResult result = context.invokeVisitCallback(column, callback);
                if (result == VisitResult.COMPLETE) {
                    return true;
                }
                if (column.getFacetCount() <= 0) continue;
                for (UIComponent columnFacet : column.getFacets().values()) {
                    if (!columnFacet.visitTree(context, callback)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean visitRows(VisitContext context, VisitCallback callback, boolean visitRows) {
        int processed = 0;
        int rowIndex = 0;
        int rows = 0;
        if (visitRows) {
            rowIndex = this.getFirst() - 1;
            rows = this.getRows();
        }
        do {
            if (visitRows) {
                if (rows > 0 && ++processed > rows) break;
                this.setRowIndex(++rowIndex);
                if (!this.isRowAvailable()) break;
            }
            if (this.getChildCount() <= 0) continue;
            for (UIComponent kid : this.getChildren()) {
                if (!(kid instanceof UIColumn) || kid.getChildCount() <= 0) continue;
                for (UIComponent grandkid : kid.getChildren()) {
                    if (!grandkid.visitTree(context, callback)) continue;
                    return true;
                }
            }
        } while (visitRows);
        return false;
    }

    private boolean keepSaved(FacesContext context) {
        return this.contextHasErrorMessages(context) || this.isNestedWithinIterator(context) != false;
    }

    private Boolean isNestedWithinIterator(FacesContext context) {
        if (this.isNested == null) {
            this.isNested = Util.isNestedInIterator((FacesContext)context, (UIComponent)this);
        }
        return this.isNested;
    }

    private boolean contextHasErrorMessages(FacesContext context) {
        FacesMessage.Severity sev = context.getMaximumSeverity();
        return sev != null && FacesMessage.SEVERITY_ERROR.compareTo(sev) >= 0;
    }

    private void restoreDescendantState() {
        FacesContext context = this.getFacesContext();
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                if (!(kid instanceof UIColumn)) continue;
                this.restoreDescendantState(kid, context);
            }
        }
    }

    private void restoreDescendantState(UIComponent component, FacesContext context) {
        String id = component.getId();
        component.setId(id);
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)((Object)component);
            clientId = component.getClientId(context);
            SavedState savedState = state = saved == null ? null : (SavedState)saved.get(clientId);
            if (state == null) {
                input.resetValue();
            } else {
                input.setValue(state.getValue());
                input.setValid(state.isValid());
                input.setSubmittedValue(state.getSubmittedValue());
                input.setLocalValueSet(state.isLocalValueSet());
            }
        } else if (component instanceof UIForm) {
            UIForm form = (UIForm)component;
            clientId = component.getClientId(context);
            SavedState savedState = state = saved == null ? null : (SavedState)saved.get(clientId);
            if (state == null) {
                form.setSubmitted(false);
            } else {
                form.setSubmitted(state.getSubmitted());
            }
        }
        if (component.getChildCount() > 0) {
            for (UIComponent kid : component.getChildren()) {
                this.restoreDescendantState(kid, context);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.restoreDescendantState(facet, context);
            }
        }
    }

    private void saveDescendantState() {
        FacesContext context = this.getFacesContext();
        if (this.getChildCount() > 0) {
            for (UIComponent kid : this.getChildren()) {
                if (!(kid instanceof UIColumn)) continue;
                this.saveDescendantState(kid, context);
            }
        }
    }

    private void saveDescendantState(UIComponent component, FacesContext context) {
        Map saved = (Map)this.getStateHelper().get((Serializable)((Object)PropertyKeys.saved));
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)((Object)component);
            SavedState state = null;
            String clientId = component.getClientId(context);
            if (saved == null) {
                state = new SavedState();
            }
            if (state == null && (state = (SavedState)saved.get(clientId)) == null) {
                state = new SavedState();
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
            if (state.hasDeltaState()) {
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), clientId, state);
            } else if (saved != null) {
                this.getStateHelper().remove((Serializable)((Object)PropertyKeys.saved), clientId);
            }
        } else if (component instanceof UIForm) {
            UIForm form = (UIForm)component;
            String clientId = component.getClientId(context);
            SavedState state = null;
            if (saved == null) {
                state = new SavedState();
            }
            if (state == null && (state = (SavedState)saved.get(clientId)) == null) {
                state = new SavedState();
            }
            state.setSubmitted(form.isSubmitted());
            if (state.hasDeltaState()) {
                this.getStateHelper().put((Serializable)((Object)PropertyKeys.saved), clientId, state);
            } else if (saved != null) {
                this.getStateHelper().remove((Serializable)((Object)PropertyKeys.saved), clientId);
            }
        }
        if (component.getChildCount() > 0) {
            for (UIComponent uiComponent : component.getChildren()) {
                this.saveDescendantState(uiComponent, context);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                this.saveDescendantState(facet, context);
            }
        }
    }

    static enum PropertyKeys {
        first,
        rowIndex,
        rows,
        saved,
        value,
        var,
        lastId,
        rowStatePreserved;

    }

    private static class FacesDataModelAnnotationLiteral
    extends AnnotationLiteral<FacesDataModel>
    implements FacesDataModel {
        private static final long serialVersionUID = 1L;
        private final Class<?> forClass;

        public FacesDataModelAnnotationLiteral(Class<?> forClass) {
            this.forClass = forClass;
        }

        @Override
        public Class<?> forClass() {
            return this.forClass;
        }
    }
}

