/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.ConditionalTrainer;
import edu.berkeley.nlp.PCFGLA.ConstrainedTwoChartsParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveBinaryRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveUnaryRule;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.Linearizer;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ScalingTools;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedHierarchicalTwoChartParser
extends ConstrainedTwoChartsParser {
    protected double[][][][][] h_iScorePreU;
    protected double[][][][][] h_iScorePostU;
    protected double[][][][][] h_oScorePreU;
    protected double[][][][][] h_oScorePostU;
    int finalLevel;
    int[] substatesToCover;

    public ConstrainedHierarchicalTwoChartParser(Grammar gr, Lexicon lex, SpanPredictor sp, int f) {
        super(gr, lex, sp);
        this.finalLevel = f;
        this.substatesToCover = new int[this.finalLevel + 1];
        int i = 0;
        while (i <= this.finalLevel) {
            this.substatesToCover[i] = (int)Math.pow(2.0, this.finalLevel - i);
            ++i;
        }
    }

    @Override
    void doConstrainedInsideScores(boolean viterbi) {
        this.doConstrainedInsideScores(viterbi, null);
    }

    @Override
    void doConstrainedInsideScores(boolean viterbi, double[][][] spanScores) {
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int np;
                int nParentStates;
                int end = start + diff;
                int pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if (diff != 1 && this.allowedSubStates[start][end][pState] != null) {
                        BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                        nParentStates = this.numSubStatesArray[pState];
                        boolean somethingChanged = false;
                        int i = 0;
                        while (i < parentRules.length) {
                            boolean iPossibleL;
                            HierarchicalAdaptiveBinaryRule r = (HierarchicalAdaptiveBinaryRule)parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (iPossibleL) {
                                boolean iPossibleR;
                                int narrowL = this.narrowLExtent[end][rState];
                                boolean bl2 = iPossibleR = narrowL >= narrowR;
                                if (iPossibleR) {
                                    int min;
                                    int min1 = narrowR;
                                    int min2 = this.wideLExtent[end][rState];
                                    int n = min = min1 > min2 ? min1 : min2;
                                    if (min <= narrowL) {
                                        int max;
                                        int max1 = this.wideRExtent[start][lState];
                                        int max2 = narrowL;
                                        int n2 = max = max1 < max2 ? max1 : max2;
                                        if (min <= max) {
                                            int split = min;
                                            while (split <= max) {
                                                boolean changeThisRound = false;
                                                if (this.allowedSubStates[start][split][lState] != null && this.allowedSubStates[split][end][rState] != null && (changeThisRound = this.computeInsideScore(start, split, end, r, viterbi))) {
                                                    somethingChanged = true;
                                                    int parentScale = this.iScale[start][end][pState];
                                                    int currentScale = this.iScale[start][split][lState] + this.iScale[split][end][rState];
                                                    if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                                        if (parentScale == Integer.MIN_VALUE) {
                                                            this.iScale[start][end][pState] = currentScale;
                                                        } else {
                                                            int newScale = Math.max(currentScale, parentScale);
                                                            ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                                            ScalingTools.scaleArrayToScale(this.h_iScorePreU[start][end][pState][this.finalLevel], parentScale, newScale);
                                                            this.iScale[start][end][pState] = newScale;
                                                        }
                                                    }
                                                    int np2 = 0;
                                                    while (np2 < nParentStates) {
                                                        if (viterbi) {
                                                            this.h_iScorePreU[start][end][pState][this.finalLevel][np2] = Math.max(this.h_iScorePreU[start][end][pState][this.finalLevel][np2], this.unscaledScoresToAdd[np2]);
                                                        } else {
                                                            double[] dArray = this.h_iScorePreU[start][end][pState][this.finalLevel];
                                                            int n3 = np2;
                                                            dArray[n3] = dArray[n3] + this.unscaledScoresToAdd[np2];
                                                        }
                                                        ++np2;
                                                    }
                                                    Arrays.fill(this.unscaledScoresToAdd, 0.0);
                                                }
                                                ++split;
                                            }
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                        if (somethingChanged) {
                            double val;
                            if (spanScores != null && (val = spanScores[start][end][this.stateClass[pState]]) != 1.0) {
                                np = 0;
                                while (np < nParentStates) {
                                    double[] dArray = this.h_iScorePreU[start][end][pState][this.finalLevel];
                                    int n = np++;
                                    dArray[n] = dArray[n] * val;
                                }
                            }
                            this.updateHierarchy(this.h_iScorePreU[start][end][pState]);
                            if (start > this.narrowLExtent[end][pState]) {
                                this.narrowLExtent[end][pState] = start;
                                this.wideLExtent[end][pState] = start;
                            } else if (start < this.wideLExtent[end][pState]) {
                                this.wideLExtent[end][pState] = start;
                            }
                            if (end < this.narrowRExtent[start][pState]) {
                                this.narrowRExtent[start][pState] = end;
                                this.wideRExtent[start][pState] = end;
                            } else if (end > this.wideRExtent[start][pState]) {
                                this.wideRExtent[start][pState] = end;
                            }
                        }
                    }
                    ++pState;
                }
                pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if ((diff != this.length || pState == 0) && this.allowedSubStates[start][end][pState] != null) {
                        int parentScale;
                        UnaryRule[] unaries = this.grammar.getClosedSumUnaryRulesByParent(pState);
                        nParentStates = this.numSubStatesArray[pState];
                        int scaleBeforeUnaries = parentScale = this.iScale[start][end][pState];
                        boolean somethingChanged = false;
                        int r = 0;
                        while (r < unaries.length) {
                            boolean changeThisRound;
                            HierarchicalAdaptiveUnaryRule ur = (HierarchicalAdaptiveUnaryRule)unaries[r];
                            short cState = ur.childState;
                            if (pState != cState && this.allowedSubStates[start][end][cState] != null && this.h_iScorePreU[start][end][cState] != null && (changeThisRound = this.computeInsideScore(start, end, ur, viterbi))) {
                                somethingChanged = true;
                                int currentScale = this.iScale[start][end][cState];
                                if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                    if (parentScale == Integer.MIN_VALUE) {
                                        parentScale = currentScale;
                                    } else {
                                        int newScale = Math.max(currentScale, parentScale);
                                        ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                        ScalingTools.scaleArrayToScale(this.h_iScorePostU[start][end][pState][this.finalLevel], parentScale, newScale);
                                        parentScale = newScale;
                                    }
                                }
                                int np3 = 0;
                                while (np3 < nParentStates) {
                                    if (viterbi) {
                                        this.h_iScorePostU[start][end][pState][this.finalLevel][np3] = Math.max(this.h_iScorePostU[start][end][pState][this.finalLevel][np3], this.unscaledScoresToAdd[np3]);
                                    } else {
                                        double[] dArray = this.h_iScorePostU[start][end][pState][this.finalLevel];
                                        int n = np3;
                                        dArray[n] = dArray[n] + this.unscaledScoresToAdd[np3];
                                    }
                                    ++np3;
                                }
                                Arrays.fill(this.unscaledScoresToAdd, 0.0);
                            }
                            ++r;
                        }
                        if (somethingChanged) {
                            int newScale = Math.max(scaleBeforeUnaries, parentScale);
                            ScalingTools.scaleArrayToScale(this.h_iScorePreU[start][end][pState][this.finalLevel], scaleBeforeUnaries, newScale);
                            ScalingTools.scaleArrayToScale(this.h_iScorePostU[start][end][pState][this.finalLevel], parentScale, newScale);
                            this.iScale[start][end][pState] = newScale;
                            if (newScale != scaleBeforeUnaries && pState != 0) {
                                this.updateHierarchy(this.h_iScorePreU[start][end][pState]);
                            }
                            if (start > this.narrowLExtent[end][pState]) {
                                this.narrowLExtent[end][pState] = start;
                                this.wideLExtent[end][pState] = start;
                            } else if (start < this.wideLExtent[end][pState]) {
                                this.wideLExtent[end][pState] = start;
                            }
                            if (end < this.narrowRExtent[start][pState]) {
                                this.narrowRExtent[start][pState] = end;
                                this.wideRExtent[start][pState] = end;
                            } else if (end > this.wideRExtent[start][pState]) {
                                this.wideRExtent[start][pState] = end;
                            }
                        }
                        np = 0;
                        while (np < nParentStates) {
                            double val = this.h_iScorePreU[start][end][pState][this.finalLevel][np];
                            if (val > 0.0) {
                                if (viterbi) {
                                    this.h_iScorePostU[start][end][pState][this.finalLevel][np] = Math.max(this.h_iScorePostU[start][end][pState][this.finalLevel][np], val);
                                } else {
                                    double[] dArray = this.h_iScorePostU[start][end][pState][this.finalLevel];
                                    int n = np;
                                    dArray[n] = dArray[n] + val;
                                }
                            }
                            ++np;
                        }
                        if (pState != 0) {
                            this.updateHierarchy(this.h_iScorePostU[start][end][pState]);
                        }
                    }
                    ++pState;
                }
                ++start;
            }
            ++diff;
        }
    }

    private final void updateHierarchy(double[][] ds) {
        int level = this.finalLevel - 1;
        while (level >= 0) {
            int i = 0;
            while (i < this.substatesToCover[this.finalLevel - level]) {
                ds[level][i] = ds[level + 1][2 * i] + ds[level + 1][2 * i + 1];
                ++i;
            }
            --level;
        }
    }

    private final boolean computeInsideScore(int start, int split, int end, HierarchicalAdaptiveBinaryRule rule, boolean viterbi) {
        short pState = rule.parentState;
        short lState = rule.leftChildState;
        short rState = rule.rightChildState;
        boolean changeThisRound = false;
        HierarchicalAdaptiveBinaryRule.SubRule[] subRuleArray = rule.subRuleList;
        int n = rule.subRuleList.length;
        int n2 = 0;
        while (n2 < n) {
            double rS;
            short level;
            double lS;
            HierarchicalAdaptiveBinaryRule.SubRule subRule = subRuleArray[n2];
            if (subRule != null && (lS = this.h_iScorePostU[start][split][lState][level = subRule.level][subRule.lChild]) != 0.0 && (rS = this.h_iScorePostU[split][end][rState][level][subRule.rChild]) != 0.0) {
                double score = lS * rS * subRule.score;
                int k = this.substatesToCover[level] * subRule.parent;
                int l = k + this.substatesToCover[level];
                int np = k;
                while (np < l) {
                    if (this.allowedSubStates[start][end][pState][np]) {
                        if (viterbi) {
                            this.unscaledScoresToAdd[np] = Math.max(this.unscaledScoresToAdd[np], score);
                        } else {
                            int n3 = np;
                            this.unscaledScoresToAdd[n3] = this.unscaledScoresToAdd[n3] + score;
                        }
                        changeThisRound = true;
                    }
                    ++np;
                }
            }
            ++n2;
        }
        return changeThisRound;
    }

    private final boolean computeInsideScore(int start, int end, HierarchicalAdaptiveUnaryRule rule, boolean viterbi) {
        short pState = rule.parentState;
        short cState = rule.childState;
        boolean changeThisRound = false;
        HierarchicalAdaptiveUnaryRule.SubRule[] subRuleArray = rule.subRuleList;
        int n = rule.subRuleList.length;
        int n2 = 0;
        while (n2 < n) {
            short level;
            double cS;
            HierarchicalAdaptiveUnaryRule.SubRule subRule = subRuleArray[n2];
            if (subRule != null && (cS = this.h_iScorePreU[start][end][cState][level = subRule.level][subRule.child]) != 0.0) {
                double score = cS * subRule.score;
                int k = this.substatesToCover[level] * subRule.parent;
                int l = k + this.substatesToCover[level];
                if (pState == 0) {
                    l = 1;
                }
                int np = k;
                while (np < l) {
                    if (this.allowedSubStates[start][end][pState][np]) {
                        if (viterbi) {
                            this.unscaledScoresToAdd[np] = Math.max(this.unscaledScoresToAdd[np], score);
                        } else {
                            int n3 = np;
                            this.unscaledScoresToAdd[n3] = this.unscaledScoresToAdd[n3] + score;
                        }
                        changeThisRound = true;
                    }
                    ++np;
                }
            }
            ++n2;
        }
        return changeThisRound;
    }

    @Override
    void doConstrainedOutsideScores(boolean viterbi) {
        this.doConstrainedOutsideScores(viterbi, null);
    }

    @Override
    void doConstrainedOutsideScores(boolean viterbi, double[][][] spanScores) {
        double initVal = 0.0;
        int diff = this.length;
        while (diff >= 1) {
            int start = 0;
            while (start + diff <= this.length) {
                block53: {
                    int nChildStates;
                    int end = start + diff;
                    int nStates = diff == this.length ? 1 : this.numSubStatesArray.length;
                    int pState = 0;
                    while (pState < nStates) {
                        if (this.allowedSubStates[start][end][pState] != null) {
                            nChildStates = this.numSubStatesArray[pState];
                            if (spanScores != null) {
                                double val = spanScores[start][end][this.stateClass[pState]];
                                if (val != 1.0) {
                                    int np = 0;
                                    while (np < nChildStates) {
                                        double[] dArray = this.h_oScorePreU[start][end][pState][this.finalLevel];
                                        int n = np++;
                                        dArray[n] = dArray[n] * val;
                                    }
                                }
                                if (pState != 0) {
                                    this.updateHierarchy(this.h_oScorePreU[start][end][pState]);
                                } else {
                                    val = this.h_oScorePreU[start][end][0][this.finalLevel][0];
                                    int level = this.finalLevel - 1;
                                    while (level >= 0) {
                                        this.h_oScorePreU[start][end][0][level][0] = val;
                                        --level;
                                    }
                                }
                            }
                        }
                        ++pState;
                    }
                    int cState = 0;
                    while (cState < this.numSubStatesArray.length) {
                        if (this.allowedSubStates[start][end][cState] != null) {
                            int childScale;
                            nChildStates = this.numSubStatesArray[cState];
                            UnaryRule[] rules = this.grammar.getClosedSumUnaryRulesByChild(cState);
                            boolean somethingChanged = false;
                            int scaleBeforeUnaries = childScale = this.oScale[start][end][cState];
                            int r = 0;
                            while (r < rules.length) {
                                boolean changeThisRound;
                                HierarchicalAdaptiveUnaryRule ur = (HierarchicalAdaptiveUnaryRule)rules[r];
                                short pState2 = ur.parentState;
                                if (pState2 != cState && this.allowedSubStates[start][end][pState2] != null && (changeThisRound = this.computeOutsideScore(start, end, ur, viterbi))) {
                                    somethingChanged = true;
                                    int currentScale = this.oScale[start][end][pState2];
                                    if (childScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                        if (childScale == Integer.MIN_VALUE) {
                                            childScale = currentScale;
                                        } else {
                                            int newScale = Math.max(currentScale, childScale);
                                            ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                            ScalingTools.scaleArrayToScale(this.h_oScorePostU[start][end][cState][this.finalLevel], childScale, newScale);
                                            childScale = newScale;
                                        }
                                    }
                                    int cp = 0;
                                    while (cp < nChildStates) {
                                        if (viterbi) {
                                            this.h_oScorePostU[start][end][cState][this.finalLevel][cp] = Math.max(this.h_oScorePostU[start][end][cState][this.finalLevel][cp], this.unscaledScoresToAdd[cp]);
                                        } else {
                                            double[] dArray = this.h_oScorePostU[start][end][cState][this.finalLevel];
                                            int n = cp;
                                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp];
                                        }
                                        ++cp;
                                    }
                                    Arrays.fill(this.unscaledScoresToAdd, initVal);
                                }
                                ++r;
                            }
                            if (somethingChanged) {
                                int newScale = Math.max(scaleBeforeUnaries, childScale);
                                ScalingTools.scaleArrayToScale(this.h_oScorePreU[start][end][cState][this.finalLevel], scaleBeforeUnaries, newScale);
                                ScalingTools.scaleArrayToScale(this.h_oScorePostU[start][end][cState][this.finalLevel], childScale, newScale);
                                this.oScale[start][end][cState] = newScale;
                                if (newScale != scaleBeforeUnaries) {
                                    this.updateHierarchy(this.h_oScorePreU[start][end][cState]);
                                }
                            }
                            int cp = 0;
                            while (cp < nChildStates) {
                                double val = this.h_oScorePreU[start][end][cState][this.finalLevel][cp];
                                if (val > 0.0) {
                                    if (viterbi) {
                                        this.h_oScorePostU[start][end][cState][this.finalLevel][cp] = Math.max(this.h_oScorePostU[start][end][cState][this.finalLevel][cp], val);
                                    } else {
                                        double[] dArray = this.h_oScorePostU[start][end][cState][this.finalLevel];
                                        int n = cp;
                                        dArray[n] = dArray[n] + val;
                                    }
                                }
                                ++cp;
                            }
                            if (cState != 0) {
                                this.updateHierarchy(this.h_oScorePostU[start][end][cState]);
                            } else {
                                double val = this.h_oScorePostU[start][end][0][this.finalLevel][0];
                                int level = this.finalLevel - 1;
                                while (level >= 0) {
                                    this.h_oScorePostU[start][end][0][level][0] = val;
                                    --level;
                                }
                            }
                        }
                        ++cState;
                    }
                    if (diff == 1) break block53;
                    pState = 0;
                    while (pState < this.numSubStatesArray.length) {
                        block54: {
                            if (this.allowedSubStates[start][end][pState] == null) break block54;
                            BinaryRule[] rules = this.grammar.splitRulesWithP(pState);
                            int r = 0;
                            while (r < rules.length) {
                                block55: {
                                    int min;
                                    int max;
                                    short rState;
                                    short lState;
                                    HierarchicalAdaptiveBinaryRule br;
                                    block56: {
                                        int max1;
                                        br = (HierarchicalAdaptiveBinaryRule)rules[r];
                                        lState = br.leftChildState;
                                        int min1 = this.narrowRExtent[start][lState];
                                        if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) break block55;
                                        max = max1;
                                        min = min1;
                                        if (max - min <= 2) break block56;
                                        int min2 = this.wideLExtent[end][rState];
                                        int n = min = min1 > min2 ? min1 : min2;
                                        if (max1 < min) break block55;
                                        int max2 = this.wideRExtent[start][lState];
                                        int n2 = max = max1 < max2 ? max1 : max2;
                                        if (max < min) break block55;
                                    }
                                    int nLeftChildStates = this.numSubStatesArray[lState];
                                    short nRightChildStates = this.numSubStatesArray[rState];
                                    int split = min;
                                    while (split <= max) {
                                        boolean somethingChanged;
                                        if (this.allowedSubStates[start][split][lState] != null && this.allowedSubStates[split][end][rState] != null && (somethingChanged = this.computeOutsideScore(start, split, end, br, viterbi))) {
                                            int cp;
                                            int newScale;
                                            int currentScale;
                                            if (DoubleArrays.max(this.scoresToAdd) != 0.0) {
                                                int leftScale = this.oScale[start][split][lState];
                                                currentScale = this.oScale[start][end][pState] + this.iScale[split][end][rState];
                                                if (leftScale != (currentScale = ScalingTools.scaleArray(this.scoresToAdd, currentScale))) {
                                                    if (leftScale == Integer.MIN_VALUE) {
                                                        this.oScale[start][split][lState] = currentScale;
                                                    } else {
                                                        newScale = Math.max(currentScale, leftScale);
                                                        ScalingTools.scaleArrayToScale(this.scoresToAdd, currentScale, newScale);
                                                        ScalingTools.scaleArrayToScale(this.h_oScorePreU[start][split][lState][this.finalLevel], leftScale, newScale);
                                                        this.oScale[start][split][lState] = newScale;
                                                    }
                                                }
                                                cp = 0;
                                                while (cp < nLeftChildStates) {
                                                    if (this.scoresToAdd[cp] > initVal) {
                                                        if (viterbi) {
                                                            this.h_oScorePreU[start][split][lState][this.finalLevel][cp] = Math.max(this.h_oScorePreU[start][split][lState][this.finalLevel][cp], this.scoresToAdd[cp]);
                                                        } else {
                                                            double[] dArray = this.h_oScorePreU[start][split][lState][this.finalLevel];
                                                            int n = cp;
                                                            dArray[n] = dArray[n] + this.scoresToAdd[cp];
                                                        }
                                                    }
                                                    ++cp;
                                                }
                                                Arrays.fill(this.scoresToAdd, 0.0);
                                                this.updateHierarchy(this.h_oScorePreU[start][split][lState]);
                                            }
                                            if (DoubleArrays.max(this.unscaledScoresToAdd) != 0.0) {
                                                int rightScale = this.oScale[split][end][rState];
                                                currentScale = this.oScale[start][end][pState] + this.iScale[start][split][lState];
                                                if (currentScale == Integer.MIN_VALUE) {
                                                    System.out.println("shhaaa");
                                                }
                                                if (rightScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                                    if (rightScale == Integer.MIN_VALUE) {
                                                        this.oScale[split][end][rState] = currentScale;
                                                    } else {
                                                        newScale = Math.max(currentScale, rightScale);
                                                        ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                                        ScalingTools.scaleArrayToScale(this.h_oScorePreU[split][end][rState][this.finalLevel], rightScale, newScale);
                                                        this.oScale[split][end][rState] = newScale;
                                                    }
                                                }
                                                cp = 0;
                                                while (cp < nRightChildStates) {
                                                    if (this.unscaledScoresToAdd[cp] > initVal) {
                                                        if (viterbi) {
                                                            this.h_oScorePreU[split][end][rState][this.finalLevel][cp] = Math.max(this.h_oScorePreU[split][end][rState][this.finalLevel][cp], this.unscaledScoresToAdd[cp]);
                                                        } else {
                                                            double[] dArray = this.h_oScorePreU[split][end][rState][this.finalLevel];
                                                            int n = cp;
                                                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp];
                                                        }
                                                    }
                                                    ++cp;
                                                }
                                                Arrays.fill(this.unscaledScoresToAdd, 0.0);
                                                this.updateHierarchy(this.h_oScorePreU[split][end][rState]);
                                            }
                                        }
                                        ++split;
                                    }
                                }
                                ++r;
                            }
                        }
                        ++pState;
                    }
                }
                ++start;
            }
            --diff;
        }
    }

    private final boolean computeOutsideScore(int start, int split, int end, HierarchicalAdaptiveBinaryRule rule, boolean viterbi) {
        short pState = rule.parentState;
        short lState = rule.leftChildState;
        short rState = rule.rightChildState;
        boolean changeThisRound = false;
        HierarchicalAdaptiveBinaryRule.SubRule[] subRuleArray = rule.subRuleList;
        int n = rule.subRuleList.length;
        int n2 = 0;
        while (n2 < n) {
            short level;
            double oS;
            HierarchicalAdaptiveBinaryRule.SubRule subRule = subRuleArray[n2];
            if (subRule != null && (oS = this.h_oScorePostU[start][end][pState][level = subRule.level][subRule.parent]) != 0.0) {
                int k;
                double lS = this.h_iScorePostU[start][split][lState][level][subRule.lChild];
                double rS = this.h_iScorePostU[split][end][rState][level][subRule.rChild];
                double pS = subRule.score;
                double thisRoundL = pS * rS * oS;
                double thisRoundR = pS * lS * oS;
                if (thisRoundL != 0.0) {
                    k = this.substatesToCover[level] * subRule.lChild;
                    int l = k + this.substatesToCover[level];
                    int lp = k;
                    while (lp < l) {
                        if (this.allowedSubStates[start][split][lState][lp]) {
                            if (viterbi) {
                                this.scoresToAdd[lp] = Math.max(this.scoresToAdd[lp], thisRoundL);
                            } else {
                                int n3 = lp;
                                this.scoresToAdd[n3] = this.scoresToAdd[n3] + thisRoundL;
                            }
                            changeThisRound = true;
                        }
                        ++lp;
                    }
                }
                if (thisRoundR != 0.0) {
                    k = this.substatesToCover[level] * subRule.rChild;
                    int m = k + this.substatesToCover[level];
                    int rp = k;
                    while (rp < m) {
                        if (this.allowedSubStates[split][end][rState][rp]) {
                            if (viterbi) {
                                this.unscaledScoresToAdd[rp] = Math.max(this.unscaledScoresToAdd[rp], thisRoundR);
                            } else {
                                int n4 = rp;
                                this.unscaledScoresToAdd[n4] = this.unscaledScoresToAdd[n4] + thisRoundR;
                            }
                            changeThisRound = true;
                        }
                        ++rp;
                    }
                }
            }
            ++n2;
        }
        return changeThisRound;
    }

    private final boolean computeOutsideScore(int start, int end, HierarchicalAdaptiveUnaryRule rule, boolean viterbi) {
        short pState = rule.parentState;
        short cState = rule.childState;
        boolean changeThisRound = false;
        HierarchicalAdaptiveUnaryRule.SubRule[] subRuleArray = rule.subRuleList;
        int n = rule.subRuleList.length;
        int n2 = 0;
        while (n2 < n) {
            short level;
            double pS;
            HierarchicalAdaptiveUnaryRule.SubRule subRule = subRuleArray[n2];
            if (subRule != null && (pS = this.h_oScorePreU[start][end][pState][level = subRule.level][subRule.parent]) != 0.0) {
                double score = pS * subRule.score;
                int k = this.substatesToCover[level] * subRule.child;
                int l = k + this.substatesToCover[level];
                int np = k;
                while (np < l) {
                    if (this.allowedSubStates[start][end][cState][np]) {
                        if (viterbi) {
                            this.unscaledScoresToAdd[np] = Math.max(this.unscaledScoresToAdd[np], score);
                        } else {
                            int n3 = np;
                            this.unscaledScoresToAdd[n3] = this.unscaledScoresToAdd[n3] + score;
                        }
                        changeThisRound = true;
                    }
                    ++np;
                }
            }
            ++n2;
        }
        return changeThisRound;
    }

    @Override
    void initializeChart(List<StateSet> sentence, boolean noSmoothing, List<String> posTags) {
        boolean useGoldPOS = posTags != null;
        int start = 0;
        int end = start + 1;
        for (StateSet word : sentence) {
            end = start + 1;
            short goldTag = -1;
            if (useGoldPOS) {
                goldTag = this.tagNumberer.number(posTags.get(start));
            }
            short tag = 0;
            while (tag < this.numSubStatesArray.length) {
                if (!(this.grammarTags[tag] || this.allowedSubStates[start][end][tag] == null || useGoldPOS && tag != goldTag)) {
                    this.narrowRExtent[start][tag] = end;
                    this.narrowLExtent[end][tag] = start;
                    this.wideRExtent[start][tag] = end;
                    this.wideLExtent[end][tag] = start;
                    double[] lexiconScores = this.lexicon.score(word, tag, noSmoothing, false);
                    this.iScale[start][end][tag] = 0;
                    int n = 0;
                    while (n < lexiconScores.length) {
                        double prob;
                        this.h_iScorePreU[start][end][tag][this.finalLevel][n] = prob = lexiconScores[n];
                        n = (short)(n + 1);
                    }
                    this.updateHierarchy(this.h_iScorePreU[start][end][tag]);
                }
                tag = (short)(tag + 1);
            }
            ++start;
        }
    }

    @Override
    protected void createArrays() {
        if (this.arraySize < this.length) {
            this.arraySize = this.length;
            this.h_iScorePreU = new double[this.length][this.length + 1][][][];
            this.h_iScorePostU = new double[this.length][this.length + 1][][][];
            this.h_oScorePreU = new double[this.length][this.length + 1][][][];
            this.h_oScorePostU = new double[this.length][this.length + 1][][][];
            this.iScale = new int[this.length][this.length + 1][];
            this.oScale = new int[this.length][this.length + 1][];
            int start = 0;
            while (start < this.length) {
                int end = start + 1;
                while (end <= this.length) {
                    this.h_iScorePreU[start][end] = new double[this.numStates][this.finalLevel + 1][];
                    this.h_iScorePostU[start][end] = new double[this.numStates][this.finalLevel + 1][];
                    this.h_oScorePreU[start][end] = new double[this.numStates][this.finalLevel + 1][];
                    this.h_oScorePostU[start][end] = new double[this.numStates][this.finalLevel + 1][];
                    this.iScale[start][end] = new int[this.numStates];
                    this.oScale[start][end] = new int[this.numStates];
                    Arrays.fill(this.iScale[start][end], Integer.MIN_VALUE);
                    Arrays.fill(this.oScale[start][end], Integer.MIN_VALUE);
                    int state = 0;
                    while (state < this.numSubStatesArray.length) {
                        if (end - start <= 1 || this.grammarTags[state]) {
                            int level = 0;
                            while (level <= this.finalLevel) {
                                this.h_iScorePreU[start][end][state][level] = new double[this.numSubStatesArray[state] / this.substatesToCover[level]];
                                this.h_iScorePostU[start][end][state][level] = new double[this.numSubStatesArray[state] / this.substatesToCover[level]];
                                this.h_oScorePreU[start][end][state][level] = new double[this.numSubStatesArray[state] / this.substatesToCover[level]];
                                this.h_oScorePostU[start][end][state][level] = new double[this.numSubStatesArray[state] / this.substatesToCover[level]];
                                ++level;
                            }
                        }
                        ++state;
                    }
                    int level = 0;
                    while (level <= this.finalLevel) {
                        this.h_oScorePreU[start][end][0][level] = new double[1];
                        this.h_oScorePostU[start][end][0][level] = new double[1];
                        ++level;
                    }
                    ++end;
                }
                ++start;
            }
            this.narrowRExtent = new int[this.length + 1][this.numStates];
            this.wideRExtent = new int[this.length + 1][this.numStates];
            this.narrowLExtent = new int[this.length + 1][this.numStates];
            this.wideLExtent = new int[this.length + 1][this.numStates];
            int loc = 0;
            while (loc <= this.length) {
                Arrays.fill(this.narrowLExtent[loc], -1);
                Arrays.fill(this.wideLExtent[loc], this.length + 1);
                Arrays.fill(this.narrowRExtent[loc], this.length + 1);
                Arrays.fill(this.wideRExtent[loc], -1);
                ++loc;
            }
        }
    }

    @Override
    protected void scrubArrays() {
        if (this.h_iScorePostU == null) {
            return;
        }
        int start = 0;
        while (start < this.length) {
            int end = start + 1;
            while (end <= this.length) {
                int state = 0;
                while (state < this.numSubStatesArray.length) {
                    if (this.allowedSubStates[start][end][state] != null && (end - start <= 1 || this.grammarTags[state])) {
                        int level = 0;
                        while (level <= this.finalLevel) {
                            Arrays.fill(this.h_iScorePreU[start][end][state][level], 0.0);
                            Arrays.fill(this.h_iScorePostU[start][end][state][level], 0.0);
                            Arrays.fill(this.h_oScorePreU[start][end][state][level], 0.0);
                            Arrays.fill(this.h_oScorePostU[start][end][state][level], 0.0);
                            ++level;
                        }
                        Arrays.fill(this.iScale[start][end], Integer.MIN_VALUE);
                        Arrays.fill(this.oScale[start][end], Integer.MIN_VALUE);
                    }
                    ++state;
                }
                ++end;
            }
            ++start;
        }
        int loc = 0;
        while (loc <= this.length) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
            ++loc;
        }
    }

    @Override
    protected double getLikelihoodAndSetRootOutsideScore() {
        int level = 0;
        while (level <= this.finalLevel) {
            this.h_oScorePreU[0][this.length][0][level][0] = 1.0;
            ++level;
        }
        this.oScale[0][this.length][0] = 0;
        return Math.log(this.h_iScorePostU[0][this.length][0][this.finalLevel][0]) + (double)(100 * this.iScale[0][this.length][0]);
    }

    @Override
    void doConstrainedMaxCScores(List<StateSet> sentence) {
        this.doConstrainedMaxCScores(sentence, null);
    }

    @Override
    void doConstrainedMaxCScores(List<StateSet> sentence, double[][][] spanScores) {
        this.maxcScore = new double[this.length][this.length + 1][this.numStates];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates];
        double tree_score = this.h_iScorePostU[0][this.length][0][this.finalLevel][0];
        int tree_scale = this.iScale[0][this.length][0];
        int diff = 1;
        while (diff <= this.length) {
            int start = 0;
            while (start < this.length - diff + 1) {
                int end = start + diff;
                Arrays.fill(this.maxcSplit[start][end], -1);
                Arrays.fill(this.maxcChild[start][end], -1);
                Arrays.fill(this.maxcLeftChild[start][end], -1);
                Arrays.fill(this.maxcRightChild[start][end], -1);
                if (diff > 1) {
                    int pState = 0;
                    while (pState < this.numSubStatesArray.length) {
                        if (this.allowedSubStates[start][end][pState] != null) {
                            BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                            int i = 0;
                            while (i < parentRules.length) {
                                boolean iPossibleL;
                                HierarchicalAdaptiveBinaryRule r = (HierarchicalAdaptiveBinaryRule)parentRules[i];
                                short lState = r.leftChildState;
                                short rState = r.rightChildState;
                                int narrowR = this.narrowRExtent[start][lState];
                                boolean bl = iPossibleL = narrowR < end;
                                if (iPossibleL) {
                                    boolean iPossibleR;
                                    int narrowL = this.narrowLExtent[end][rState];
                                    boolean bl2 = iPossibleR = narrowL >= narrowR;
                                    if (iPossibleR) {
                                        int min;
                                        int min1 = narrowR;
                                        int min2 = this.wideLExtent[end][rState];
                                        int n = min = min1 > min2 ? min1 : min2;
                                        if (min <= narrowL) {
                                            int max;
                                            int max1 = this.wideRExtent[start][lState];
                                            int max2 = narrowL;
                                            int n2 = max = max1 < max2 ? max1 : max2;
                                            if (min <= max) {
                                                int split = min;
                                                while (split <= max) {
                                                    double rightChildScore;
                                                    double leftChildScore;
                                                    double gScore;
                                                    double ruleScore;
                                                    double scalingFactor;
                                                    if (this.allowedSubStates[start][split][lState] != null && this.allowedSubStates[split][end][rState] != null && (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][split][lState] + this.iScale[split][end][rState] - tree_scale)) != 0.0 && (ruleScore = this.computeRuleScore(start, split, end, r, tree_score, scalingFactor)) != 0.0 && (gScore = ruleScore * (leftChildScore = this.maxcScore[start][split][lState]) * (rightChildScore = this.maxcScore[split][end][rState])) > this.maxcScore[start][end][pState]) {
                                                        this.maxcScore[start][end][pState] = gScore;
                                                        this.maxcSplit[start][end][pState] = split;
                                                        this.maxcLeftChild[start][end][pState] = lState;
                                                        this.maxcRightChild[start][end][pState] = rState;
                                                    }
                                                    ++split;
                                                }
                                            }
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        ++pState;
                    }
                } else {
                    int tag = 0;
                    while (tag < this.numSubStatesArray.length) {
                        double scalingFactor;
                        if (this.allowedSubStates[start][end][tag] != null && !this.grammar.isGrammarTag(tag) && (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][tag] - tree_scale)) != 0.0) {
                            int nTagStates = this.numSubStatesArray[tag];
                            double[] lexiconScoreArray = this.h_iScorePreU[start][end][tag][this.finalLevel];
                            double lexiconScores = 0.0;
                            int tp = 0;
                            while (tp < nTagStates) {
                                double ruleS;
                                double pOS = this.h_oScorePostU[start][end][tag][this.finalLevel][tp];
                                if (pOS != 0.0 && (ruleS = lexiconScoreArray[tp]) != 0.0) {
                                    lexiconScores += pOS * ruleS / tree_score;
                                }
                                ++tp;
                            }
                            if (lexiconScores != 0.0) {
                                this.maxcScore[start][end][tag] = lexiconScores * scalingFactor;
                            }
                        }
                        tag = (short)(tag + 1);
                    }
                }
                double[] maxcScoreStartEnd = new double[this.numStates];
                int i = 0;
                while (i < this.numStates) {
                    maxcScoreStartEnd[i] = this.maxcScore[start][end][i];
                    ++i;
                }
                int pState = 0;
                while (pState < this.numSubStatesArray.length) {
                    if (this.allowedSubStates[start][end][pState] != null) {
                        double spanScore = spanScores != null ? spanScores[start][end][this.stateClass[pState]] : 1.0;
                        UnaryRule[] unaries = this.grammar.getClosedSumUnaryRulesByParent(pState);
                        int r = 0;
                        while (r < unaries.length) {
                            double childScore;
                            double gScore;
                            double ruleScore;
                            double scalingFactor;
                            HierarchicalAdaptiveUnaryRule ur = (HierarchicalAdaptiveUnaryRule)unaries[r];
                            short cState = ur.childState;
                            if (pState != cState && this.allowedSubStates[start][end][cState] != null && (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][end][cState] - tree_scale)) != 0.0 && (ruleScore = this.computeRuleScore(start, end, ur, tree_score, scalingFactor, spanScore)) != 0.0 && (gScore = ruleScore * (childScore = this.maxcScore[start][end][cState])) > maxcScoreStartEnd[pState]) {
                                maxcScoreStartEnd[pState] = gScore;
                                this.maxcChild[start][end][pState] = cState;
                            }
                            ++r;
                        }
                    }
                    ++pState;
                }
                this.maxcScore[start][end] = maxcScoreStartEnd;
                ++start;
            }
            ++diff;
        }
    }

    private final double computeRuleScore(int start, int split, int end, HierarchicalAdaptiveBinaryRule rule, double tree_score, double scalingFactor) {
        double ruleScore = 0.0;
        short pState = rule.parentState;
        short lState = rule.leftChildState;
        short rState = rule.rightChildState;
        HierarchicalAdaptiveBinaryRule.SubRule[] subRuleArray = rule.subRuleList;
        int n = rule.subRuleList.length;
        int n2 = 0;
        while (n2 < n) {
            double pOS;
            double rS;
            HierarchicalAdaptiveBinaryRule.SubRule subRule = subRuleArray[n2];
            short level = subRule.level;
            double lS = this.h_iScorePostU[start][split][lState][level][subRule.lChild];
            if (lS != 0.0 && (rS = this.h_iScorePostU[split][end][rState][level][subRule.rChild]) != 0.0 && (pOS = this.h_oScorePostU[start][end][pState][level][subRule.parent]) != 0.0) {
                ruleScore += subRule.score * lS / tree_score * rS * scalingFactor * pOS;
            }
            ++n2;
        }
        return ruleScore;
    }

    private final double computeRuleScore(int start, int end, HierarchicalAdaptiveUnaryRule rule, double tree_score, double scalingFactor, double spanScore) {
        double ruleScore = 0.0;
        short pState = rule.parentState;
        short cState = rule.childState;
        HierarchicalAdaptiveUnaryRule.SubRule[] subRuleArray = rule.subRuleList;
        int n = rule.subRuleList.length;
        int n2 = 0;
        while (n2 < n) {
            double pOS;
            short level;
            double cS;
            HierarchicalAdaptiveUnaryRule.SubRule subRule = subRuleArray[n2];
            if (subRule != null && (cS = this.h_iScorePreU[start][end][cState][level = subRule.level][subRule.child]) != 0.0 && (pOS = this.h_oScorePreU[start][end][pState][level][subRule.parent]) != 0.0) {
                ruleScore += subRule.score * cS / tree_score * scalingFactor / spanScore * pOS;
            }
            ++n2;
        }
        return ruleScore;
    }

    @Override
    public void incrementExpectedCounts(Linearizer linearizer, double[] probs, List<StateSet> sentence) {
        double tree_score = this.h_iScorePostU[0][this.length][0][this.finalLevel][0];
        int tree_scale = this.iScale[0][this.length][0];
        if (ConditionalTrainer.Options.lockGrammar) {
            linearizer.increment(probs, sentence, this.getClassBracketPosteriors(), false);
            return;
        }
        int start = 0;
        while (start < this.length) {
            int lastState = this.numSubStatesArray.length;
            StateSet currentStateSet = sentence.get(start);
            int tag = 0;
            while (tag < lastState) {
                double scalingFactor;
                if (!this.grammar.isGrammarTag(tag) && this.allowedSubStates[start][start + 1][tag] != null && (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][start + 1][tag] + this.iScale[start][start + 1][tag] - tree_scale)) != 0.0) {
                    short nSubStates = this.numSubStatesArray[tag];
                    short substate = 0;
                    while (substate < nSubStates) {
                        double weight;
                        double oS;
                        double iS = this.h_iScorePreU[start][start + 1][tag][this.finalLevel][substate];
                        if (iS != 0.0 && (oS = this.h_oScorePostU[start][start + 1][tag][this.finalLevel][substate]) != 0.0 && this.isValidExpectation(weight = iS / tree_score * scalingFactor * oS)) {
                            this.tmpCountsArray[substate] = weight;
                        }
                        substate = (short)(substate + 1);
                    }
                    linearizer.increment(probs, currentStateSet, tag, this.tmpCountsArray, false);
                }
                ++tag;
            }
            ++start;
        }
        int diff = 1;
        while (diff <= this.length) {
            int start2 = 0;
            while (start2 < this.length - diff + 1) {
                int end = start2 + diff;
                int lastState = this.numSubStatesArray.length;
                int pState = 0;
                while (pState < lastState) {
                    if (diff != 1 && this.allowedSubStates[start2][end][pState] != null) {
                        BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                        int i = 0;
                        while (i < parentRules.length) {
                            boolean iPossibleL;
                            HierarchicalAdaptiveBinaryRule r = (HierarchicalAdaptiveBinaryRule)parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start2][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (iPossibleL) {
                                boolean iPossibleR;
                                int narrowL = this.narrowLExtent[end][rState];
                                boolean bl2 = iPossibleR = narrowL >= narrowR;
                                if (iPossibleR) {
                                    int min;
                                    int min1 = narrowR;
                                    int min2 = this.wideLExtent[end][rState];
                                    int n = min = min1 > min2 ? min1 : min2;
                                    if (min <= narrowL) {
                                        int max;
                                        int max1 = this.wideRExtent[start2][lState];
                                        int max2 = narrowL;
                                        int n2 = max = max1 < max2 ? max1 : max2;
                                        if (min <= max) {
                                            boolean foundSomething = false;
                                            int split = min;
                                            while (split <= max) {
                                                double scalingFactor;
                                                if (this.allowedSubStates[start2][split][lState] != null && this.allowedSubStates[split][end][rState] != null && (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start2][end][pState] + this.iScale[start2][split][lState] + this.iScale[split][end][rState] - tree_scale)) != 0.0) {
                                                    boolean tmp = this.computeExpectedCount(start2, split, end, r, tree_score, scalingFactor);
                                                    foundSomething = foundSomething || tmp;
                                                }
                                                ++split;
                                            }
                                            if (foundSomething) {
                                                linearizer.increment(probs, r, this.tmpCountsArray, false);
                                            }
                                        }
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    pState = (short)(pState + 1);
                }
                int lastStateU = this.numSubStatesArray.length;
                int pState2 = 0;
                while (pState2 < lastStateU) {
                    if (this.allowedSubStates[start2][end][pState2] != null) {
                        UnaryRule[] unaries;
                        UnaryRule[] unaryRuleArray = unaries = this.grammar.getClosedSumUnaryRulesByParent(pState2);
                        int n = unaries.length;
                        int n3 = 0;
                        while (n3 < n) {
                            boolean foundSomething;
                            double scalingFactor;
                            UnaryRule ur = unaryRuleArray[n3];
                            short cState = ur.childState;
                            if (pState2 != cState && this.allowedSubStates[start2][end][cState] != null && (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start2][end][pState2] + this.iScale[start2][end][cState] - tree_scale)) != 0.0 && (foundSomething = this.computeExpectedCount(start2, end, (HierarchicalAdaptiveUnaryRule)ur, tree_score, scalingFactor))) {
                                linearizer.increment(probs, ur, this.tmpCountsArray, false);
                            }
                            ++n3;
                        }
                    }
                    pState2 = (short)(pState2 + 1);
                }
                ++start2;
            }
            ++diff;
        }
        if (this.spanPredictor != null) {
            linearizer.increment(probs, sentence, this.getClassBracketPosteriors(), false);
        }
    }

    private final boolean computeExpectedCount(int start, int split, int end, HierarchicalAdaptiveBinaryRule rule, double tree_score, double scalingFactor) {
        short pState = rule.parentState;
        short lState = rule.leftChildState;
        short rState = rule.rightChildState;
        boolean foundSomething = false;
        int curInd = -1;
        HierarchicalAdaptiveBinaryRule.SubRule[] subRuleArray = rule.subRuleList;
        int n = rule.subRuleList.length;
        int n2 = 0;
        while (n2 < n) {
            HierarchicalAdaptiveBinaryRule.SubRule subRule = subRuleArray[n2];
            if (subRule != null) {
                double ruleCount;
                double pOS;
                double rS;
                short level = subRule.level;
                ++curInd;
                double lS = this.h_iScorePostU[start][split][lState][level][subRule.lChild];
                if (lS != 0.0 && (rS = this.h_iScorePostU[split][end][rState][level][subRule.rChild]) != 0.0 && (pOS = this.h_oScorePostU[start][end][pState][level][subRule.parent]) != 0.0 && this.isValidExpectation(ruleCount = subRule.score * lS / tree_score * rS * scalingFactor * pOS)) {
                    int n3 = curInd;
                    this.tmpCountsArray[n3] = this.tmpCountsArray[n3] + ruleCount;
                    foundSomething = true;
                }
            }
            ++n2;
        }
        return foundSomething;
    }

    private final boolean computeExpectedCount(int start, int end, HierarchicalAdaptiveUnaryRule rule, double tree_score, double scalingFactor) {
        short pState = rule.parentState;
        short cState = rule.childState;
        boolean foundSomething = false;
        int curInd = -1;
        HierarchicalAdaptiveUnaryRule.SubRule[] subRuleArray = rule.subRuleList;
        int n = rule.subRuleList.length;
        int n2 = 0;
        while (n2 < n) {
            double pOS;
            short level;
            double cS;
            HierarchicalAdaptiveUnaryRule.SubRule subRule = subRuleArray[n2];
            ++curInd;
            if (subRule != null && (cS = this.h_iScorePreU[start][end][cState][level = subRule.level][subRule.child]) != 0.0 && (pOS = this.h_oScorePreU[start][end][pState][level][subRule.parent]) != 0.0) {
                double ruleCount = subRule.score * cS / tree_score * scalingFactor * pOS;
                if (this.spanScores != null) {
                    ruleCount /= this.spanScores[start][end][this.stateClass[pState]];
                }
                if (this.isValidExpectation(ruleCount)) {
                    this.tmpCountsArray[curInd] = ruleCount;
                    foundSomething = true;
                }
            }
            ++n2;
        }
        return foundSomething;
    }

    @Override
    boolean[][][][] computeAllowedStates(double threshold) {
        double tree_score = this.h_iScorePostU[0][this.length][0][this.finalLevel][0];
        int tree_scale = this.iScale[0][this.length][0];
        boolean[][][][] result = new boolean[this.length][this.length + 1][][];
        int start = 0;
        while (start < this.length) {
            int end = start + 1;
            while (end <= this.length) {
                result[start][end] = new boolean[this.numStates][];
                int lastState = this.numSubStatesArray.length;
                int state = 0;
                while (state < lastState) {
                    double spanScore;
                    double d = spanScore = this.spanScores != null ? this.spanScores[start][end][this.stateClass[state]] : 1.0;
                    if (this.allowedSubStates[start][end][state] != null) {
                        boolean atLeastOnePossible = false;
                        int substate = 0;
                        while (substate < this.numSubStatesArray[state]) {
                            if (this.allowedSubStates[start][end][state][substate]) {
                                double tmp;
                                double posterior;
                                double iS = this.h_iScorePostU[start][end][state][this.finalLevel][substate];
                                double oS = this.h_oScorePostU[start][end][state][this.finalLevel][substate];
                                double scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][state] + this.iScale[start][end][state] - tree_scale);
                                if (scalingFactor != 0.0 && (posterior = (tmp = Math.max(iS * this.h_oScorePreU[start][end][state][this.finalLevel][substate], this.h_iScorePreU[start][end][state][this.finalLevel][substate] * oS)) / spanScore / tree_score * scalingFactor) > threshold) {
                                    if (result[start][end][state] == null) {
                                        result[start][end][state] = new boolean[this.numSubStatesArray[state]];
                                    }
                                    result[start][end][state][substate] = true;
                                    atLeastOnePossible = true;
                                }
                            }
                            ++substate;
                        }
                        if (!atLeastOnePossible) {
                            result[start][end][state] = null;
                        }
                    }
                    ++state;
                }
                ++end;
            }
            ++start;
        }
        return result;
    }

    @Override
    void doInsideScores(Tree<StateSet> tree, boolean noSmoothing, boolean debugOutput, double[][][] spanScores) {
        if (this.grammar.isLogarithmMode() || this.lexicon.isLogarithmMode()) {
            throw new Error("Grammar in logarithm mode!  Cannot do inside scores!");
        }
        if (tree.isLeaf()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        for (Tree<StateSet> child : children) {
            if (child.isLeaf()) continue;
            this.doInsideScores(child, noSmoothing, debugOutput, spanScores);
        }
        StateSet parent = tree.getLabel();
        short pState = parent.getState();
        int nParentStates = parent.numSubStates();
        if (tree.isPreTerminal()) {
            StateSet wordStateSet = tree.getChildren().get(0).getLabel();
            double[] lexiconScores = this.lexicon.score(wordStateSet, pState, noSmoothing, false);
            if (lexiconScores.length != nParentStates) {
                System.out.println("Have more scores than substates!");
            }
            parent.setIScores(lexiconScores);
            parent.scaleIScores(0);
        } else {
            switch (children.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    StateSet child = children.get(0).getLabel();
                    short cState = child.getState();
                    HierarchicalAdaptiveUnaryRule urule = (HierarchicalAdaptiveUnaryRule)this.grammar.getUnaryRule(pState, cState);
                    double[] iScores = new double[nParentStates];
                    HierarchicalAdaptiveUnaryRule.SubRule[] subRuleArray = urule.subRuleList;
                    int n = urule.subRuleList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HierarchicalAdaptiveUnaryRule.SubRule subRule = subRuleArray[n2];
                        if (subRule != null) {
                            short level = subRule.level;
                            int i = this.substatesToCover[level] * subRule.child;
                            int j = i + this.substatesToCover[level];
                            int k = this.substatesToCover[level] * subRule.parent;
                            int l = k + this.substatesToCover[level];
                            double cS = 0.0;
                            int cp = i;
                            while (cp < j) {
                                cS += child.getIScore(cp);
                                ++cp;
                            }
                            if (pState == 0) {
                                l = 1;
                            }
                            int np = k;
                            while (np < l) {
                                double score = cS * subRule.score;
                                int n3 = np++;
                                iScores[n3] = iScores[n3] + score;
                            }
                        }
                        ++n2;
                    }
                    parent.setIScores(iScores);
                    parent.scaleIScores(child.getIScale());
                    break;
                }
                case 2: {
                    StateSet leftChild = children.get(0).getLabel();
                    StateSet rightChild = children.get(1).getLabel();
                    short lState = leftChild.getState();
                    short rState = rightChild.getState();
                    double[] iScores2 = new double[nParentStates];
                    HierarchicalAdaptiveBinaryRule brule = (HierarchicalAdaptiveBinaryRule)this.grammar.getBinaryRule(pState, lState, rState);
                    HierarchicalAdaptiveBinaryRule.SubRule[] subRuleArray = brule.subRuleList;
                    int n = brule.subRuleList.length;
                    int n4 = 0;
                    while (n4 < n) {
                        HierarchicalAdaptiveBinaryRule.SubRule subRule = subRuleArray[n4];
                        if (subRule != null) {
                            short level = subRule.level;
                            int e = this.substatesToCover[level] * subRule.lChild;
                            int f = e + this.substatesToCover[level];
                            int i = this.substatesToCover[level] * subRule.rChild;
                            int j = i + this.substatesToCover[level];
                            int k = this.substatesToCover[level] * subRule.parent;
                            int l = k + this.substatesToCover[level];
                            double lS = 0.0;
                            int lp = e;
                            while (lp < f) {
                                lS += leftChild.getIScore(lp);
                                ++lp;
                            }
                            double rS = 0.0;
                            int rp = i;
                            while (rp < j) {
                                rS += rightChild.getIScore(rp);
                                ++rp;
                            }
                            int np = k;
                            while (np < l) {
                                double score = lS * rS * subRule.score;
                                int n5 = np++;
                                iScores2[n5] = iScores2[n5] + score;
                            }
                        }
                        ++n4;
                    }
                    if (spanScores != null) {
                        int i = 0;
                        while (i < nParentStates) {
                            int n6 = i++;
                            iScores2[n6] = iScores2[n6] * spanScores[parent.from][parent.to][this.stateClass[pState]];
                        }
                    }
                    parent.setIScores(iScores2);
                    parent.scaleIScores(leftChild.getIScale() + rightChild.getIScale());
                    break;
                }
                default: {
                    throw new Error("Malformed tree: more than two children");
                }
            }
        }
    }

    @Override
    void setRootOutsideScore(Tree<StateSet> tree) {
        tree.getLabel().setOScore(0, 1.0);
        tree.getLabel().setOScale(0);
    }

    @Override
    void doOutsideScores(Tree<StateSet> tree, boolean unaryAbove, double[][][] spanScores) {
        if (this.grammar.isLogarithmMode() || this.lexicon.isLogarithmMode()) {
            throw new Error("Grammar in logarithm mode!  Cannot do inside scores!");
        }
        if (tree.isLeaf()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short pState = parent.getState();
        int nParentStates = parent.numSubStates();
        if (!tree.isPreTerminal()) {
            double[] parentScores = parent.getOScores();
            if (spanScores != null && !unaryAbove) {
                int i = 0;
                while (i < nParentStates) {
                    int n = i++;
                    parentScores[n] = parentScores[n] * spanScores[parent.from][parent.to][this.stateClass[pState]];
                }
            }
            switch (children.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    StateSet child = children.get(0).getLabel();
                    short cState = child.getState();
                    int nChildStates = child.numSubStates();
                    double[] oScores = new double[nChildStates];
                    HierarchicalAdaptiveUnaryRule urule = (HierarchicalAdaptiveUnaryRule)this.grammar.getUnaryRule(pState, cState);
                    HierarchicalAdaptiveUnaryRule.SubRule[] subRuleArray = urule.subRuleList;
                    int n = urule.subRuleList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HierarchicalAdaptiveUnaryRule.SubRule subRule = subRuleArray[n2];
                        if (subRule != null) {
                            short level = subRule.level;
                            int i = this.substatesToCover[level] * subRule.child;
                            int j = i + this.substatesToCover[level];
                            int k = this.substatesToCover[level] * subRule.parent;
                            int l = k + this.substatesToCover[level];
                            if (pState == 0) {
                                l = 1;
                            }
                            double pS = 0.0;
                            int np = k;
                            while (np < l) {
                                pS += parent.getOScore(np);
                                ++np;
                            }
                            int cp = i;
                            while (cp < j) {
                                double score = pS * subRule.score;
                                int n3 = cp++;
                                oScores[n3] = oScores[n3] + score;
                            }
                        }
                        ++n2;
                    }
                    child.setOScores(oScores);
                    child.scaleOScores(parent.getOScale());
                    unaryAbove = true;
                    break;
                }
                case 2: {
                    StateSet leftChild = children.get(0).getLabel();
                    StateSet rightChild = children.get(1).getLabel();
                    int nLeftChildStates = leftChild.numSubStates();
                    int nRightChildStates = rightChild.numSubStates();
                    short lState = leftChild.getState();
                    short rState = rightChild.getState();
                    double[] lOScores = new double[nLeftChildStates];
                    double[] rOScores = new double[nRightChildStates];
                    HierarchicalAdaptiveBinaryRule brule = (HierarchicalAdaptiveBinaryRule)this.grammar.getBinaryRule(pState, lState, rState);
                    HierarchicalAdaptiveBinaryRule.SubRule[] subRuleArray = brule.subRuleList;
                    int n = brule.subRuleList.length;
                    int n4 = 0;
                    while (n4 < n) {
                        HierarchicalAdaptiveBinaryRule.SubRule subRule = subRuleArray[n4];
                        if (subRule != null) {
                            short level = subRule.level;
                            int e = this.substatesToCover[level] * subRule.lChild;
                            int f = e + this.substatesToCover[level];
                            int i = this.substatesToCover[level] * subRule.rChild;
                            int j = i + this.substatesToCover[level];
                            int k = this.substatesToCover[level] * subRule.parent;
                            int l = k + this.substatesToCover[level];
                            double lcS = 0.0;
                            int lp = e;
                            while (lp < f) {
                                lcS += leftChild.getIScore(lp);
                                ++lp;
                            }
                            double rcS = 0.0;
                            int rp = i;
                            while (rp < j) {
                                rcS += rightChild.getIScore(rp);
                                ++rp;
                            }
                            double pS = 0.0;
                            int np = k;
                            while (np < l) {
                                pS += parent.getOScore(np);
                                ++np;
                            }
                            double leftScore = pS * subRule.score * rcS;
                            int lp2 = e;
                            while (lp2 < f) {
                                int n5 = lp2++;
                                lOScores[n5] = lOScores[n5] + leftScore;
                            }
                            double rightScore = pS * subRule.score * lcS;
                            int rp2 = i;
                            while (rp2 < j) {
                                int n6 = rp2++;
                                rOScores[n6] = rOScores[n6] + rightScore;
                            }
                        }
                        ++n4;
                    }
                    leftChild.setOScores(lOScores);
                    leftChild.scaleOScores(parent.getOScale() + rightChild.getIScale());
                    rightChild.setOScores(rOScores);
                    rightChild.scaleOScores(parent.getOScale() + leftChild.getIScale());
                    unaryAbove = false;
                    break;
                }
                default: {
                    throw new Error("Malformed tree: more than two children");
                }
            }
            for (Tree<StateSet> child : children) {
                this.doOutsideScores(child, unaryAbove, spanScores);
            }
        }
    }

    @Override
    public double doInsideOutsideScores(Tree<StateSet> tree, boolean noSmoothing, boolean debugOutput, double[][][] spanScores) {
        this.doInsideScores(tree, noSmoothing, debugOutput, spanScores);
        this.setRootOutsideScore(tree);
        this.doOutsideScores(tree, false, spanScores);
        return Math.log(tree.getLabel().getIScore(0)) + (double)(100 * tree.getLabel().getIScale());
    }

    @Override
    public void doInsideOutsideScores(Tree<StateSet> tree, boolean noSmoothing, boolean debugOutput) {
        this.doInsideScores(tree, noSmoothing, debugOutput, null);
        this.setRootOutsideScore(tree);
        this.doOutsideScores(tree, false, null);
    }

    @Override
    public void incrementExpectedGoldCounts(Linearizer linearizer, double[] probs, Tree<StateSet> tree) {
        if (ConditionalTrainer.Options.lockGrammar) {
            return;
        }
        this.incrementExpectedGoldCounts(linearizer, probs, tree, tree.getLabel().getIScore(0), tree.getLabel().getIScale());
    }

    @Override
    public void incrementExpectedGoldCounts(Linearizer linearizer, double[] probs, Tree<StateSet> tree, double tree_score, int tree_scale) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.isPreTerminal()) {
            StateSet parent = tree.getLabel();
            StateSet child = tree.getChildren().get(0).getLabel();
            short tag = tree.getLabel().getState();
            short s = this.grammar.numSubStates[tag];
            double scalingFactor = ScalingTools.calcScaleFactor(parent.getOScale() + parent.getIScale() - tree_scale);
            short substate = 0;
            while (substate < s) {
                double pOS;
                double pIS = parent.getIScore(substate);
                if (pIS != 0.0 && (pOS = parent.getOScore(substate)) != 0.0) {
                    double weight = 1.0;
                    weight = pIS / tree_score * scalingFactor * pOS;
                    if (this.isValidExpectation(weight)) {
                        this.tmpCountsArray[substate] = weight;
                    } else {
                        System.out.println("Overflow when counting gold tags? " + weight);
                    }
                }
                substate = (short)(substate + 1);
            }
            linearizer.increment(probs, child, tag, this.tmpCountsArray, true);
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short parentState = parent.getState();
        switch (children.size()) {
            case 0: {
                break;
            }
            case 1: {
                StateSet stateSet = children.get(0).getLabel();
                short childState = stateSet.getState();
                HierarchicalAdaptiveUnaryRule urule = (HierarchicalAdaptiveUnaryRule)this.grammar.getUnaryRule(parentState, childState);
                double scalingFactor = ScalingTools.calcScaleFactor(parent.getOScale() + stateSet.getIScale() - tree_scale);
                int curInd = -1;
                HierarchicalAdaptiveUnaryRule.SubRule[] subRuleArray = urule.subRuleList;
                int weight = urule.subRuleList.length;
                int n = 0;
                while (n < weight) {
                    HierarchicalAdaptiveUnaryRule.SubRule subRule = subRuleArray[n];
                    ++curInd;
                    if (subRule != null) {
                        short level = subRule.level;
                        int i = this.substatesToCover[level] * subRule.child;
                        int j = i + this.substatesToCover[level];
                        int k = this.substatesToCover[level] * subRule.parent;
                        int l = k + this.substatesToCover[level];
                        if (parentState == 0) {
                            l = 1;
                        }
                        double pOS = 0.0;
                        int np = k;
                        while (np < l) {
                            pOS += parent.getOScore(np);
                            ++np;
                        }
                        double cS = 0.0;
                        int cp = i;
                        while (cp < j) {
                            cS += stateSet.getIScore(cp);
                            ++cp;
                        }
                        double ruleCount = subRule.score * cS / tree_score * scalingFactor * pOS;
                        if (this.spanScores != null) {
                            ruleCount /= this.spanScores[stateSet.from][stateSet.to][this.stateClass[parentState]];
                        }
                        if (this.isValidExpectation(ruleCount)) {
                            this.tmpCountsArray[curInd] = ruleCount;
                        } else if (ruleCount != 0.0) {
                            System.out.println("not an expected gold count, u: " + ruleCount + "\n" + urule.toString());
                        }
                    }
                    ++n;
                }
                linearizer.increment(probs, urule, this.tmpCountsArray, true);
                break;
            }
            case 2: {
                StateSet leftChild = children.get(0).getLabel();
                short lChildState = leftChild.getState();
                StateSet rightChild = children.get(1).getLabel();
                short rChildState = rightChild.getState();
                HierarchicalAdaptiveBinaryRule brule = (HierarchicalAdaptiveBinaryRule)this.grammar.getBinaryRule(parentState, lChildState, rChildState);
                double scalingFactor = ScalingTools.calcScaleFactor(parent.getOScale() + leftChild.getIScale() + rightChild.getIScale() - tree_scale);
                int curInd = -1;
                HierarchicalAdaptiveBinaryRule.SubRule[] subRuleArray = brule.subRuleList;
                int n = brule.subRuleList.length;
                int n2 = 0;
                while (n2 < n) {
                    HierarchicalAdaptiveBinaryRule.SubRule subRule = subRuleArray[n2];
                    short level = subRule.level;
                    ++curInd;
                    int e = this.substatesToCover[level] * subRule.lChild;
                    int f = e + this.substatesToCover[level];
                    int i = this.substatesToCover[level] * subRule.rChild;
                    int j = i + this.substatesToCover[level];
                    int k = this.substatesToCover[level] * subRule.parent;
                    int l = k + this.substatesToCover[level];
                    double pOS = 0.0;
                    int np = k;
                    while (np < l) {
                        pOS += parent.getOScore(np);
                        ++np;
                    }
                    double lS = 0.0;
                    int lp = e;
                    while (lp < f) {
                        lS += leftChild.getIScore(lp);
                        ++lp;
                    }
                    double rS = 0.0;
                    int rp = i;
                    while (rp < j) {
                        rS += rightChild.getIScore(rp);
                        ++rp;
                    }
                    double ruleCount = subRule.score * lS / tree_score * rS * scalingFactor * pOS;
                    if (this.isValidExpectation(ruleCount)) {
                        int n3 = curInd;
                        this.tmpCountsArray[n3] = this.tmpCountsArray[n3] + ruleCount;
                    } else if (ruleCount != 0.0) {
                        System.out.println("not an expected gold count, b: " + ruleCount + "\n" + brule.toString());
                    }
                    ++n2;
                }
                linearizer.increment(probs, brule, this.tmpCountsArray, true);
                break;
            }
            default: {
                throw new Error("Malformed tree: more than two children");
            }
        }
        for (Tree<StateSet> tree2 : children) {
            this.incrementExpectedGoldCounts(linearizer, probs, tree2, tree_score, tree_scale);
        }
    }

    public double[][][] getClassBracketPosteriors() {
        double tree_score = this.h_iScorePostU[0][this.length][0][this.finalLevel][0];
        int tree_scale = this.iScale[0][this.length][0];
        double[][][] result = new double[this.length][this.length + 1][this.spanPredictor.getNClasses()];
        int start = 0;
        while (start < this.length) {
            int end = start + 1;
            while (end <= this.length) {
                int lastState = this.numSubStatesArray.length;
                int state = 0;
                while (state < lastState) {
                    int clas = this.stateClass[state];
                    double spanScore = this.spanScores[start][end][clas];
                    double statePosterior = 0.0;
                    if (this.allowedSubStates[start][end][state] != null) {
                        double tmp2;
                        double tmp;
                        double posterior;
                        double scalingFactor;
                        double oS2;
                        double iS2;
                        double oS;
                        double iS;
                        int substate = 0;
                        while (substate < this.numSubStatesArray[state]) {
                            if (this.allowedSubStates[start][end][state][substate]) {
                                iS = this.h_iScorePostU[start][end][state][this.finalLevel][substate];
                                oS = this.h_oScorePreU[start][end][state][this.finalLevel][substate];
                                iS2 = this.h_iScorePreU[start][end][state][this.finalLevel][substate];
                                oS2 = this.h_oScorePostU[start][end][state][this.finalLevel][substate];
                                scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][state] + this.iScale[start][end][state] - tree_scale);
                                if (scalingFactor != 0.0 && !SloppyMath.isDangerous(posterior = Math.max(tmp = iS * oS, tmp2 = iS2 * oS2) / spanScore / tree_score * scalingFactor)) {
                                    if (posterior > 1.01) {
                                        System.out.println("too much posterior s:" + start + " e:" + end + " state " + state + " " + posterior + " " + this.spanScores[start][end]);
                                        if (SloppyMath.isVeryDangerous(posterior)) {
                                            posterior = 0.0;
                                        }
                                    }
                                    double[] dArray = result[start][end];
                                    int n = clas;
                                    dArray[n] = dArray[n] + posterior;
                                    statePosterior += posterior;
                                }
                            }
                            ++substate;
                        }
                        if (statePosterior > 1.01) {
                            System.out.println("Too much for a single state: " + statePosterior);
                            substate = 0;
                            while (substate < this.numSubStatesArray[state]) {
                                if (this.allowedSubStates[start][end][state][substate]) {
                                    iS = this.h_iScorePostU[start][end][state][this.finalLevel][substate];
                                    oS = this.h_oScorePreU[start][end][state][this.finalLevel][substate];
                                    iS2 = this.h_iScorePreU[start][end][state][this.finalLevel][substate];
                                    oS2 = this.h_oScorePostU[start][end][state][this.finalLevel][substate];
                                    scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][state] + this.iScale[start][end][state] - tree_scale);
                                    if (scalingFactor != 0.0) {
                                        tmp = iS * oS;
                                        tmp2 = iS2 * oS2;
                                        posterior = Math.max(tmp, tmp2) / spanScore / tree_score * scalingFactor;
                                        System.out.println(posterior);
                                    }
                                }
                                ++substate;
                            }
                        }
                    }
                    ++state;
                }
                if (result[start][end][0] > 2.01) {
                    System.out.println("too much in the sum, start " + start + " end " + end + "  " + result[start][end]);
                    result[start][end][0] = 0.0;
                }
                ++end;
            }
            ++start;
        }
        return result;
    }
}

