/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalBinaryRule;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchicalAdaptiveBinaryRule
extends HierarchicalBinaryRule {
    private static final long serialVersionUID = 1L;
    public short[][][] mapping;
    Tree<Double> hierarchy = new Tree<Double>(0.0);
    public int nParam;
    public SubRule[] subRuleList;

    public HierarchicalAdaptiveBinaryRule(BinaryRule b) {
        super(b);
        this.scores = new double[1][1][1];
        this.mapping = new short[1][1][1];
        this.nParam = 1;
    }

    public Pair<Integer, Integer> countParameters() {
        int maxDepth = this.hierarchy.getDepth();
        this.nParam = this.hierarchy.getYield().size();
        return new Pair<Integer, Integer>(maxDepth, this.nParam);
    }

    @Override
    public HierarchicalAdaptiveBinaryRule splitRule(short[] numSubStates, short[] newNumSubStates, Random random, double randomness, boolean doNotNormalize, int mode) {
        this.splitRuleHelper(this.hierarchy, random, 8);
        return this;
    }

    private void splitRuleHelper(Tree<Double> tree, Random random, int splitFactor) {
        if (tree.isLeaf()) {
            if (tree.getLabel() != 0.0 || this.nParam == 1) {
                ArrayList children = new ArrayList(splitFactor);
                int i = 0;
                while (i < splitFactor) {
                    Tree<Double> child = new Tree<Double>(random.nextDouble() / 100.0);
                    children.add(child);
                    ++i;
                }
                tree.setChildren(children);
                this.nParam += splitFactor - 1;
            }
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                this.splitRuleHelper(child, random, splitFactor);
            }
        }
    }

    @Override
    public void explicitlyComputeScores(int finalLevel, short[] newNumSubStates) {
        this.computeSubRuleList();
    }

    public void updateScores(double[] scores) {
        int nSubstates = this.updateHierarchy(this.hierarchy, 0, scores);
        if (nSubstates != this.nParam) {
            System.out.println("Didn't update all parameters");
        }
    }

    private int updateHierarchy(Tree<Double> tree, int nextSubstate, double[] scores) {
        if (tree.isLeaf()) {
            int n = nextSubstate++;
            double val = scores[this.identifier + n];
            if (val > 200.0) {
                val = 0.0;
                System.out.println("Ignored proposed binary value since it was danegrous");
            } else {
                tree.setLabel(val);
            }
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                nextSubstate = this.updateHierarchy(child, nextSubstate, scores);
            }
        }
        return nextSubstate;
    }

    @Override
    public int mergeRule() {
        int paramBefore = this.nParam;
        this.compactifyHierarchy(this.hierarchy);
        this.scores = null;
        this.mapping = null;
        this.subRuleList = null;
        this.scoreHierarchy = null;
        return paramBefore - this.nParam;
    }

    public List<Double> getFinalLevel() {
        return this.hierarchy.getYield();
    }

    private void compactifyHierarchy(Tree<Double> tree) {
        if (tree.getDepth() == 2) {
            boolean allZero = true;
            for (Tree<Double> child : tree.getChildren()) {
                boolean bl = allZero = allZero && child.getLabel() == 0.0;
            }
            if (allZero) {
                this.nParam -= tree.getChildren().size() - 1;
                tree.setChildren(Collections.EMPTY_LIST);
            }
        } else {
            for (Tree<Double> child : tree.getChildren()) {
                this.compactifyHierarchy(child);
            }
        }
    }

    public String toStringShort() {
        Numberer n = Numberer.getGlobalNumberer("tags");
        String lState = (String)n.object(this.leftChildState);
        String rState = (String)n.object(this.rightChildState);
        String pState = (String)n.object(this.parentState);
        return String.valueOf(pState) + " -> " + lState + " " + rState;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Numberer n = Numberer.getGlobalNumberer("tags");
        String lState = (String)n.object(this.leftChildState);
        String rState = (String)n.object(this.rightChildState);
        String pState = (String)n.object(this.parentState);
        sb.append(String.valueOf(pState) + " -> " + lState + " " + rState + "\n");
        if (this.subRuleList == null) {
            this.compactifyHierarchy(this.hierarchy);
            this.lastLevel = this.hierarchy.getDepth();
            this.computeSubRuleList();
        }
        SubRule[] subRuleArray = this.subRuleList;
        int n2 = this.subRuleList.length;
        int n3 = 0;
        while (n3 < n2) {
            SubRule rule = subRuleArray[n3];
            sb.append(rule.toString(this.lastLevel - 1));
            sb.append("\n");
            ++n3;
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public int countNonZeroFeatures() {
        int total = 0;
        for (Tree<Double> d : this.hierarchy.getPreOrderTraversal()) {
            if (d.getLabel() == 0.0) continue;
            ++total;
        }
        return total;
    }

    public int countNonZeroFringeFeatures() {
        int total = 0;
        for (Tree<Double> d : this.hierarchy.getTerminals()) {
            if (d.getLabel() == 0.0) continue;
            ++total;
        }
        return total;
    }

    public void computeSubRuleList() {
        this.subRuleList = new SubRule[this.nParam];
        int nRules = this.computeSubRules(0, 0.0, 0, 0, 0, 0, this.hierarchy);
        if (nRules != this.nParam) {
            System.out.println("A rule got lost");
        }
    }

    private int computeSubRules(int myID, double previousScore, int nextLeftSubstate, int nextRightSubstate, int nextParentSubstate, int myDepth, Tree<Double> tree) {
        if (tree.isLeaf()) {
            SubRule rule;
            double myScore = Math.exp(previousScore + tree.getLabel());
            this.subRuleList[myID] = rule = new SubRule((short)nextLeftSubstate, (short)nextRightSubstate, (short)nextParentSubstate, (short)myDepth, myScore);
            ++myID;
        } else {
            double myScore = previousScore + tree.getLabel();
            int i = 0;
            for (Tree<Double> child : tree.getChildren()) {
                myID = this.computeSubRules(myID, myScore, nextLeftSubstate * 2 + i / 4, nextRightSubstate * 2 + i / 2 % 2, nextParentSubstate * 2 + i % 2, myDepth + 1, child);
                ++i;
            }
        }
        return myID;
    }

    class SubRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        short lChild;
        short rChild;
        short parent;
        short level;
        double score;

        SubRule(short lC, short rC, short p, short l, double s) {
            this.lChild = lC;
            this.rChild = rC;
            this.parent = p;
            this.level = l;
            this.score = s;
        }

        public String toString() {
            String s = "[" + this.parent + "] \t -> \t [" + this.lChild + "] \t [" + this.rChild + "] \t " + this.score;
            return s;
        }

        public String toString(int finalLevel) {
            if (finalLevel == this.level) {
                return this.toString();
            }
            int k = (int)Math.pow(2.0, finalLevel - this.level);
            String s = "[" + k * this.parent + "-" + (k * this.parent + k - 1) + "] \t -> \t [" + k * this.lChild + "-" + (k * this.lChild + k - 1) + "] \t [" + k * this.rChild + "-" + (k * this.rChild + k - 1) + "] \t " + this.score + "\t level: " + this.level;
            return s;
        }
    }
}

