/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class HierarchicalUnaryRule
extends UnaryRule {
    private static final long serialVersionUID = 1L;
    List<double[][]> scoreHierarchy = new ArrayList<double[][]>();
    public int lastLevel = -1;

    public HierarchicalUnaryRule(HierarchicalUnaryRule b) {
        super(b);
        for (double[][] scores : b.scoreHierarchy) {
            this.scoreHierarchy.add(ArrayUtil.clone(scores));
        }
        this.lastLevel = b.lastLevel;
        this.scores = null;
    }

    public HierarchicalUnaryRule(UnaryRule b) {
        super(b);
        double[][] scoreThisLevel = new double[1][1];
        scoreThisLevel[0][0] = Math.log(b.scores[0][0]);
        this.scoreHierarchy.add(scoreThisLevel);
        this.lastLevel = 0;
        this.scores = null;
    }

    public void explicitlyComputeScores(int finalLevel, short[] newNumSubStates) {
        int newMaxStates = (int)Math.pow(2.0, finalLevel + 1);
        int newPStates = Math.min(newMaxStates, newNumSubStates[this.parentState]);
        int newCStates = Math.min(newMaxStates, newNumSubStates[this.childState]);
        newPStates = this.parentState == 0 ? 1 : newPStates;
        this.scores = new double[newCStates][newPStates];
        int level = 0;
        while (level <= this.lastLevel) {
            double[][] scoresThisLevel = this.scoreHierarchy.get(level);
            if (scoresThisLevel != null) {
                int divisorC = newCStates / scoresThisLevel.length;
                int divisorP = newPStates / scoresThisLevel[0].length;
                int child = 0;
                while (child < newCStates) {
                    int parent = 0;
                    while (parent < newPStates) {
                        double[] dArray = this.scores[child];
                        int n = parent;
                        dArray[n] = dArray[n] + scoresThisLevel[child / divisorC][parent / divisorP];
                        ++parent;
                    }
                    ++child;
                }
            }
            ++level;
        }
        int child = 0;
        while (child < newCStates) {
            int parent = 0;
            while (parent < newPStates) {
                this.scores[child][parent] = Math.exp(this.scores[child][parent]);
                ++parent;
            }
            ++child;
        }
    }

    public double[][] getLastLevel() {
        return this.scoreHierarchy.get(this.lastLevel);
    }

    public HierarchicalUnaryRule splitRule(short[] numSubStates, short[] newNumSubStates, Random random, double randomness, boolean doNotNormalize, int mode) {
        if (mode != 2) {
            throw new Error("Can't split hiereachical rule in this mode!");
        }
        int newMaxStates = (int)Math.pow(2.0, this.lastLevel + 1);
        int newPStates = Math.min(newMaxStates, newNumSubStates[this.parentState]);
        int newCStates = Math.min(newMaxStates, newNumSubStates[this.childState]);
        if (this.parentState == 0) {
            newPStates = 1;
        }
        double[][] newScores = new double[newCStates][newPStates];
        int child = 0;
        while (child < newCStates) {
            int parent = 0;
            while (parent < newPStates) {
                newScores[child][parent] = random.nextDouble() / 100.0;
                ++parent;
            }
            ++child;
        }
        HierarchicalUnaryRule newRule = new HierarchicalUnaryRule(this);
        newRule.scoreHierarchy.add(newScores);
        ++newRule.lastLevel;
        return newRule;
    }

    public int mergeRule() {
        double[][] scoresFinalLevel = this.scoreHierarchy.get(this.lastLevel);
        boolean allZero = true;
        int child = 0;
        while (child < scoresFinalLevel.length) {
            int parent = 0;
            while (parent < scoresFinalLevel[0].length) {
                allZero = allZero && scoresFinalLevel[child][parent] == 0.0;
                ++parent;
            }
            ++child;
        }
        if (allZero) {
            scoresFinalLevel = null;
            this.scoreHierarchy.remove(this.lastLevel);
            --this.lastLevel;
            return 1;
        }
        return 0;
    }

    public String toString() {
        Numberer n = Numberer.getGlobalNumberer("tags");
        String cState = (String)n.object(this.childState);
        String pState = (String)n.object(this.parentState);
        if (this.scores == null) {
            return String.valueOf(pState) + " -> " + cState + "\n";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.valueOf(pState) + " -> " + cState + "\n");
        sb.append(String.valueOf(ArrayUtil.toString(this.scores)) + "\n");
        for (double[][] s : this.scoreHierarchy) {
            sb.append(String.valueOf(ArrayUtil.toString(s)) + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public int countNonZeroFeatures() {
        int total = 0;
        int level = 0;
        while (level <= this.lastLevel) {
            double[][] scoresThisLevel = this.scoreHierarchy.get(level);
            if (scoresThisLevel != null) {
                int child = 0;
                while (child < scoresThisLevel.length) {
                    int parent = 0;
                    while (parent < scoresThisLevel[0].length) {
                        if (scoresThisLevel[child][parent] != 0.0) {
                            ++total;
                        }
                        ++parent;
                    }
                    ++child;
                }
            }
            ++level;
        }
        return total;
    }
}

