/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Binarization;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ParserData
implements Serializable {
    public Lexicon lex;
    public Grammar gr;
    Map numbs;
    SpanPredictor sp;
    short[] numSubStatesArray;
    int h_markov;
    int v_markov;
    Binarization bin;
    private static final long serialVersionUID = 1L;

    public Binarization getBinarization() {
        return this.bin;
    }

    public short[] getNumSubStatesArray() {
        return this.numSubStatesArray;
    }

    public SpanPredictor getSpanPredictor() {
        return this.sp;
    }

    public Grammar getGrammar() {
        return this.gr;
    }

    public Lexicon getLexicon() {
        return this.lex;
    }

    public Map getNumbs() {
        return this.numbs;
    }

    public int getH_markov() {
        return this.h_markov;
    }

    public int getV_markov() {
        return this.v_markov;
    }

    public ParserData(Lexicon lex, Grammar gr, SpanPredictor sp, Map numbs, short[] nSub, int v_m, int h_m, Binarization b) {
        this.lex = lex;
        this.gr = gr;
        this.sp = sp;
        this.numbs = numbs;
        this.numSubStatesArray = nSub;
        this.h_markov = h_m;
        this.v_markov = v_m;
        this.bin = b;
    }

    public boolean Save(String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            ObjectOutputStream out = new ObjectOutputStream(gzos);
            out.writeObject(this);
            out.flush();
            out.close();
            gzos.close();
            fos.close();
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
            return false;
        }
        return true;
    }

    public static ParserData Load(String fileName) {
        ParserData pData2 = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            GZIPInputStream gzis = new GZIPInputStream(fis);
            ObjectInputStream in = new ObjectInputStream(gzis);
            pData2 = (ParserData)in.readObject();
            in.close();
            gzis.close();
            fis.close();
        }
        catch (IOException e) {
            System.out.println("IOException\n" + e);
            return null;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found!");
            return null;
        }
        return pData2;
    }
}

