/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.Binarization;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Numberer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLabeler {
    Grammar grammar;
    SophisticatedLexicon lexicon;
    ArrayParser labeler;
    CoarseToFineMaxRuleParser parser;
    Numberer tagNumberer;
    Binarization binarization;

    public TreeLabeler(Grammar grammar, SophisticatedLexicon lexicon, int labelLevel, Binarization bin) {
        if (labelLevel == -1) {
            this.grammar = grammar.copyGrammar(false);
            this.lexicon = lexicon.copyLexicon();
        } else {
            int[][] fromMapping = grammar.computeMapping(1);
            int[][] toSubstateMapping = grammar.computeSubstateMapping(labelLevel);
            int[][] toMapping = grammar.computeToMapping(labelLevel, toSubstateMapping);
            double[] condProbs = grammar.computeConditionalProbabilities(fromMapping, toMapping);
            this.grammar = grammar.projectGrammar(condProbs, fromMapping, toSubstateMapping);
            this.lexicon = lexicon.projectLexicon(condProbs, fromMapping, toSubstateMapping);
            this.grammar.splitRules();
            double filter = 1.0E-10;
            this.grammar.removeUnlikelyRules(filter, 1.0);
            this.lexicon.removeUnlikelyTags(filter, 1.0);
        }
        this.grammar.logarithmMode();
        this.lexicon.logarithmMode();
        this.labeler = new ArrayParser(this.grammar, this.lexicon);
        this.parser = new CoarseToFineMaxRuleParser(grammar, lexicon, 1.0, -1, true, false, false, false, false, false, true);
        this.tagNumberer = Numberer.getGlobalNumberer("tags");
        this.binarization = bin;
    }

    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        System.err.println("Calling with " + optParser.getPassedInOptions());
        String inFileName = opts.inFileName;
        Grammar grammar = null;
        SophisticatedLexicon lexicon = null;
        TreeLabeler treeLabeler = null;
        boolean labelTree = false;
        ParserData pData2 = null;
        short[] numSubstates = null;
        if (inFileName == null) {
            System.err.println("Did not provide a grammar.");
        } else {
            labelTree = true;
            System.err.println("Loading grammar from " + inFileName + ".");
            pData2 = ParserData.Load(inFileName);
            if (pData2 == null) {
                System.out.println("Failed to load grammar from file" + inFileName + ".");
                System.exit(1);
            }
            grammar = pData2.getGrammar();
            grammar.splitRules();
            lexicon = (SophisticatedLexicon)pData2.getLexicon();
            Numberer.setNumberers(pData2.getNumbs());
            int labelLevel = opts.labelLevel;
            if (labelLevel != -1) {
                System.err.println("Labeling with projected grammar from level " + labelLevel + ".");
            }
            treeLabeler = new TreeLabeler(grammar, lexicon, labelLevel, pData2.bin);
            numSubstates = treeLabeler.grammar.numSubStates;
        }
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        Trees.TreeTransformer<String> treeTransformer = opts.keepFunctionLabels ? new Trees.FunctionLabelRetainingTreeNormalizer() : new Trees.StandardTreeNormalizer();
        try {
            BufferedReader inputData = opts.inputFile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(opts.inputFile), "UTF-8"));
            PrintWriter outputData = opts.outputFile == null ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(opts.outputFile), "UTF-8"), true);
            Tree<String> tree = null;
            String line = "";
            while ((line = inputData.readLine()) != null) {
                if (line.equals("")) {
                    outputData.write("\n");
                    continue;
                }
                if (line.equals("(())")) {
                    outputData.write("(())\n");
                    continue;
                }
                tree = Trees.PennTreeReader.parseEasy(line);
                if (tree == null) continue;
                if (tree.getYield().get(0).equals("")) {
                    outputData.write("(())\n");
                    continue;
                }
                if (tree.getChildren().size() == 0 || tree.getChildren().get(0).getLabel().equals("(") || tree.getYield().get(0).equals("")) {
                    outputData.write("(())\n");
                    continue;
                }
                if (tree.getYield().size() > opts.maxLength) continue;
                if (!labelTree) {
                    if (opts.getyield) {
                        List<String> words = tree.getYield();
                        for (String word : words) {
                            outputData.write(String.valueOf(word) + " ");
                        }
                        outputData.write("\n");
                        continue;
                    }
                    if (opts.annotateTrees) {
                        tree = TreeAnnotations.processTree(tree, opts.v_markov, opts.h_markov, opts.binarization, false);
                        outputData.write(tree + "\n");
                        continue;
                    }
                    Tree<String> normalizedTree = treeTransformer.transformTree(tree);
                    if (opts.getPOSandYield) {
                        List<Tree<String>> leafs = normalizedTree.getPreTerminals();
                        for (Tree<String> leaf : leafs) {
                            outputData.write(String.valueOf(leaf.getChild(0).getLabel()) + "\t" + leaf.getLabel() + "\n");
                        }
                        outputData.write("\n");
                        continue;
                    }
                    if (opts.escapeChars) {
                        outputData.write(String.valueOf(normalizedTree.toEscapedString()) + "\n");
                        continue;
                    }
                    outputData.write(normalizedTree + "\n");
                    continue;
                }
                tree = TreeAnnotations.processTree(tree, pData2.v_markov, pData2.h_markov, pData2.bin, false);
                List<String> sentence = tree.getYield();
                Tree<StateSet> stateSetTree = StateSetTreeList.stringTreeToStatesetTree(tree, numSubstates, false, tagNumberer);
                TreeLabeler.allocate(stateSetTree);
                Tree<String> labeledTree = treeLabeler.label(stateSetTree, sentence, opts.scores, opts.labelOnlyPOS);
                if (opts.onlyConfidence) {
                    double treeLL = stateSetTree.getLabel().getIScore(0);
                    outputData.write(String.valueOf(treeLL) + "\n");
                    outputData.flush();
                    continue;
                }
                if (labeledTree != null && labeledTree.getChildren().size() > 0) {
                    if (opts.prettyPrint) {
                        outputData.write(String.valueOf(Trees.PennTreeRenderer.render(labeledTree)) + "\n");
                    } else {
                        if (opts.labelOnlyPOS) {
                            labeledTree = TreeAnnotations.debinarizeTree(labeledTree);
                        }
                        if (opts.escapeChars) {
                            outputData.write("( " + labeledTree.getChildren().get(0).toEscapedString() + ")\n");
                        } else {
                            outputData.write("( " + labeledTree.getChildren().get(0) + ")\n");
                        }
                    }
                } else if (opts.labelOnlyPOS) {
                    List<Tree<String>> pos = tree.getPreTerminals();
                    tree = TreeAnnotations.unAnnotateTree(tree, opts.keepFunctionLabels);
                    for (Tree<String> tag : pos) {
                        String t = tag.getLabel();
                        t = String.valueOf(t) + "-0";
                        tag.setLabel(t);
                    }
                    if (opts.escapeChars) {
                        outputData.write("( " + tree.getChildren().get(0).toEscapedString() + ")\n");
                    } else {
                        outputData.write("( " + tree.getChildren().get(0) + ")\n");
                    }
                } else {
                    outputData.write("(())\n");
                }
                outputData.flush();
            }
            outputData.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    private Tree<String> label(Tree<StateSet> stateSetTree, List<String> sentence, boolean outputScores, boolean labelOnlyPOS) {
        Tree<String> tree = this.labeler.getBestViterbiDerivation(stateSetTree, outputScores, labelOnlyPOS);
        return tree;
    }

    static void allocate(Tree<StateSet> tree) {
        tree.getLabel().allocate();
        for (Tree<StateSet> child : tree.getChildren()) {
            TreeLabeler.allocate(child);
        }
    }

    public static class Options {
        @Option(name="-gr", usage="Input File for Grammar (Required)\n")
        public String inFileName;
        @Option(name="-labelLevel", usage="Parse with projected grammar from this level (yielding 2^level substates) (Default: -1 = input grammar)")
        public int labelLevel = -1;
        @Option(name="-scores", usage="Output inside scores. (Default: false)")
        public boolean scores;
        @Option(name="-getYield", usage="Get the sentences only")
        public boolean getyield;
        @Option(name="-labelOnlyPOS", usage="Labels only the POS categories")
        public boolean labelOnlyPOS;
        @Option(name="-onlyConfidence", usage="Output only confidence measure, i.e. tree likelihood: P(T|w) (Default: false)")
        public boolean onlyConfidence;
        @Option(name="-maxLength", usage="Remove sentences that are longer than this (doesn't print an empty line)")
        public int maxLength = 1000;
        @Option(name="-inputFile", usage="Read input from this file instead of reading it from STDIN.")
        public String inputFile;
        @Option(name="-outputFile", usage="Store output in this file instead of printing it to STDOUT.")
        public String outputFile;
        @Option(name="-prettyPrint", usage="Print in human readable form rather than one tree per line")
        public boolean prettyPrint;
        @Option(name="-getPOSandYield", usage="Get POS and words in CoNLL format")
        public boolean getPOSandYield;
        @Option(name="-annotateTrees", usage="Binarize and annotate trees")
        public boolean annotateTrees;
        @Option(name="-escapeChars", usage="Escape parantheses and backslashes")
        public boolean escapeChars;
        @Option(name="-keepFunctionLabels", usage="Retain function labels")
        public boolean keepFunctionLabels;
        @Option(name="-horizontalMarkovization", usage="Level of horizontal Markovization (Default: 0, i.e. no sibling information)")
        public int h_markov = 0;
        @Option(name="-verticalMarkovization", usage="Level of vertical Markovization (Default: 1, i.e. no parent information)")
        public int v_markov = 1;
        @Option(name="-b", usage="LEFT/RIGHT Binarization (Default: RIGHT)")
        public Binarization binarization = Binarization.RIGHT;
    }
}

