/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.parser.EnglishPennTreebankParseEvaluator;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;

public class TreeOracle {
    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        System.err.println("Calling with " + optParser.getPassedInOptions());
        int totalTrees = 0;
        int goldTrees = 0;
        EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String> eval = new EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String>(new HashSet<String>(Arrays.asList("ROOT", "PSEUDO")), new HashSet<String>(Arrays.asList("''", "``", ".", ":", ",")));
        try {
            BufferedReader nbestData = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(opts.nbestFile), "UTF-8"));
            BufferedReader goldData = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(opts.goldFile), "UTF-8"));
            String line = "";
            LinkedList<Tree<String>> nbestList = new LinkedList<Tree<String>>();
            while ((line = nbestData.readLine()) != null) {
                Tree<String> tree = Trees.PennTreeReader.parseEasy(line);
                if (line.equals("\n") || tree == null || tree.getYield().get(0).equals("")) {
                    Tree bestTree = null;
                    double bestF1 = -1.0;
                    Tree<String> goldTree = Trees.PennTreeReader.parseEasy(goldData.readLine());
                    for (Tree tree2 : nbestList) {
                        if (tree2.getYield().size() == 0) continue;
                        double f1 = eval.evaluate((Tree<String>)tree2, goldTree, false);
                        ++totalTrees;
                        if (!(f1 > bestF1)) continue;
                        bestF1 = f1;
                        bestTree = tree2;
                    }
                    if (bestTree == null) {
                        System.out.println("(())");
                    } else {
                        System.out.println(bestTree);
                        ++goldTrees;
                    }
                    nbestList = new LinkedList();
                    continue;
                }
                nbestList.add(tree);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.err.println("Average nbest list length:" + (double)totalTrees / (double)goldTrees);
        System.exit(0);
    }

    public static class Options {
        @Option(name="-nbestFile", usage="File with nbest lists")
        public String nbestFile;
        @Option(name="-goldFile", usage="File with gold trees")
        public String goldFile;
    }
}

