/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.MapFactory;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryCounterTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<UnaryRule, double[][]> entries;
    short[] numSubStates;
    UnaryRule searchKey;

    public Set<UnaryRule> keySet() {
        return this.entries.keySet();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(UnaryRule key) {
        return this.entries.containsKey(key);
    }

    public double[][] getCount(UnaryRule key) {
        double[][] value = this.entries.get(key);
        return value;
    }

    public double[][] getCount(short pState, short cState) {
        this.searchKey.setNodes(pState, cState);
        double[][] value = this.entries.get(this.searchKey);
        return value;
    }

    public void setCount(UnaryRule key, double[][] counts) {
        this.entries.put(key, counts);
    }

    public void incrementCount(UnaryRule key, double[][] increment) {
        double[][] current = this.getCount(key);
        if (current == null) {
            this.setCount(key, increment);
            return;
        }
        int i = 0;
        while (i < current.length) {
            if (increment[i] != null) {
                if (current[i] == null) {
                    current[i] = new double[increment[i].length];
                }
                int j = 0;
                while (j < current[i].length) {
                    double[] dArray = current[i];
                    int n = j;
                    dArray[n] = dArray[n] + increment[i][j];
                    ++j;
                }
            }
            ++i;
        }
        this.setCount(key, current);
    }

    public void incrementCount(UnaryRule key, double increment) {
        double[][] current = this.getCount(key);
        if (current == null) {
            double[][] tmp = key.getScores2();
            current = new double[tmp.length][tmp[0].length];
            ArrayUtil.fill(current, increment);
            this.setCount(key, current);
            return;
        }
        int i = 0;
        while (i < current.length) {
            if (current[i] == null) {
                current[i] = new double[this.numSubStates[key.getParentState()]];
            }
            int j = 0;
            while (j < current[i].length) {
                double[] dArray = current[i];
                int n = j++;
                dArray[n] = dArray[n] + increment;
            }
            ++i;
        }
        this.setCount(key, current);
    }

    public UnaryCounterTable(short[] numSubStates) {
        this(new MapFactory.HashMapFactory<UnaryRule, double[][]>(), numSubStates);
    }

    public UnaryCounterTable(MapFactory<UnaryRule, double[][]> mf, short[] numSubStates) {
        this.entries = mf.buildMap();
        this.searchKey = new UnaryRule(0, 0);
        this.numSubStates = numSubStates;
    }
}

