/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.discPCFG;

import edu.berkeley.nlp.discPCFG.EncodedDatum;
import edu.berkeley.nlp.discPCFG.Encoding;
import edu.berkeley.nlp.discPCFG.IndexLinearizer;
import edu.berkeley.nlp.discPCFG.ObjectiveFunction;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProperNameObjectiveFunction<F, L>
implements ObjectiveFunction {
    IndexLinearizer indexLinearizer;
    Encoding<F, L> encoding;
    EncodedDatum[] data;
    double[] x;
    double sigma;
    double lastValue;
    double[] lastDerivative;
    double[] lastX;
    boolean isUpToDate;

    @Override
    public void shutdown() {
    }

    public void updateGoldCountsNextRound() {
    }

    @Override
    public int dimension() {
        return this.indexLinearizer.getNumLinearIndexes();
    }

    @Override
    public double valueAt(double[] x) {
        this.ensureCache(x);
        this.isUpToDate = false;
        return this.lastValue;
    }

    @Override
    public double[] derivativeAt(double[] x) {
        this.ensureCache(x);
        this.isUpToDate = false;
        return this.lastDerivative;
    }

    @Override
    public double[] unregularizedDerivativeAt(double[] x) {
        return null;
    }

    private void ensureCache(double[] x) {
        if (!this.isUpToDate) {
            this.x = x;
            Pair<Double, double[]> currentValueAndDerivative = this.calculate();
            this.lastValue = currentValueAndDerivative.getFirst();
            this.lastDerivative = currentValueAndDerivative.getSecond();
            this.lastX = x;
        }
    }

    public void setX(double[] x) {
        this.x = x;
    }

    public void isUpToDate(boolean b) {
        this.isUpToDate = b;
    }

    public Pair<Double, double[]> calculate() {
        double objective = 0.0;
        System.out.println("In Calculate...");
        double[] derivatives = DoubleArrays.constantArray(0.0, this.dimension());
        int numSubLabels = this.encoding.getNumSubLabels();
        int numData = this.data.length;
        int l = 0;
        while (l < numData) {
            EncodedDatum datum = this.data[l];
            double[] logProbabilities = this.getLogProbabilities(datum, this.x, this.encoding, this.indexLinearizer);
            int C = datum.getLabelIndex();
            double[] labelWeights = datum.getWeights();
            int numSubstatesC = labelWeights.length;
            int substate0 = this.encoding.getLabelSubindexBegin(C);
            int c = 0;
            while (c < numSubstatesC) {
                objective -= labelWeights[c] * logProbabilities[substate0 + c];
                ++c;
            }
            double[] probabilities = new double[numSubLabels];
            double sum = 0.0;
            int c2 = 0;
            while (c2 < numSubLabels) {
                probabilities[c2] = Math.exp(logProbabilities[c2]);
                sum += probabilities[c2];
                ++c2;
            }
            if (Math.abs(sum - 1.0) > 0.001) {
                System.err.println("Probabilities do not sum to 1!");
            }
            int i = 0;
            while (i < datum.getNumActiveFeatures()) {
                int index;
                int featureIndex = datum.getFeatureIndex(i);
                double featureCount = datum.getFeatureCount(i);
                int c3 = 0;
                while (c3 < numSubLabels) {
                    int n = index = this.indexLinearizer.getLinearIndex(featureIndex, c3);
                    derivatives[n] = derivatives[n] + featureCount * probabilities[c3];
                    ++c3;
                }
                c3 = 0;
                while (c3 < numSubstatesC) {
                    int n = index = this.indexLinearizer.getLinearIndex(featureIndex, substate0 + c3);
                    derivatives[n] = derivatives[n] - labelWeights[c3] * featureCount;
                    ++c3;
                }
                ++i;
            }
            ++l;
        }
        double sigma2 = this.sigma * this.sigma;
        double penalty = 0.0;
        int index = 0;
        while (index < this.x.length) {
            penalty += this.x[index] * this.x[index];
            ++index;
        }
        objective += penalty / (2.0 * sigma2);
        index = 0;
        while (index < this.x.length) {
            int n = index;
            derivatives[n] = derivatives[n] + this.x[index] / sigma2;
            ++index;
        }
        return new Pair<Double, double[]>(objective, derivatives);
    }

    @Override
    public <F, L> double[] getLogProbabilities(EncodedDatum datum, double[] weights, Encoding<F, L> encoding, IndexLinearizer indexLinearizer) {
        int numSubLabels = encoding.getNumSubLabels();
        double[] logProbabilities = DoubleArrays.constantArray(0.0, numSubLabels);
        int i = 0;
        while (i < datum.getNumActiveFeatures()) {
            int featureIndex = datum.getFeatureIndex(i);
            double featureCount = datum.getFeatureCount(i);
            int j = 0;
            while (j < numSubLabels) {
                int index = indexLinearizer.getLinearIndex(featureIndex, j);
                double weight = weights[index];
                int n = j++;
                logProbabilities[n] = logProbabilities[n] + weight * featureCount;
            }
            ++i;
        }
        double logNormalizer = SloppyMath.logAdd(logProbabilities);
        int i2 = 0;
        while (i2 < numSubLabels) {
            int n = i2++;
            logProbabilities[n] = logProbabilities[n] - logNormalizer;
        }
        return logProbabilities;
    }

    public ProperNameObjectiveFunction(Encoding<F, L> encoding, EncodedDatum[] data, IndexLinearizer indexLinearizer, double sigma) {
        this.indexLinearizer = indexLinearizer;
        this.encoding = encoding;
        this.data = data;
        this.sigma = sigma;
    }
}

