/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.DifferentiableFunction;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.GradientMinimizer;
import edu.berkeley.nlp.math.Normalizer;
import edu.berkeley.nlp.util.Logger;

public class ExponentiatedGradientMinimizer
implements GradientMinimizer {
    private static final double EPS = 1.0E-10;
    private final Normalizer normalizer;
    private final int maxIterations;
    private final double stepSizeMultiplier;

    public ExponentiatedGradientMinimizer(Normalizer normalizer, int maxIterations, double stepSizeMultiplier) {
        this.normalizer = normalizer;
        this.maxIterations = maxIterations;
        this.stepSizeMultiplier = stepSizeMultiplier;
    }

    public double[] minimize(DifferentiableFunction function, double[] initial, double tolerance, boolean project) {
        return null;
    }

    public double[] minimize(DifferentiableFunction function, double[] initial, double tolerance) {
        double[] guess = DoubleArrays.clone(initial);
        int iteration = 0;
        while (iteration < this.maxIterations) {
            double[] derivatives = function.derivativeAt(guess);
            double value = function.valueAt(guess);
            double[] direction = DoubleArrays.multiply(derivatives, -this.stepSizeMultiplier);
            double[] scale = DoubleArrays.exponentiate(direction);
            double[] newGuess = this.normalizer.normalize(DoubleArrays.pointwiseMultiply(guess, scale));
            double newValue = function.valueAt(newGuess);
            Logger.i().logs(String.format("Exponentiated gradient: iteration %d (max %d) completed with value %f", iteration + 1, this.maxIterations, newValue), new Object[0]);
            guess = newGuess;
            ++iteration;
        }
        return guess;
    }

    private boolean converged(double value, double nextValue, double tolerance) {
        double valueAverage;
        if (value == nextValue) {
            return true;
        }
        double valueChange = Math.abs(nextValue - value);
        return valueChange / (valueAverage = Math.abs(nextValue + value + 1.0E-10) / 2.0) < tolerance;
    }
}

