/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.treebank;

import edu.berkeley.nlp.treebank.TreebankLanguagePack;
import edu.berkeley.nlp.util.Filter;
import edu.berkeley.nlp.util.Filters;
import java.io.Serializable;

public abstract class AbstractTreebankLanguagePack
implements TreebankLanguagePack,
Serializable {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private final Filter punctTagStringAcceptFilter = Filters.collectionAcceptFilter(this.punctuationTags());
    private final Filter punctWordStringAcceptFilter = Filters.collectionAcceptFilter(this.punctuationWords());
    private final Filter sFPunctTagStringAcceptFilter = Filters.collectionAcceptFilter(this.sentenceFinalPunctuationTags());
    private final Filter eIPunctTagStringAcceptFilter = Filters.collectionAcceptFilter(this.evalBIgnoredPunctuationTags());
    private final Filter startSymbolAcceptFilter = Filters.collectionAcceptFilter(this.startSymbols());
    private static final long serialVersionUID = -6506749780512708352L;

    public abstract String[] punctuationTags();

    public abstract String[] punctuationWords();

    public abstract String[] sentenceFinalPunctuationTags();

    public String[] evalBIgnoredPunctuationTags() {
        return this.punctuationTags();
    }

    public boolean isPunctuationTag(String str) {
        return this.punctTagStringAcceptFilter.accept(str);
    }

    public boolean isPunctuationWord(String str) {
        return this.punctWordStringAcceptFilter.accept(str);
    }

    public boolean isSentenceFinalPunctuationTag(String str) {
        return this.sFPunctTagStringAcceptFilter.accept(str);
    }

    public boolean isEvalBIgnoredPunctuationTag(String str) {
        return this.eIPunctTagStringAcceptFilter.accept(str);
    }

    public Filter punctuationTagAcceptFilter() {
        return this.punctTagStringAcceptFilter;
    }

    public Filter punctuationTagRejectFilter() {
        return Filters.notFilter(this.punctTagStringAcceptFilter);
    }

    public Filter punctuationWordAcceptFilter() {
        return this.punctWordStringAcceptFilter;
    }

    public Filter punctuationWordRejectFilter() {
        return Filters.notFilter(this.punctWordStringAcceptFilter);
    }

    public Filter sentenceFinalPunctuationTagAcceptFilter() {
        return this.sFPunctTagStringAcceptFilter;
    }

    public Filter evalBIgnoredPunctuationTagAcceptFilter() {
        return this.eIPunctTagStringAcceptFilter;
    }

    public Filter evalBIgnoredPunctuationTagRejectFilter() {
        return Filters.notFilter(this.eIPunctTagStringAcceptFilter);
    }

    public String getEncoding() {
        return DEFAULT_ENCODING;
    }

    public char[] labelAnnotationIntroducingCharacters() {
        return new char[0];
    }

    private int postBasicCategoryIndex(String category) {
        boolean sawAtZero = false;
        int i = 0;
        int leng = category.length();
        while (i < leng) {
            char ch = category.charAt(i);
            if (this.isLabelAnnotationIntroducingCharacter(ch)) {
                if (i == 0) {
                    sawAtZero = true;
                } else {
                    if (!sawAtZero) break;
                    sawAtZero = false;
                }
            }
            ++i;
        }
        return i;
    }

    public String basicCategory(String category) {
        if (category == null) {
            return null;
        }
        return category.substring(0, this.postBasicCategoryIndex(category));
    }

    public String categoryAndFunction(String category) {
        if (category == null) {
            return null;
        }
        String catFunc = category.substring(0);
        int i = this.lastIndexOfNumericTag(catFunc);
        while (i >= 0) {
            catFunc = catFunc.substring(0, i);
            i = this.lastIndexOfNumericTag(catFunc);
        }
        return catFunc;
    }

    private int lastIndexOfNumericTag(String category) {
        if (category == null) {
            return -1;
        }
        int last = -1;
        int i = category.length() - 1;
        while (i >= 0) {
            if (this.isLabelAnnotationIntroducingCharacter(category.charAt(i))) {
                boolean onlyDigitsFollow = false;
                int j = i + 1;
                while (j < category.length()) {
                    onlyDigitsFollow = true;
                    if (!Character.isDigit(category.charAt(j))) {
                        onlyDigitsFollow = false;
                        break;
                    }
                    ++j;
                }
                if (onlyDigitsFollow) {
                    last = i;
                }
            }
            --i;
        }
        return last;
    }

    public boolean isLabelAnnotationIntroducingCharacter(char ch) {
        char[] cutChars = this.labelAnnotationIntroducingCharacters();
        int i = 0;
        while (i < cutChars.length) {
            if (ch == cutChars[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isStartSymbol(String str) {
        return this.startSymbolAcceptFilter.accept(str);
    }

    public Filter startSymbolAcceptFilter() {
        return this.startSymbolAcceptFilter;
    }

    public abstract String[] startSymbols();

    public String startSymbol() {
        String[] ssyms = this.startSymbols();
        if (ssyms == null || ssyms.length == 0) {
            return null;
        }
        return ssyms[0];
    }
}

