/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Filter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filters {
    private Filters() {
    }

    public static Filter acceptFilter() {
        return new CategoricalFilter(true);
    }

    public static <T> Filter<T> acceptFilter(Class<T> name) {
        return new CategoricalFilter(true);
    }

    public static <T> Filter<T> acceptFilter(T dummyObject) {
        return new CategoricalFilter(true);
    }

    public static Filter rejectFilter() {
        return new CategoricalFilter(false);
    }

    public static <T> Filter<T> collectionAcceptFilter(T[] objs) {
        return new CollectionAcceptFilter(Arrays.asList(objs), true);
    }

    public static <T> Filter<T> collectionAcceptFilter(Collection<T> objs) {
        return new CollectionAcceptFilter(objs, true);
    }

    public static <T> Filter<T> collectionRejectFilter(T[] objs) {
        return new CollectionAcceptFilter(Arrays.asList(objs), false);
    }

    public static <T> Filter<T> collectionRejectFilter(Collection<T> objs) {
        return new CollectionAcceptFilter(objs, false);
    }

    public static <T> Filter<T> andFilter(Filter<T> f1, Filter<T> f2) {
        return new CombinedFilter<T>(f1, f2, true);
    }

    public static <T> Filter<T> orFilter(Filter<T> f1, Filter<T> f2) {
        return new CombinedFilter<T>(f1, f2, false);
    }

    public static <T> Filter<T> notFilter(Filter<T> filter) {
        return new NegatedFilter<T>(filter);
    }

    public static <T> Filter<T> switchedFilter(Filter<T> filter, boolean negated) {
        return new NegatedFilter<T>(filter, negated);
    }

    public static <T> Object[] filter(T[] elems, Filter<T> filter) {
        ArrayList<T> filtered = new ArrayList<T>();
        int i = 0;
        while (i < elems.length) {
            if (filter.accept(elems[i])) {
                filtered.add(elems[i]);
            }
            ++i;
        }
        return filtered.toArray((Object[])Array.newInstance(elems.getClass().getComponentType(), filtered.size()));
    }

    public static <T> void retainAll(Collection<T> elems, Filter<T> filter) {
        for (T elem : elems) {
            if (filter.accept(elem)) continue;
            elems.remove(elem);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CategoricalFilter<T>
    implements Filter<T> {
        private final boolean judgment;

        private CategoricalFilter(boolean judgment) {
            this.judgment = judgment;
        }

        @Override
        public boolean accept(T obj) {
            return this.judgment;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CollectionAcceptFilter<T>
    implements Filter<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Collection<T> args;
        private final boolean judgment;

        private CollectionAcceptFilter(Collection<T> c, boolean judgment) {
            this.args = new HashSet<T>(c);
            this.judgment = judgment;
        }

        @Override
        public boolean accept(T obj) {
            if (this.args.contains(obj)) {
                return this.judgment;
            }
            return !this.judgment;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombinedFilter<T>
    implements Filter<T> {
        private Filter<T> f1;
        private Filter<T> f2;
        private boolean conjunction;

        public CombinedFilter(Filter<T> f1, Filter<T> f2, boolean conjunction) {
            this.f1 = f1;
            this.f2 = f2;
            this.conjunction = conjunction;
        }

        @Override
        public boolean accept(T o) {
            if (this.conjunction) {
                return this.f1.accept(o) && this.f2.accept(o);
            }
            return this.f1.accept(o) || this.f2.accept(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NegatedFilter<T>
    implements Filter<T> {
        private Filter<T> filter;
        private boolean negated;

        public NegatedFilter(Filter<T> filter, boolean negated) {
            this.filter = filter;
            this.negated = negated;
        }

        public NegatedFilter(Filter<T> filter) {
            this(filter, true);
        }

        @Override
        public boolean accept(T o) {
            return this.negated ^ this.filter.accept(o);
        }
    }
}

