/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.CharEncUtils;
import edu.berkeley.nlp.util.StrUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GZIPUtils {
    private GZIPUtils() {
    }

    public static BufferedReader openIn(String path) throws IOException {
        return GZIPUtils.openIn(new File(path));
    }

    public static BufferedReader openIn(File path) throws IOException {
        return new BufferedReader(CharEncUtils.getReader(GZIPUtils.getInputStream(path)));
    }

    public static InputStream getInputStream(String path) throws IOException {
        return GZIPUtils.getInputStream(new File(path));
    }

    public static InputStream getInputStream(File path) throws IOException {
        InputStream instream = path.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(path)) : new FileInputStream(path);
        return instream;
    }

    public static BufferedReader openInEasy(String path) {
        if (StrUtils.isEmpty(path)) {
            return null;
        }
        return GZIPUtils.openInEasy(new File(path));
    }

    public static BufferedReader openInEasy(File path) {
        if (path == null) {
            return null;
        }
        try {
            return GZIPUtils.openIn(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedReader openInHard(String path) {
        return GZIPUtils.openInHard(new File(path));
    }

    public static BufferedReader openInHard(File path) {
        try {
            return GZIPUtils.openIn(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PrintWriter openOut(String path) throws IOException {
        return GZIPUtils.openOut(new File(path));
    }

    public static PrintWriter openOut(File path) throws IOException {
        OutputStream outstream = path.getName().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(path)) : new FileOutputStream(path);
        return new PrintWriter(CharEncUtils.getWriter(outstream));
    }

    public static PrintWriter openOutEasy(String path) {
        if (StrUtils.isEmpty(path)) {
            return null;
        }
        return GZIPUtils.openOutEasy(new File(path));
    }

    public static PrintWriter openOutEasy(File path) {
        if (path == null) {
            return null;
        }
        try {
            return GZIPUtils.openOut(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static PrintWriter openOutHard(String path) {
        return GZIPUtils.openOutHard(new File(path));
    }

    public static PrintWriter openOutHard(File path) {
        try {
            return GZIPUtils.openOut(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

