/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.MapFactory;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interner<T> {
    Map<T, T> canonicalMap;
    CanonicalFactory<T> cf;

    public T intern(T object) {
        T canonical = this.canonicalMap.get(object);
        if (canonical == null) {
            canonical = this.cf.build(object);
            this.canonicalMap.put(canonical, canonical);
        }
        return canonical;
    }

    public boolean contains(T object) {
        return this.canonicalMap.containsKey(object);
    }

    public int size() {
        return this.canonicalMap.size();
    }

    public Collection<T> getCanonicalObjects() {
        return this.canonicalMap.values();
    }

    public Interner() {
        this(new MapFactory.HashMapFactory(), new IdentityCanonicalFactory());
    }

    public Interner(MapFactory<T, T> mf) {
        this(mf, new IdentityCanonicalFactory());
    }

    public Interner(CanonicalFactory<T> f) {
        this(new MapFactory.HashMapFactory(), f);
    }

    public Interner(MapFactory<T, T> mf, CanonicalFactory<T> cf) {
        this.canonicalMap = mf.buildMap();
        this.cf = cf;
    }

    public void clear() {
        this.canonicalMap.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CanonicalFactory<T> {
        public T build(T var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IdentityCanonicalFactory<T>
    implements CanonicalFactory<T> {
        IdentityCanonicalFactory() {
        }

        @Override
        public T build(T object) {
            return object;
        }
    }
}

