/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.DeepCloneable;
import edu.berkeley.nlp.util.MapUtils;
import edu.berkeley.nlp.util.NumUtils;
import edu.berkeley.nlp.util.Pair;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListUtils {
    public static ArrayList<Double> toList(double[] xs) {
        ArrayList<Double> list = new ArrayList<Double>();
        double[] dArray = xs;
        int n = xs.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            list.add(x);
            ++n2;
        }
        return list;
    }

    public static <T> ArrayList<T> toList(Iterable<T> it) {
        if (it instanceof ArrayList) {
            return (ArrayList)it;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T x : it) {
            list.add(x);
        }
        return list;
    }

    public static <T> ArrayList<T> newList(T ... list) {
        return new ArrayList<T>(Arrays.asList(list));
    }

    public static <T> ArrayList<T> newListFill(T x, int n) {
        ArrayList<T> list = new ArrayList<T>(n);
        int i = 0;
        while (i < n) {
            list.add(x);
            ++i;
        }
        return list;
    }

    public static int maxStringLength(List<String> strings) {
        int l = 0;
        for (String s : strings) {
            l = Math.max(l, s.length());
        }
        return l;
    }

    public static <T> Map<T, Integer> buildHistogram(Collection<T> c) {
        HashMap counts = new HashMap();
        for (T x : c) {
            MapUtils.incr(counts, x);
        }
        return counts;
    }

    public static <T> void randomPermute(List<T> l, Random rand) {
        int i = 0;
        while (i < l.size()) {
            int j = i + rand.nextInt(l.size() - i);
            T x = l.get(i);
            l.set(i, l.get(j));
            l.set(j, x);
            ++i;
        }
    }

    public static <T> T getLast(List<T> l) {
        return ListUtils.get(l, -1);
    }

    public static <T> T get(List<T> l, int i) {
        return ListUtils.get(l, i, null);
    }

    public static <T> T get(List<T> l, int i, T defValue) {
        if (i < 0) {
            i += l.size();
        }
        if (i < 0 || i >= l.size()) {
            return defValue;
        }
        return l.get(i);
    }

    public static <T> T removeLast(List<T> l) {
        return l.remove(l.size() - 1);
    }

    public static <T> T getLast(T[] l) {
        return ListUtils.get(l, -1);
    }

    public static <T> T get(T[] l, int i) {
        return ListUtils.get(l, i, null);
    }

    public static <T> T get(T[] l, int i, T defValue) {
        if (i < 0) {
            i += l.length;
        }
        if (i < 0 || i >= l.length) {
            return defValue;
        }
        return l[i];
    }

    public static double get(double[] l, int i, double defValue) {
        if (i < 0) {
            i += l.length;
        }
        if (i < 0 || i >= l.length) {
            return defValue;
        }
        return l[i];
    }

    public static <T> int indexOf(T[] v, T x) {
        if (x == null) {
            int i = 0;
            while (i < v.length) {
                if (v[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < v.length) {
                if (x.equals(v[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int indexOf(int[] v, int x) {
        int i = 0;
        while (i < v.length) {
            if (x == v[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int countOf(T[] v, T x) {
        int n = 0;
        if (x == null) {
            int i = 0;
            while (i < v.length) {
                if (v[i] == null) {
                    ++n;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < v.length) {
                if (x.equals(v[i])) {
                    ++n;
                }
                ++i;
            }
        }
        return n;
    }

    public static int countOf(boolean[] v, boolean x) {
        int n = 0;
        int i = 0;
        while (i < v.length) {
            if (x == v[i]) {
                ++n;
            }
            ++i;
        }
        return n;
    }

    public static int[] identityMapArray(int n) {
        int[] arr = new int[n];
        int i = 0;
        while (i < n) {
            arr[i] = i;
            ++i;
        }
        return arr;
    }

    public static int minIndex(double[] list) {
        int bi = -1;
        int i = 0;
        while (i < list.length) {
            if (bi == -1 || list[i] < list[bi]) {
                bi = i;
            }
            ++i;
        }
        return bi;
    }

    public static int maxIndex(int[] list) {
        int bi = -1;
        int i = 0;
        while (i < list.length) {
            if (bi == -1 || list[i] > list[bi]) {
                bi = i;
            }
            ++i;
        }
        return bi;
    }

    public static int maxIndex(double[] list) {
        int bi = -1;
        int i = 0;
        while (i < list.length) {
            if (bi == -1 || list[i] > list[bi]) {
                bi = i;
            }
            ++i;
        }
        return bi;
    }

    public static double max(double[] list) {
        double m = Double.NEGATIVE_INFINITY;
        double[] dArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            m = Math.max(m, x);
            ++n2;
        }
        return m;
    }

    public static double max(double[][] mat) {
        double m = Double.NEGATIVE_INFINITY;
        double[][] dArray = mat;
        int n = mat.length;
        int n2 = 0;
        while (n2 < n) {
            double[] list;
            double[] dArray2 = list = dArray[n2];
            int n3 = list.length;
            int n4 = 0;
            while (n4 < n3) {
                double x = dArray2[n4];
                m = Math.max(m, x);
                ++n4;
            }
            ++n2;
        }
        return m;
    }

    public static int max(int[] list) {
        int m = Integer.MIN_VALUE;
        int[] nArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            m = Math.max(m, x);
            ++n2;
        }
        return m;
    }

    public static int sum(int[] list) {
        int sum = 0;
        int[] nArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            sum += x;
            ++n2;
        }
        return sum;
    }

    public static double mean(double[] list) {
        return ListUtils.sum(list) / (double)list.length;
    }

    public static double sum(double[] list) {
        double sum = 0.0;
        double[] dArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            sum += x;
            ++n2;
        }
        return sum;
    }

    public static double sum(double[][] list) {
        double sum = 0.0;
        double[][] dArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            double[] x = dArray[n2];
            sum += ListUtils.sum(x);
            ++n2;
        }
        return sum;
    }

    public static double sum(List<Double> list) {
        double sum = 0.0;
        for (double x : list) {
            sum += x;
        }
        return sum;
    }

    public static double logSum(double[] list) {
        double sum = Double.NEGATIVE_INFINITY;
        double[] dArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            sum = NumUtils.logAdd(sum, x);
            ++n2;
        }
        return sum;
    }

    public static double[] expMut(double[] list) {
        int i = 0;
        while (i < list.length) {
            list[i] = Math.exp(list[i]);
            ++i;
        }
        return list;
    }

    public static double[] exp(double[] list) {
        double[] newlist = new double[list.length];
        int i = 0;
        while (i < list.length) {
            newlist[i] = Math.exp(list[i]);
            ++i;
        }
        return newlist;
    }

    public static double[] log(double[] list) {
        double[] newlist = new double[list.length];
        int i = 0;
        while (i < list.length) {
            newlist[i] = Math.log(list[i]);
            ++i;
        }
        return newlist;
    }

    public static int[] applyPermutation(int[] data, int[] perm) {
        assert (data.length == perm.length);
        int[] newData = new int[data.length];
        int i = 0;
        while (i < data.length) {
            newData[i] = data[perm[i]];
            ++i;
        }
        return newData;
    }

    public static double[] applyPermutation(double[] data, int[] perm) {
        assert (data.length == perm.length);
        double[] newData = new double[data.length];
        int i = 0;
        while (i < data.length) {
            newData[i] = data[perm[i]];
            ++i;
        }
        return newData;
    }

    public static <T> T[] applyPermutation(T[] data, int[] perm) {
        assert (data.length == perm.length);
        T[] newData = ListUtils.newArray(data);
        int i = 0;
        while (i < data.length) {
            newData[i] = data[perm[i]];
            ++i;
        }
        return newData;
    }

    public static double[] applyInversePermutation(double[] data, int[] perm) {
        assert (data.length == perm.length);
        double[] newData = new double[data.length];
        int i = 0;
        while (i < data.length) {
            newData[perm[i]] = data[i];
            ++i;
        }
        return newData;
    }

    public static int[] inversePermutation(int[] perm) {
        int[] newperm = ListUtils.newInt(perm.length, -1);
        int i = 0;
        while (i < perm.length) {
            if (perm[i] != -1) {
                newperm[perm[i]] = i;
            }
            ++i;
        }
        return newperm;
    }

    public static void assertIsPermutation(int[] perm) {
        boolean[] hit = new boolean[perm.length];
        int[] nArray = perm;
        int n = perm.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            assert (!hit[i]);
            hit[i] = true;
            ++n2;
        }
    }

    public static int[] append(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        int j = 0;
        int i = 0;
        while (i < a.length) {
            c[j] = a[i];
            ++i;
            ++j;
        }
        i = 0;
        while (i < b.length) {
            c[j] = b[i];
            ++i;
            ++j;
        }
        return c;
    }

    public static double[] append(double[] a, double[] b) {
        double[] c = new double[a.length + b.length];
        int j = 0;
        int i = 0;
        while (i < a.length) {
            c[j] = a[i];
            ++i;
            ++j;
        }
        i = 0;
        while (i < b.length) {
            c[j] = b[i];
            ++i;
            ++j;
        }
        return c;
    }

    public static <T> T[] append(T[] a, T[] b) {
        T[] c = ListUtils.newArray(a.length + b.length, a[0]);
        int j = 0;
        int i = 0;
        while (i < a.length) {
            c[j] = a[i];
            ++i;
            ++j;
        }
        i = 0;
        while (i < b.length) {
            c[j] = b[i];
            ++i;
            ++j;
        }
        return c;
    }

    public static Integer[] toObjArray(int[] v) {
        Integer[] newv = new Integer[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = v[i];
            ++i;
        }
        return newv;
    }

    public static Double[] toObjArray(double[] v) {
        Double[] newv = new Double[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = v[i];
            ++i;
        }
        return newv;
    }

    public static Double[][] toObjArray(double[][] v) {
        Double[][] newv = new Double[v.length][];
        int i = 0;
        while (i < v.length) {
            newv[i] = new Double[v[i].length];
            int j = 0;
            while (j < v[i].length) {
                newv[i][j] = v[i][j];
                ++j;
            }
            ++i;
        }
        return newv;
    }

    public static Integer[][] toObjArray(int[][] v) {
        Integer[][] newv = new Integer[v.length][];
        int i = 0;
        while (i < v.length) {
            newv[i] = new Integer[v[i].length];
            int j = 0;
            while (j < v[i].length) {
                newv[i][j] = v[i][j];
                ++j;
            }
            ++i;
        }
        return newv;
    }

    public static <T> Object[] toObjectArray(T[] v) {
        Object[] newv = new Object[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = v[i];
            ++i;
        }
        return newv;
    }

    public static boolean[] shallowClone(boolean[] v) {
        if (v == null) {
            return null;
        }
        return (boolean[])v.clone();
    }

    public static int[] shallowClone(int[] v) {
        if (v == null) {
            return null;
        }
        return (int[])v.clone();
    }

    public static double[][] shallowClone(double[][] v) {
        if (v == null) {
            return null;
        }
        double[][] newv = new double[v.length][];
        int i = 0;
        while (i < v.length) {
            newv[i] = ListUtils.shallowClone(v[i]);
            ++i;
        }
        return newv;
    }

    public static double[] shallowClone(double[] v) {
        if (v == null) {
            return null;
        }
        return (double[])v.clone();
    }

    public static <T> T[][] shallowClone(T[][] v) {
        if (v == null) {
            return null;
        }
        Object[][] newv = (Object[][])ListUtils.newArray(v);
        int i = 0;
        while (i < v.length) {
            newv[i] = ListUtils.newArray(v[i]);
            int j = 0;
            while (j < v[i].length) {
                newv[i][j] = v[i][j];
                ++j;
            }
            ++i;
        }
        return newv;
    }

    public static <T> T[] shallowClone(T[] v) {
        if (v == null) {
            return null;
        }
        T[] newv = ListUtils.newArray(v);
        int i = 0;
        while (i < v.length) {
            newv[i] = v[i];
            ++i;
        }
        return newv;
    }

    public static <T> T[] deepClone(T[] v) {
        if (v == null) {
            return null;
        }
        T[] newv = ListUtils.newArray(v);
        int i = 0;
        while (i < v.length) {
            newv[i] = ((DeepCloneable)v[i]).deepClone();
            ++i;
        }
        return newv;
    }

    public static <T> List<T> deepClone(List<T> v) {
        if (v == null) {
            return null;
        }
        ArrayList newv = new ArrayList();
        for (T x : v) {
            newv.add(((DeepCloneable)x).deepClone());
        }
        return newv;
    }

    public static <T> T[] newArray(T[] v) {
        return (Object[])Array.newInstance(v.getClass().getComponentType(), v.length);
    }

    public static int[][] newInt(int nr, int nc, int x) {
        int[][] v = new int[nr][nc];
        int r = 0;
        while (r < nr) {
            int c = 0;
            while (c < nc) {
                v[r][c] = x;
                ++c;
            }
            ++r;
        }
        return v;
    }

    public static double[][] newDouble(int nr, int nc, double x) {
        double[][] v = new double[nr][nc];
        int r = 0;
        while (r < nr) {
            int c = 0;
            while (c < nc) {
                v[r][c] = x;
                ++c;
            }
            ++r;
        }
        return v;
    }

    public static double[][] newDouble(int nr, int[] nc, double x) {
        double[][] v = new double[nr][];
        int r = 0;
        while (r < nr) {
            v[r] = new double[nc[r]];
            int c = 0;
            while (c < nc[r]) {
                v[r][c] = x;
                ++c;
            }
            ++r;
        }
        return v;
    }

    public static double[][][] newDouble(int nr, int nc, int nk, double x) {
        double[][][] v = new double[nr][nc][nk];
        int r = 0;
        while (r < nr) {
            int c = 0;
            while (c < nc) {
                int k = 0;
                while (k < nk) {
                    v[r][c][k] = x;
                    ++k;
                }
                ++c;
            }
            ++r;
        }
        return v;
    }

    public static double[] newDouble(int n, double x) {
        double[] v = new double[n];
        Arrays.fill(v, x);
        return v;
    }

    public static int[] newInt(int n, int x) {
        int[] v = new int[n];
        Arrays.fill(v, x);
        return v;
    }

    public static <T> T[] newArray(int n, Class c, Generator<T> gen) {
        Object[] a = (Object[])Array.newInstance(c, n);
        int i = 0;
        while (i < n) {
            a[i] = gen.generate(i);
            ++i;
        }
        return a;
    }

    public static <T> T[] newArray(int n, T x) {
        Object[] a = (Object[])Array.newInstance(x.getClass(), n);
        int i = 0;
        while (i < n) {
            a[i] = x;
            ++i;
        }
        return a;
    }

    public static double[] mult(double f, double[] vec) {
        double[] newVec = new double[vec.length];
        int i = 0;
        while (i < vec.length) {
            newVec[i] = f * vec[i];
            ++i;
        }
        return newVec;
    }

    public static void multMut(double[] vec, double f) {
        int i = 0;
        while (i < vec.length) {
            int n = i++;
            vec[n] = vec[n] * f;
        }
    }

    public static void multMut(double[][] mat, double f) {
        double[][] dArray = mat;
        int n = mat.length;
        int n2 = 0;
        while (n2 < n) {
            double[] vec = dArray[n2];
            ListUtils.multMut(vec, f);
            ++n2;
        }
    }

    public static double[] incr(double[] v1, double factor, double[] v2) {
        int i = 0;
        while (i < v1.length) {
            int n = i;
            v1[n] = v1[n] + factor * v2[i];
            ++i;
        }
        return v1;
    }

    public static double[] incr(double[] v1, double x) {
        int i = 0;
        while (i < v1.length) {
            int n = i++;
            v1[n] = v1[n] + x;
        }
        return v1;
    }

    public static int[] set(int[] v, int x) {
        int i = 0;
        while (i < v.length) {
            v[i] = x;
            ++i;
        }
        return v;
    }

    public static int[] set(int[] v, int[] x, int n) {
        int i = 0;
        while (i < n) {
            v[i] = x[i];
            ++i;
        }
        return v;
    }

    public static int[] set(int[] v, int[] x) {
        return ListUtils.set(v, x, v.length);
    }

    public static double[] set(double[] v, double[] x) {
        int i = 0;
        while (i < v.length) {
            v[i] = x[i];
            ++i;
        }
        return v;
    }

    public static double[] set(double[] v, double x) {
        int i = 0;
        while (i < v.length) {
            v[i] = x;
            ++i;
        }
        return v;
    }

    public static double[][] set(double[][] v, double[][] x) {
        int i = 0;
        while (i < v.length) {
            int j = 0;
            while (j < v[i].length) {
                v[i][j] = x[i][j];
                ++j;
            }
            ++i;
        }
        return v;
    }

    public static double[][] set(double[][] v, double x) {
        int i = 0;
        while (i < v.length) {
            ListUtils.set(v[i], x);
            ++i;
        }
        return v;
    }

    public static double[][][] set(double[][][] v, double x) {
        int i = 0;
        while (i < v.length) {
            ListUtils.set(v[i], x);
            ++i;
        }
        return v;
    }

    public static double[][][][] set(double[][][][] v, double x) {
        int i = 0;
        while (i < v.length) {
            ListUtils.set(v[i], x);
            ++i;
        }
        return v;
    }

    public static double[][][][][] set(double[][][][][] v, double x) {
        int i = 0;
        while (i < v.length) {
            ListUtils.set(v[i], x);
            ++i;
        }
        return v;
    }

    public static double[] add(double[] v1, double[] v2) {
        double[] sumv = new double[v1.length];
        int i = 0;
        while (i < v1.length) {
            sumv[i] = v1[i] + v2[i];
            ++i;
        }
        return sumv;
    }

    public static double[] addMut(double[] v1, double[] v2) {
        int i = 0;
        while (i < v1.length) {
            int n = i;
            v1[n] = v1[n] + v2[i];
            ++i;
        }
        return v1;
    }

    public static double[] add(double[] v1, int[] v2) {
        double[] sumv = new double[v1.length];
        int i = 0;
        while (i < v1.length) {
            sumv[i] = v1[i] + (double)v2[i];
            ++i;
        }
        return sumv;
    }

    public static double[] sub(double[] v1, double[] v2) {
        double[] sumv = new double[v1.length];
        int i = 0;
        while (i < v1.length) {
            sumv[i] = v1[i] - v2[i];
            ++i;
        }
        return sumv;
    }

    public static double[] sub(double[] v1, double x) {
        return ListUtils.add(v1, -x);
    }

    public static double[] add(double[] v1, double x) {
        double[] sumv = new double[v1.length];
        int i = 0;
        while (i < v1.length) {
            sumv[i] = v1[i] + x;
            ++i;
        }
        return sumv;
    }

    public static double[] mult(double[] v1, double[] v2) {
        double[] v = new double[v1.length];
        int i = 0;
        while (i < v1.length) {
            v[i] = v1[i] * v2[i];
            ++i;
        }
        return v;
    }

    public static double[] multMut(double[] v1, double[] v2) {
        int i = 0;
        while (i < v1.length) {
            int n = i;
            v1[n] = v1[n] * v2[i];
            ++i;
        }
        return v1;
    }

    public static double dot(double[] v1, double[] v2) {
        double sum = 0.0;
        int i = 0;
        while (i < v1.length) {
            sum += v1[i] * v2[i];
            ++i;
        }
        return sum;
    }

    public static double[] sq(double[] v) {
        double[] newv = new double[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = v[i] * v[i];
            ++i;
        }
        return newv;
    }

    public static double[] sqrt(double[] v) {
        double[] newv = new double[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = Math.sqrt(v[i]);
            ++i;
        }
        return newv;
    }

    public static double[] reverse(double[] v) {
        double[] newv = new double[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = v[v.length - i - 1];
            ++i;
        }
        return newv;
    }

    public static int[] reverse(int[] v) {
        int[] newv = new int[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = v[v.length - i - 1];
            ++i;
        }
        return newv;
    }

    public static double[] concat(double[] v1, double[] v2) {
        double[] v = new double[v1.length + v2.length];
        int i = 0;
        while (i < v1.length) {
            v[i] = v1[i];
            ++i;
        }
        i = 0;
        while (i < v2.length) {
            v[v1.length + i] = v2[i];
            ++i;
        }
        return v;
    }

    public static <T> T[] concat(T[] v1, T[] v2) {
        T[] v = ListUtils.newArray(v1.length + v2.length, v1.length > 0 ? v1[0] : v2[0]);
        int i = 0;
        while (i < v1.length) {
            v[i] = v1[i];
            ++i;
        }
        i = 0;
        while (i < v2.length) {
            v[v1.length + i] = v2[i];
            ++i;
        }
        return v;
    }

    public static String[] subArray(String[] v, int start) {
        return ListUtils.subArray(v, start, v.length);
    }

    public static String[] subArray(String[] v, int start, int end) {
        String[] subv = new String[end - start];
        int i = start;
        while (i < end) {
            subv[i - start] = v[i];
            ++i;
        }
        return subv;
    }

    public static double[] subArray(double[] v, int start) {
        return ListUtils.subArray(v, start, v.length);
    }

    public static double[] subArray(double[] v, int start, int end) {
        double[] subv = new double[end - start];
        int i = start;
        while (i < end) {
            subv[i - start] = v[i];
            ++i;
        }
        return subv;
    }

    public static int[] subArray(int[] v, int start) {
        return ListUtils.subArray(v, start, v.length);
    }

    public static int[] subArray(int[] v, int start, int end) {
        int[] subv = new int[end - start];
        int i = start;
        while (i < end) {
            subv[i - start] = v[i];
            ++i;
        }
        return subv;
    }

    public static <T> T[] subArray(T[] v, int start, int end) {
        T[] subv = ListUtils.newArray(end - start, v[0]);
        int i = start;
        while (i < end) {
            subv[i - start] = v[i];
            ++i;
        }
        return subv;
    }

    public static <T> T[] subArray(T[] v, List<Integer> indices) {
        T[] newv = ListUtils.newArray(indices.size(), v[0]);
        int i = 0;
        while (i < indices.size()) {
            newv[i] = v[indices.get(i)];
            ++i;
        }
        return newv;
    }

    public static <T> List<T> subArray(List<T> v, int[] indices) {
        ArrayList<T> newv = new ArrayList<T>();
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i != -1) {
                newv.add(v.get(i));
            }
            ++n2;
        }
        return newv;
    }

    public static <T> List<T> subList(List<T> list, int start) {
        return ListUtils.subList(list, start, list.size());
    }

    public static <T> List<T> subList(List<T> list, int start, int end) {
        if (end < 0) {
            end += list.size();
        }
        if (start < 0) {
            start += list.size();
        }
        start = NumUtils.bound(start, 0, list.size());
        end = NumUtils.bound(end, 0, list.size());
        return list.subList(start, end);
    }

    public static <T> void partialSort(List<T> list, int numTop, Comparator<? super T> c) {
        Object[] a = list.toArray();
        ListUtils.partialSort(a, numTop, c);
        ListIterator<T> i = list.listIterator();
        int j = 0;
        while (j < a.length) {
            i.next();
            i.set(a[j]);
            ++j;
        }
    }

    public static <T> void partialSort(T[] list, int numTop, Comparator<? super T> c) {
        Arrays.sort(list, c);
    }

    public static int[] sortedIndices(double[] list, boolean reverse) {
        int n = list.length;
        ArrayList<Pair<Double, Integer>> pairList = new ArrayList<Pair<Double, Integer>>(n);
        int i = 0;
        while (i < n) {
            pairList.add(new Pair<Double, Integer>(list[i], i));
            ++i;
        }
        Collections.sort(pairList, reverse ? new Pair.ReverseFirstComparator() : new Pair.FirstComparator());
        int[] indices = new int[n];
        int i2 = 0;
        while (i2 < n) {
            indices[i2] = (Integer)((Pair)pairList.get(i2)).getSecond();
            ++i2;
        }
        return indices;
    }

    public static int[] sortedIndices(int[] list, boolean reverse) {
        int n = list.length;
        ArrayList<Pair<Integer, Integer>> pairList = new ArrayList<Pair<Integer, Integer>>(n);
        int i = 0;
        while (i < n) {
            pairList.add(new Pair<Integer, Integer>(list[i], i));
            ++i;
        }
        Collections.sort(pairList, reverse ? new Pair.ReverseFirstComparator() : new Pair.FirstComparator());
        int[] indices = new int[n];
        int i2 = 0;
        while (i2 < n) {
            indices[i2] = (Integer)((Pair)pairList.get(i2)).getSecond();
            ++i2;
        }
        return indices;
    }

    public static <T> int[] toInt(T[] v) {
        if (v == null) {
            return null;
        }
        int[] newv = new int[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = (Integer)v[i];
            ++i;
        }
        return newv;
    }

    public static int[] toInt(boolean[] v) {
        int[] newv = new int[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = v[i] ? 1 : 0;
            ++i;
        }
        return newv;
    }

    public static double[] toDouble(int[] v) {
        double[] newv = new double[v.length];
        int i = 0;
        while (i < v.length) {
            newv[i] = v[i];
            ++i;
        }
        return newv;
    }

    public static boolean equals(int[] a, int[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double[] getCol(double[][] mat, int c) {
        double[] v = new double[mat.length];
        int r = 0;
        while (r < v.length) {
            v[r] = mat[r][c];
            ++r;
        }
        return v;
    }

    public static void setCol(double[][] mat, int c, double[] v) {
        int r = 0;
        while (r < v.length) {
            mat[r][c] = v[r];
            ++r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Generator<T> {
        public T generate(int var1);
    }
}

