/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Fmt;
import edu.berkeley.nlp.util.ListUtils;
import java.util.Random;

public class NumUtils {
    @Deprecated
    private static Random random = new Random();
    private static double[] logGammaCoeff = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private static double[] cachedLogFactorial = null;
    private static int numCachedLogFactorial = 1024;
    private static double logMaxValue = Math.log(Double.MAX_VALUE);

    @Deprecated
    public static Random getRandom() {
        return random;
    }

    @Deprecated
    public static void setRandom(long seed) {
        NumUtils.setRandom(new Random(seed));
    }

    @Deprecated
    public static void setRandom(Random random) {
        NumUtils.random = random;
    }

    @Deprecated
    public static double randDouble() {
        return random.nextDouble();
    }

    @Deprecated
    public static int randInt(int n) {
        return random.nextInt(n);
    }

    @Deprecated
    public static boolean randBernoulli(double p) {
        return random.nextDouble() < p;
    }

    @Deprecated
    public static int randMultinomial(double[] probs, Random random) {
        double v = random.nextDouble();
        double sum = 0.0;
        int i = 0;
        while (i < probs.length) {
            if (v < (sum += probs[i])) {
                return i;
            }
            ++i;
        }
        throw new RuntimeException(String.valueOf(sum) + " < " + v);
    }

    @Deprecated
    public static int randMultinomial(double[] probs) {
        return NumUtils.randMultinomial(probs, random);
    }

    public static boolean isFinite(double x) {
        return !Double.isNaN(x) && !Double.isInfinite(x);
    }

    public static void assertIsFinite(double x) {
        assert (NumUtils.isFinite(x)) : "Not finite: " + x;
    }

    public static void assertIsFinite(double[] xs) {
        double[] dArray = xs;
        int n = xs.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            assert (NumUtils.isFinite(x)) : "Not finite: " + Fmt.D(xs);
            ++n2;
        }
    }

    public static void assertIsFinite(double[][] xss) {
        double[][] dArray = xss;
        int n = xss.length;
        int n2 = 0;
        while (n2 < n) {
            double[] xs;
            double[] dArray2 = xs = dArray[n2];
            int n3 = xs.length;
            int n4 = 0;
            while (n4 < n3) {
                double x = dArray2[n4];
                assert (NumUtils.isFinite(x)) : "Not finite: " + Fmt.D(xss);
                ++n4;
            }
            ++n2;
        }
    }

    public static boolean isProb(double x) {
        return x >= 0.0 && x <= 1.0 && !Double.isNaN(x);
    }

    public static void assertIsProb(double x) {
        assert (NumUtils.isProb(x)) : "Not a probability [0, 1]: " + x;
    }

    public static void assertEquals(double x, double y) {
        NumUtils.assertEquals(x, y, 1.0E-10);
    }

    public static void assertEquals(double x, double y, double tol) {
        assert (Math.abs(x - y) < tol) : String.valueOf(x) + " != " + y;
    }

    public static void assertNormalized(double[] p) {
        NumUtils.assertEquals(ListUtils.sum(p), 1.0);
    }

    public static void assertNormalized(double[] p, double tol) {
        NumUtils.assertEquals(ListUtils.sum(p), 1.0, tol);
    }

    public static boolean normalize(float[] data) {
        float sum = 0.0f;
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float x = fArray[n2];
            sum += x;
            ++n2;
        }
        if (sum == 0.0f) {
            return false;
        }
        int i = 0;
        while (i < data.length) {
            int n3 = i++;
            data[n3] = data[n3] / sum;
        }
        return true;
    }

    public static boolean normalize(double[] data) {
        double sum = 0.0;
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            sum += x;
            ++n2;
        }
        if (sum == 0.0) {
            return false;
        }
        int i = 0;
        while (i < data.length) {
            int n3 = i++;
            data[n3] = data[n3] / sum;
        }
        return true;
    }

    public static boolean normalize(double[][] data) {
        double[] v;
        double sum = 0.0;
        double[][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[] dArray2 = v = dArray[n2];
            int n3 = v.length;
            int n4 = 0;
            while (n4 < n3) {
                double x = dArray2[n4];
                sum += x;
                ++n4;
            }
            ++n2;
        }
        if (sum == 0.0) {
            return false;
        }
        dArray = data;
        n = data.length;
        n2 = 0;
        while (n2 < n) {
            v = dArray[n2];
            int i = 0;
            while (i < v.length) {
                int n5 = i++;
                v[n5] = v[n5] / sum;
            }
            ++n2;
        }
        return true;
    }

    public static boolean normalizeEachRow(double[][] data) {
        boolean allRowsOkay = true;
        double[][] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            if (!NumUtils.normalize(row)) {
                allRowsOkay = false;
            }
            ++n2;
        }
        return allRowsOkay;
    }

    public static boolean normalize(double[][][] data) {
        double[] v;
        int n;
        int n2;
        double[][] dArray;
        double[][] m;
        double sum = 0.0;
        double[][][] dArray2 = data;
        int n3 = data.length;
        int n4 = 0;
        while (n4 < n3) {
            dArray = m = dArray2[n4];
            n2 = m.length;
            n = 0;
            while (n < n2) {
                double[] dArray3 = v = dArray[n];
                int n5 = v.length;
                int n6 = 0;
                while (n6 < n5) {
                    double x = dArray3[n6];
                    sum += x;
                    ++n6;
                }
                ++n;
            }
            ++n4;
        }
        if (sum == 0.0) {
            return false;
        }
        dArray2 = data;
        n3 = data.length;
        n4 = 0;
        while (n4 < n3) {
            dArray = m = dArray2[n4];
            n2 = m.length;
            n = 0;
            while (n < n2) {
                v = dArray[n];
                int i = 0;
                while (i < v.length) {
                    int n7 = i++;
                    v[n7] = v[n7] / sum;
                }
                ++n;
            }
            ++n4;
        }
        return true;
    }

    public static boolean expNormalize(double[] probs) {
        double max = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < probs.length) {
            max = Math.max(max, probs[i]);
            ++i;
        }
        i = 0;
        while (i < probs.length) {
            probs[i] = Math.exp(probs[i] - max);
            ++i;
        }
        return NumUtils.normalize(probs);
    }

    public static boolean expNormalize(double[][] probs) {
        int i;
        double[] v;
        double max = Double.NEGATIVE_INFINITY;
        double[][] dArray = probs;
        int n = probs.length;
        int n2 = 0;
        while (n2 < n) {
            v = dArray[n2];
            i = 0;
            while (i < v.length) {
                max = Math.max(max, v[i]);
                ++i;
            }
            ++n2;
        }
        dArray = probs;
        n = probs.length;
        n2 = 0;
        while (n2 < n) {
            v = dArray[n2];
            i = 0;
            while (i < v.length) {
                v[i] = Math.exp(v[i] - max);
                ++i;
            }
            ++n2;
        }
        return NumUtils.normalize(probs);
    }

    public static boolean expNormalize(double[][][] probs) {
        int i;
        double[] v;
        int n;
        int n2;
        double[][] dArray;
        double[][] m;
        double max = Double.NEGATIVE_INFINITY;
        double[][][] dArray2 = probs;
        int n3 = probs.length;
        int n4 = 0;
        while (n4 < n3) {
            dArray = m = dArray2[n4];
            n2 = m.length;
            n = 0;
            while (n < n2) {
                v = dArray[n];
                i = 0;
                while (i < v.length) {
                    max = Math.max(max, v[i]);
                    ++i;
                }
                ++n;
            }
            ++n4;
        }
        dArray2 = probs;
        n3 = probs.length;
        n4 = 0;
        while (n4 < n3) {
            dArray = m = dArray2[n4];
            n2 = m.length;
            n = 0;
            while (n < n2) {
                v = dArray[n];
                i = 0;
                while (i < v.length) {
                    v[i] = Math.exp(v[i] - max);
                    ++i;
                }
                ++n;
            }
            ++n4;
        }
        return NumUtils.normalize(probs);
    }

    public static int[][] toInt(double[][] data) {
        int[][] newdata = new int[data.length][];
        int r = 0;
        while (r < data.length) {
            newdata[r] = new int[data[r].length];
            int c = 0;
            while (c < data[r].length) {
                newdata[r][c] = (int)data[r][c];
                ++c;
            }
            ++r;
        }
        return newdata;
    }

    public static double l1Dist(double[] x, double[] y) {
        double sum = 0.0;
        int i = 0;
        while (i < x.length) {
            sum += Math.abs(x[i] - y[i]);
            ++i;
        }
        return sum;
    }

    public static double lInfDist(double[] x, double[] y) {
        double max = 0.0;
        int i = 0;
        while (i < x.length) {
            max = Math.max(max, Math.abs(x[i] - y[i]));
            ++i;
        }
        return max;
    }

    public static double l2Dist(double[] x, double[] y) {
        return Math.sqrt(NumUtils.l2DistSquared(x, y));
    }

    public static double l2DistSquared(double[] x, double[] y) {
        double sum = 0.0;
        int i = 0;
        while (i < x.length) {
            sum += (x[i] - y[i]) * (x[i] - y[i]);
            ++i;
        }
        return sum;
    }

    public static double l2Norm(double[] x) {
        return Math.sqrt(NumUtils.l2NormSquared(x));
    }

    public static double l2NormSquared(double[] x) {
        double sum = 0.0;
        int i = 0;
        while (i < x.length) {
            sum += x[i] * x[i];
            ++i;
        }
        return sum;
    }

    public static double[] l2NormalizedMut(double[] x) {
        double norm = NumUtils.l2Norm(x);
        if (norm > 0.0) {
            ListUtils.multMut(x, 1.0 / norm);
        }
        return x;
    }

    public static boolean normalizeForce(double[] data) {
        double sum = 0.0;
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            sum += x;
            ++n2;
        }
        if (sum == 0.0) {
            int i = 0;
            while (i < data.length) {
                data[i] = 1.0 / (double)data.length;
                ++i;
            }
            return false;
        }
        int i = 0;
        while (i < data.length) {
            int n3 = i++;
            data[n3] = data[n3] / sum;
        }
        return true;
    }

    public static double[][] transpose(double[][] mat) {
        int m = mat.length;
        int n = mat[0].length;
        double[][] newMat = new double[n][m];
        int r = 0;
        while (r < m) {
            int c = 0;
            while (c < n) {
                newMat[c][r] = mat[r][c];
                ++c;
            }
            ++r;
        }
        return newMat;
    }

    public static double[][] elementWiseMult(double[][] mat1, double[][] mat2) {
        int m = mat1.length;
        int n = mat1[0].length;
        double[][] newMat = new double[m][n];
        int r = 0;
        while (r < m) {
            int c = 0;
            while (c < n) {
                newMat[r][c] = mat1[r][c] * mat2[r][c];
                ++c;
            }
            ++r;
        }
        return newMat;
    }

    public static void scalarMult(double[][] mat, double x) {
        int m = mat.length;
        int n = mat[0].length;
        int r = 0;
        while (r < m) {
            int c = 0;
            while (c < n) {
                double[] dArray = mat[r];
                int n2 = c++;
                dArray[n2] = dArray[n2] * x;
            }
            ++r;
        }
    }

    public static double[][] copy(double[][] mat) {
        int m = mat.length;
        double[][] newMat = new double[m][];
        int r = 0;
        while (r < m) {
            int n = mat[r].length;
            newMat[r] = new double[n];
            int c = 0;
            while (c < n) {
                newMat[r][c] = mat[r][c];
                ++c;
            }
            ++r;
        }
        return newMat;
    }

    public static boolean equals(double x, double y) {
        return Math.abs(x - y) < 1.0E-10;
    }

    public static boolean equals(double x, double y, double tol) {
        return Math.abs(x - y) < tol;
    }

    public static double round(double x, int numPlaces) {
        double scale = Math.pow(10.0, numPlaces);
        return (double)Math.round(x * scale) / scale;
    }

    public static double[] round(double[] vec, int numPlaces) {
        double[] newVec = new double[vec.length];
        double scale = Math.pow(10.0, numPlaces);
        int i = 0;
        while (i < vec.length) {
            newVec[i] = (double)Math.round(vec[i] * scale) / scale;
            ++i;
        }
        return newVec;
    }

    public static double bound(double x, double lower, double upper) {
        if (x < lower) {
            return lower;
        }
        if (x > upper) {
            return upper;
        }
        return x;
    }

    public static int bound(int x, int lower, int upper) {
        if (x < lower) {
            return lower;
        }
        if (x > upper) {
            return upper;
        }
        return x;
    }

    public static double entropy(double[] probs) {
        double e = 0.0;
        double[] dArray = probs;
        int n = probs.length;
        int n2 = 0;
        while (n2 < n) {
            double p = dArray[n2];
            if (p > 0.0) {
                e += -p * Math.log(p);
            }
            ++n2;
        }
        return e;
    }

    public static double condEntropy(double[] probs) {
        double sum = ListUtils.sum(probs);
        double e = 0.0;
        double[] dArray = probs;
        int n = probs.length;
        int n2 = 0;
        while (n2 < n) {
            double p = dArray[n2];
            if (p > 0.0) {
                e += -p * Math.log(p / sum);
            }
            ++n2;
        }
        NumUtils.assertIsFinite(sum);
        return e;
    }

    public static double condEntropy(double[][] probs) {
        double sum = 0.0;
        int i = 0;
        while (i < probs.length) {
            sum += NumUtils.condEntropy(probs[i]);
            ++i;
        }
        return sum;
    }

    public static double logGamma(double xx) {
        double x;
        double y = x = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        int j = 0;
        while (j <= 5) {
            ser += logGammaCoeff[j] / (y += 1.0);
            ++j;
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }

    public static double logFactorial(int n) {
        if (n < numCachedLogFactorial) {
            if (cachedLogFactorial == null) {
                cachedLogFactorial = new double[numCachedLogFactorial];
                int i = 1;
                while (i < numCachedLogFactorial) {
                    NumUtils.cachedLogFactorial[i] = cachedLogFactorial[i - 1] + Math.log(i);
                    ++i;
                }
            }
            return cachedLogFactorial[n];
        }
        return NumUtils.logGamma(n + 1);
    }

    public static double logChoose(int n, int k) {
        return NumUtils.logFactorial(n) - NumUtils.logFactorial(k) - NumUtils.logFactorial(n - k);
    }

    public static double digamma(double x) {
        assert (x > 0.0) : x;
        double r = 0.0;
        while (x <= 5.0) {
            r -= 1.0 / x;
            x += 1.0;
        }
        double f = 1.0 / (x * x);
        double t = f * (-0.08333333333333333 + f * (0.008333333333333333 + f * (-0.003968253968253968 + f * (0.004166666666666667 + f * (-0.007575757575757576 + f * (0.021092796092796094 + f * (-0.08333333333333333 + f * 3617.0 / 8160.0)))))));
        return r + Math.log(x) - 0.5 / x + t;
    }

    public static double logAdd(double a, double b) {
        if (a > b) {
            if (Double.isInfinite(b) || a - b > logMaxValue) {
                return a;
            }
            return b + Math.log(1.0 + Math.exp(a - b));
        }
        if (Double.isInfinite(a) || b - a > logMaxValue) {
            return b;
        }
        return a + Math.log(1.0 + Math.exp(b - a));
    }

    public static double fastExp(double val) {
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static double fastLog(double val) {
        double x = Double.doubleToLongBits(val) >> 32;
        return (x - 1.072632447E9) / 1512775.0;
    }
}

