/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.math.SloppyMath;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final int SLURPBUFFSIZE = 16000;
    private static final String PROP = "prop";

    private StringUtils() {
    }

    public static boolean find(String str, String regex) {
        return Pattern.compile(regex).matcher(str).find();
    }

    public static boolean lookingAt(String str, String regex) {
        return Pattern.compile(regex).matcher(str).lookingAt();
    }

    public static boolean matches(String str, String regex) {
        return Pattern.compile(regex).matcher(str).matches();
    }

    public static String slurpFile(File file) throws IOException {
        FileReader r = new FileReader(file);
        return StringUtils.slurpReader(r);
    }

    public static String slurpGBFileNoExceptions(String filename) {
        return StringUtils.slurpFileNoExceptions(filename, "GB18030");
    }

    public static String slurpFile(String filename, String encoding) throws IOException {
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(filename), encoding);
        return StringUtils.slurpReader(r);
    }

    public static String slurpFileNoExceptions(String filename, String encoding) {
        try {
            return StringUtils.slurpFile(filename, encoding);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static String slurpGBFile(String filename) throws IOException {
        return StringUtils.slurpFile(filename, "GB18030");
    }

    public static String slurpReader(Reader reader) {
        BufferedReader r = new BufferedReader(reader);
        StringBuffer buff = new StringBuffer();
        try {
            int amountRead;
            char[] chars = new char[16000];
            while ((amountRead = r.read(chars, 0, 16000)) >= 0) {
                buff.append(chars, 0, amountRead);
            }
            r.close();
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return buff.toString();
    }

    public static String slurpFile(String filename) throws IOException {
        return StringUtils.slurpReader(new FileReader(filename));
    }

    public static String slurpFileNoExceptions(File file) {
        try {
            return StringUtils.slurpReader(new FileReader(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpFileNoExceptions(String filename) {
        try {
            return StringUtils.slurpFile(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpGBURL(URL u) throws IOException {
        return StringUtils.slurpURL(u, "GB18030");
    }

    public static String slurpGBURLNoExceptions(URL u) {
        try {
            return StringUtils.slurpGBURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURLNoExceptions(URL u, String encoding) {
        try {
            return StringUtils.slurpURL(u, encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(URL u, String encoding) throws IOException {
        String temp;
        InputStream is;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        uc.setReadTimeout(30000);
        try {
            is = uc.getInputStream();
        }
        catch (SocketTimeoutException e) {
            System.err.println("Time out. Return empty string");
            return "";
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is, encoding));
        StringBuffer buff = new StringBuffer(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String slurpURL(URL u) throws IOException {
        String temp;
        String lineSeparator = System.getProperty("line.separator");
        URLConnection uc = u.openConnection();
        InputStream is = uc.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        StringBuffer buff = new StringBuffer(16000);
        while ((temp = br.readLine()) != null) {
            buff.append(temp);
            buff.append(lineSeparator);
        }
        br.close();
        return buff.toString();
    }

    public static String slurpURLNoExceptions(URL u) {
        try {
            return StringUtils.slurpURL(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String slurpURL(String path) throws Exception {
        return StringUtils.slurpURL(new URL(path));
    }

    public static String slurpURLNoExceptions(String path) {
        try {
            return StringUtils.slurpURL(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String join(Iterable l, String glue) {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Object o : l) {
            if (!first) {
                sb.append(glue);
            }
            sb.append(o.toString());
            first = false;
        }
        return sb.toString();
    }

    public static String join(List<?> l, String glue) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < l.size()) {
            if (i > 0) {
                sb.append(glue);
            }
            Object x = l.get(i);
            sb.append(x.toString());
            ++i;
        }
        return sb.toString();
    }

    public static String join(Object[] elements, String glue) {
        return StringUtils.join(Arrays.asList(elements), glue);
    }

    public static String join(List l) {
        return StringUtils.join(l, " ");
    }

    public static String join(Object[] elements) {
        return StringUtils.join(elements, " ");
    }

    public static List split(String s) {
        return StringUtils.split(s, "\\s+");
    }

    public static List split(String str, String regex) {
        return Arrays.asList(str.split(regex));
    }

    public static String pad(String str, int totalChars) {
        if (str == null) {
            str = "null";
        }
        int slen = str.length();
        StringBuffer sb = new StringBuffer(str);
        int i = 0;
        while (i < totalChars - slen) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public static String pad(Object obj, int totalChars) {
        return StringUtils.pad(obj.toString(), totalChars);
    }

    public static String padOrTrim(String str, int num) {
        int leng;
        if (str == null) {
            str = "null";
        }
        if ((leng = str.length()) < num) {
            StringBuffer sb = new StringBuffer(str);
            int i = 0;
            while (i < num - leng) {
                sb.append(" ");
                ++i;
            }
            return sb.toString();
        }
        if (leng > num) {
            return str.substring(0, num);
        }
        return str;
    }

    public static String padOrTrim(Object obj, int totalChars) {
        return StringUtils.padOrTrim(obj.toString(), totalChars);
    }

    public static String padLeft(String str, int totalChars) {
        if (str == null) {
            str = "null";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < totalChars - str.length()) {
            sb.append(" ");
            ++i;
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padLeft(Object obj, int totalChars) {
        return StringUtils.padLeft(obj.toString(), totalChars);
    }

    public static String padLeft(int i, int totalChars) {
        return StringUtils.padLeft(new Integer(i), totalChars);
    }

    public static String padLeft(double d, int totalChars) {
        return StringUtils.padLeft(new Double(d), totalChars);
    }

    public static String trim(String s, int maxWidth) {
        if (s.length() <= maxWidth) {
            return s;
        }
        return s.substring(0, maxWidth);
    }

    public static String trim(Object obj, int maxWidth) {
        return StringUtils.trim(obj.toString(), maxWidth);
    }

    public static String fileNameClean(String s) {
        char[] chars = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_') {
                sb.append(c);
            } else if (c == ' ' || c == '-') {
                sb.append('_');
            } else {
                sb.append("x" + c + "x");
            }
            ++i;
        }
        return sb.toString();
    }

    public static int nthIndex(String s, char ch, int n) {
        int index = 0;
        int i = 0;
        while (i < n) {
            if (index == s.length() - 1) {
                return -1;
            }
            if ((index = s.indexOf(ch, index + 1)) == -1) {
                return -1;
            }
            ++i;
        }
        return index;
    }

    public static String truncate(int n, int smallestDigit, int biggestDigit) {
        int numDigits = biggestDigit - smallestDigit + 1;
        char[] result = new char[numDigits];
        int j = 1;
        while (j < smallestDigit) {
            n /= 10;
            ++j;
        }
        j = numDigits - 1;
        while (j >= 0) {
            result[j] = Character.forDigit(n % 10, 10);
            n /= 10;
            --j;
        }
        return new String(result);
    }

    public static Map<String, String[]> argsToMap(String[] args) {
        return StringUtils.argsToMap(args, new HashMap<String, Integer>());
    }

    public static Map<String, String[]> argsToMap(String[] args, Map<String, Integer> flagsToNumArgs) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        ArrayList<String> remainingArgs = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            String key = args[i];
            if (key.charAt(0) == '-') {
                Integer maxFlagArgs = flagsToNumArgs.get(key);
                int max = maxFlagArgs == null ? 0 : maxFlagArgs;
                ArrayList<String> flagArgs = new ArrayList<String>();
                int j = 0;
                while (j < max && i + 1 < args.length && args[i + 1].charAt(0) != '-') {
                    flagArgs.add(args[i + 1]);
                    ++i;
                    ++j;
                }
                if (result.containsKey(key)) {
                    String[] newFlagArg = new String[((String[])result.get(key)).length + flagsToNumArgs.get(key)];
                    int oldNumArgs = ((String[])result.get(key)).length;
                    System.arraycopy(result.get(key), 0, newFlagArg, 0, oldNumArgs);
                    int j2 = 0;
                    while (j2 < flagArgs.size()) {
                        newFlagArg[j2 + oldNumArgs] = (String)flagArgs.get(j2);
                        ++j2;
                    }
                } else {
                    result.put(key, flagArgs.toArray(new String[0]));
                }
            } else {
                remainingArgs.add(args[i]);
            }
            ++i;
        }
        result.put(null, remainingArgs.toArray(new String[0]));
        return result;
    }

    public static Properties argsToProperties(String[] args) {
        return StringUtils.argsToProperties(args, new HashMap());
    }

    public static Properties argsToProperties(String[] args, Map flagsToNumArgs) {
        Properties result = new Properties();
        ArrayList<String> remainingArgs = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            String key = args[i];
            if (key.charAt(0) == '-') {
                Integer maxFlagArgs = (Integer)flagsToNumArgs.get(key = key.substring(1));
                int max = maxFlagArgs == null ? 1 : maxFlagArgs;
                ArrayList<String> flagArgs = new ArrayList<String>();
                int j = 0;
                while (j < max && i + 1 < args.length && args[i + 1].charAt(0) != '-') {
                    flagArgs.add(args[i + 1]);
                    ++i;
                    ++j;
                }
                if (flagArgs.size() == 0) {
                    result.setProperty(key, "true");
                } else {
                    result.setProperty(key, StringUtils.join(flagArgs, " "));
                    if (key.equalsIgnoreCase(PROP)) {
                        try {
                            result.load(new BufferedInputStream(new FileInputStream(result.getProperty(PROP))));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                remainingArgs.add(args[i]);
            }
            ++i;
        }
        result.setProperty("", StringUtils.join(remainingArgs, " "));
        return result;
    }

    public static Properties stringToProperties(String str) {
        Properties result = new Properties();
        String[] props = str.trim().split(",\\s*");
        int i = 0;
        while (i < props.length) {
            String value;
            String key;
            String term = props[i];
            int divLoc = term.indexOf("=");
            if (divLoc >= 0) {
                key = term.substring(0, divLoc);
                value = term.substring(divLoc + 1);
            } else {
                key = term;
                value = "true";
            }
            result.setProperty(key, value);
            ++i;
        }
        return result;
    }

    public static void printToFile(File file, String message, boolean append) {
        FileWriter fw = null;
        PrintWriter pw = null;
        try {
            try {
                fw = new FileWriter(file, append);
                pw = new PrintWriter(fw);
                pw.print(message);
            }
            catch (Exception e) {
                System.out.println("Exception: in printToFile " + file.getAbsolutePath() + " " + message);
                e.printStackTrace();
                if (pw != null) {
                    pw.close();
                }
            }
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    public static void printToFile(File file, String message) {
        StringUtils.printToFile(file, message, false);
    }

    public static void printToFile(String filename, String message, boolean append) {
        StringUtils.printToFile(new File(filename), message, append);
    }

    public static void printToFile(String filename, String message) {
        StringUtils.printToFile(new File(filename), message, false);
    }

    public static Map parseCommandLineArguments(String[] args) {
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            String key = args[i];
            if (key.charAt(0) == '-') {
                if (i + 1 < args.length) {
                    String value = args[i + 1];
                    if (value.charAt(0) != '-') {
                        result.put(key, value);
                        ++i;
                    } else {
                        result.put(key, null);
                    }
                } else {
                    result.put(key, null);
                }
            }
            ++i;
        }
        return result;
    }

    public static String stripNonAlphaNumerics(String orig) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < orig.length()) {
            char c = orig.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void printStringOneCharPerLine(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            System.out.println(String.valueOf((int)c) + " '" + (char)c + "' ");
            ++i;
        }
    }

    public static String escapeString(String s, char[] charsToEscape, char escapeChar) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == escapeChar) {
                result.append(escapeChar);
            } else {
                int j = 0;
                while (j < charsToEscape.length) {
                    if (c == charsToEscape[j]) {
                        result.append(escapeChar);
                        break;
                    }
                    ++j;
                }
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static String[] splitOnCharWithQuoting(String s, char splitChar, char quoteChar, char escapeChar) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        int length = s.length();
        StringBuffer b = new StringBuffer();
        block0: while (i < length) {
            char curr = s.charAt(i);
            if (curr == splitChar) {
                if (b.length() > 0) {
                    result.add(b.toString());
                    b = new StringBuffer();
                }
                ++i;
                continue;
            }
            if (curr == quoteChar) {
                ++i;
                while (i < length) {
                    curr = s.charAt(i);
                    if (curr == escapeChar) {
                        b.append(s.charAt(i + 1));
                        i += 2;
                        continue;
                    }
                    if (curr == quoteChar) {
                        ++i;
                        continue block0;
                    }
                    b.append(s.charAt(i));
                    ++i;
                }
                continue;
            }
            b.append(curr);
            ++i;
        }
        if (b.length() > 0) {
            result.add(b.toString());
        }
        return result.toArray(new String[0]);
    }

    public static int longestCommonSubstring(String s, String t) {
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return 0;
        }
        if (m == 0) {
            return 0;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = 0;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = 0;
            ++j;
        }
        i = 1;
        while (i <= n) {
            char s_i = s.charAt(i - 1);
            j = 1;
            while (j <= m) {
                char t_j = t.charAt(j - 1);
                d[i][j] = s_i == t_j ? SloppyMath.max(d[i - 1][j], d[i][j - 1], d[i - 1][j - 1] + 1) : Math.max(d[i - 1][j], d[i][j - 1]);
                ++j;
            }
            ++i;
        }
        return d[n][m];
    }

    public static int editDistance(String s, String t) {
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= n) {
            char s_i = s.charAt(i - 1);
            j = 1;
            while (j <= m) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = SloppyMath.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
                ++j;
            }
            ++i;
        }
        return d[n][m];
    }

    public static String pennPOSToWordnetPOS(String s) {
        if (s.matches("NN|NNP|NNS|NNPS")) {
            return "noun";
        }
        if (s.matches("VB|VBD|VBG|VBN|VBZ|VBP|MD")) {
            return "verb";
        }
        if (s.matches("JJ|JJR|JJS|CD")) {
            return "adjective";
        }
        if (s.matches("RB|RBR|RBS|RP|WRB")) {
            return "adverb";
        }
        return null;
    }

    public static String capitalize(String s) {
        if (s.charAt(0) >= 'a') {
            return String.valueOf((char)(s.charAt(0) + -32)) + s.substring(1);
        }
        return s;
    }

    public static List<Matcher> allMatches(String str, String regex) {
        Matcher m;
        Pattern p = Pattern.compile(regex);
        ArrayList<Matcher> matches = new ArrayList<Matcher>();
        while ((m = p.matcher(str)).find()) {
            matches.add(m);
            str = str.substring(m.end());
        }
        return matches;
    }

    public static void main(String[] args) throws IOException {
        String[] s = new String[]{"there once was a man", "this one is a manic", "hey there", "there once was a mane", "once in a manger.", "where is one match?"};
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 6) {
                System.out.println("s1: " + s[i]);
                System.out.println("s2: " + s[j]);
                System.out.println("edit distance: " + StringUtils.editDistance(s[i], s[j]));
                System.out.println("LCS:           " + StringUtils.longestCommonSubstring(s[i], s[j]));
                System.out.println();
                ++j;
            }
            ++i;
        }
    }
}

