/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.LinkedList;
import kaist.cilab.db.DepParserFormatForDB;
import kaist.cilab.db.ParserFormatForDB;
import kaist.cilab.db.ParserFormatTerminalForDB;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.NonterminalNode;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.ParseTree;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TerminalNode;
import kaist.cilab.parser.dependency.DNode;
import kaist.cilab.parser.dependency.DTree;
import kaist.cilab.tripleextractor.util.Configuration;
import kaist.cilab.tripleextractor.util.DBMgr;

public class QueryManager {
    public void toInsertDBDep(DTree dtree, String session) {
        DNode[] nodeList = dtree.getNodeList();
        LinkedList<DepParserFormatForDB> deptTreeList = new LinkedList<DepParserFormatForDB>();
        int i = 0;
        while (i < nodeList.length) {
            String word1 = "";
            String word2 = "";
            String word1Head = "";
            String word2Head = "";
            String word1Key = "";
            String word2Key = "";
            DepParserFormatForDB dpDB = new DepParserFormatForDB();
            dpDB.setSent_id(1);
            dpDB.setSeq(i + 1);
            dpDB.setRelation(nodeList[i].getdType());
            dpDB.setPhraseTag(nodeList[i].getCorrespondingPhrase().getPhraseTag());
            LinkedList<TerminalNode> terminals = nodeList[i].getCorrespondingPhrase().getMyTerminals();
            LinkedList<Object> terminals2 = new LinkedList();
            terminals2 = nodeList[i].getdType().endsWith("ROOT") ? nodeList[i].getCorrespondingPhrase().getMyTerminals() : nodeList[nodeList[i].getHead().getWordIdx()].getCorrespondingPhrase().getMyTerminals();
            word1Head = terminals.get(0).getWord();
            word2Head = ((TerminalNode)terminals2.get(0)).getWord();
            for (TerminalNode terminalNode : terminals) {
                word1 = String.valueOf(word1) + terminalNode.getWord();
            }
            for (TerminalNode terminalNode : terminals2) {
                word2 = String.valueOf(word2) + terminalNode.getWord();
            }
            dpDB.setWord1(word1);
            dpDB.setWord2(word2);
            dpDB.setWord1Head(word1Head);
            dpDB.setWord2Head(word2Head);
            dpDB.setSession(session);
            word1Key = this.findWordfromDB(word1Head, session);
            word2Key = this.findWordfromDB(word2Head, session);
            System.out.println(word1Key);
            System.out.println(word2Key);
            if (word1Key != "" && word2Key != "") {
                dpDB.setHasWordURI(true);
                String[] stringArray = word1Key.split("\t");
                String[] tmpArr2 = word2Key.split("\t");
                dpDB.setWord1Sent_seq(Integer.parseInt(stringArray[1]));
                dpDB.setWord1word_seq(Integer.parseInt(stringArray[2]));
                dpDB.setWord2Sent_seq(Integer.parseInt(tmpArr2[1]));
                dpDB.setWord2word_seq(Integer.parseInt(tmpArr2[2]));
                deptTreeList.add(dpDB);
            } else {
                dpDB.setHasWordURI(false);
            }
            ++i;
        }
        this.doInsertDep(deptTreeList, session);
    }

    public void doInsertDep(LinkedList<DepParserFormatForDB> parserSegments, String session) {
        try {
            int cnt;
            DBMgr.openConnection(Configuration.database, Configuration.dbSchema, Configuration.dbID, Configuration.dbPasswd);
            Connection conn = DBMgr.getConnection();
            PreparedStatement ps_insert = conn.prepareStatement("INSERT INTO dependency (sent_id, dep_seq, w1_sent_seq, w1_word_seq, w2_sent_seq, w2_word_seq, relation, session_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            try {
                for (DepParserFormatForDB pDB : parserSegments) {
                    System.out.println(pDB.getRelation());
                    ps_insert.setInt(1, 1);
                    ps_insert.setInt(2, pDB.getSeq());
                    ps_insert.setInt(3, pDB.getWord1Sent_seq());
                    ps_insert.setInt(4, pDB.getWord1word_seq());
                    ps_insert.setInt(5, pDB.getWord2Sent_seq());
                    ps_insert.setInt(6, pDB.getWord2word_seq());
                    ps_insert.setString(7, pDB.getRelation());
                    ps_insert.setString(8, pDB.getSession());
                    ps_insert.addBatch();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps_insert.executeBatch();
            ps_insert = conn.prepareStatement("INSERT INTO dept_tag (sent_id, dept_seq, Tag, session_id) VALUES (?, ?, ?, ?)");
            try {
                for (DepParserFormatForDB pDB : parserSegments) {
                    cnt = 0;
                    ps_insert.setInt(1, 1);
                    ps_insert.setInt(2, pDB.getSeq());
                    ps_insert.setString(3, pDB.getRelation());
                    ps_insert.setString(4, pDB.getSession());
                    ps_insert.addBatch();
                    ++cnt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps_insert.executeBatch();
            ps_insert = conn.prepareStatement("INSERT INTO dept (sent_id, dept_seq, word1, word2, session_id) VALUES (?, ?, ?, ?, ?)");
            try {
                for (DepParserFormatForDB pDB : parserSegments) {
                    cnt = 0;
                    ps_insert.setInt(1, 1);
                    ps_insert.setInt(2, pDB.getSeq());
                    ps_insert.setString(3, pDB.getWord1());
                    ps_insert.setString(4, pDB.getWord2());
                    ps_insert.setString(5, pDB.getSession());
                    ps_insert.addBatch();
                    ++cnt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps_insert.executeBatch();
            ps_insert.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String findWordfromDB(String word, String ssesion) {
        String result = "";
        try {
            DBMgr.openConnection(Configuration.database, Configuration.dbSchema, Configuration.dbID, Configuration.dbPasswd);
            Connection conn = DBMgr.getConnection();
            PreparedStatement ps = conn.prepareStatement("select sent_id, sent_seq, word_seq from words where word_text = ? and session_id = ? limit 1");
            try {
                System.out.println(word);
                ps.setString(1, word);
                ps.setString(2, ssesion);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = String.valueOf(result) + rs.getInt(1) + "\t" + rs.getInt(2) + "\t" + rs.getInt(3);
            }
            ps.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String findWordfromDB(String word) {
        String result = "";
        try {
            DBMgr.openConnection(Configuration.database, Configuration.dbSchema, Configuration.dbID, Configuration.dbPasswd);
            Connection conn = DBMgr.getConnection();
            PreparedStatement ps = conn.prepareStatement("select sent_id, sent_seq, word_seq from words where word_text = ? and session_id = ? limit 1");
            try {
                System.out.println(word);
                ps.setString(1, word);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = String.valueOf(result) + rs.getInt(1) + "\t" + rs.getInt(2) + "\t" + rs.getInt(3);
            }
            ps.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void toInsertDBParse(ParseTree pt) {
        LinkedList<ParserFormatForDB> parserSegments = new LinkedList<ParserFormatForDB>();
        LinkedList<ParserFormatTerminalForDB> parserSegmentsTerminal = new LinkedList<ParserFormatTerminalForDB>();
        System.out.println(pt.getOrigSen());
        TerminalNode[] tmList = pt.getTerminalNodes();
        int i = 0;
        while (tmList.length > i) {
            ParserFormatTerminalForDB ptdb = new ParserFormatTerminalForDB();
            ptdb.setSent_id(1);
            ptdb.setSent_seq(0);
            ptdb.setWord_seq(i + 1);
            ptdb.setWord_text(tmList[i].getWord());
            ptdb.setTag(tmList[i].getPOS());
            parserSegmentsTerminal.add(ptdb);
            ++i;
        }
        LinkedList<NonterminalNode> ntList = pt.getNonterminalNodes();
        ParserFormatForDB rootPdb = new ParserFormatForDB();
        rootPdb.setTag("ROOT");
        rootPdb.setText(pt.getOrigSen());
        rootPdb.setSeq(0);
        parserSegments.add(rootPdb);
        int k = 1;
        for (NonterminalNode nt : ntList) {
            ParserFormatForDB pdb = new ParserFormatForDB();
            pdb.setTag(nt.getPhraseTag());
            pdb.setText(nt.getStringContents());
            pdb.setSeq(k);
            parserSegments.add(pdb);
            ++k;
        }
        this.doInsertTerminal(parserSegmentsTerminal);
        this.doInsertNonterminal(parserSegments);
    }

    public void toInsertDBParse(ParseTree pt, String session) {
        LinkedList<ParserFormatForDB> parserSegments = new LinkedList<ParserFormatForDB>();
        LinkedList<ParserFormatTerminalForDB> parserSegmentsTerminal = new LinkedList<ParserFormatTerminalForDB>();
        System.out.println(pt.getOrigSen());
        TerminalNode[] tmList = pt.getTerminalNodes();
        int i = 0;
        while (tmList.length > i) {
            ParserFormatTerminalForDB ptdb = new ParserFormatTerminalForDB();
            ptdb.setSent_id(1);
            ptdb.setSent_seq(0);
            ptdb.setWord_seq(i + 1);
            ptdb.setWord_text(tmList[i].getWord());
            ptdb.setTag(tmList[i].getPOS());
            parserSegmentsTerminal.add(ptdb);
            ptdb.setSession(session);
            ++i;
        }
        LinkedList<NonterminalNode> ntList = pt.getNonterminalNodes();
        ParserFormatForDB rootPdb = new ParserFormatForDB();
        rootPdb.setTag("ROOT");
        rootPdb.setText(pt.getOrigSen());
        rootPdb.setSeq(0);
        rootPdb.setSession(session);
        parserSegments.add(rootPdb);
        int k = 1;
        for (NonterminalNode nt : ntList) {
            ParserFormatForDB pdb = new ParserFormatForDB();
            pdb.setSession(session);
            pdb.setTag(nt.getPhraseTag());
            pdb.setText(nt.getStringContents());
            pdb.setSeq(k);
            parserSegments.add(pdb);
            ++k;
        }
        this.doInsertTerminal(parserSegmentsTerminal);
        this.doInsertNonterminal(parserSegments);
    }

    public void doInsertTerminal(LinkedList<ParserFormatTerminalForDB> parserSegmentsTerminal) {
        try {
            int cnt;
            DBMgr.openConnection(Configuration.database, Configuration.dbSchema, Configuration.dbID, Configuration.dbPasswd);
            Connection conn = DBMgr.getConnection();
            PreparedStatement ps_insert = conn.prepareStatement("INSERT INTO tags (sent_id, sent_seq, word_seq, tag, session_id) VALUES (?, ?, ?, ?, ?)");
            try {
                for (ParserFormatTerminalForDB pDB : parserSegmentsTerminal) {
                    cnt = 0;
                    ps_insert.setInt(1, 1);
                    ps_insert.setInt(2, 0);
                    ps_insert.setInt(3, pDB.getWord_seq());
                    ps_insert.setString(4, pDB.getTag());
                    ps_insert.setString(5, pDB.getSession());
                    ps_insert.addBatch();
                    ++cnt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps_insert.executeBatch();
            ps_insert = conn.prepareStatement("INSERT INTO words (sent_id, sent_seq, word_seq, word_text, session_id) VALUES (?, ?, ?, ?, ?)");
            try {
                for (ParserFormatTerminalForDB pDB : parserSegmentsTerminal) {
                    cnt = 0;
                    ps_insert.setInt(1, 1);
                    ps_insert.setInt(2, 0);
                    ps_insert.setInt(3, pDB.getWord_seq());
                    ps_insert.setString(4, pDB.getWord_text());
                    ps_insert.setString(5, pDB.getSession());
                    ps_insert.addBatch();
                    ++cnt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps_insert.executeBatch();
            ps_insert.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doInsertNonterminal(LinkedList<ParserFormatForDB> parserSegments) {
        try {
            int cnt;
            DBMgr.openConnection(Configuration.database, Configuration.dbSchema, Configuration.dbID, Configuration.dbPasswd);
            Connection conn = DBMgr.getConnection();
            PreparedStatement ps_insert = conn.prepareStatement("INSERT INTO sentence_tag (sent_id, sent_seq, Tag, session_id) VALUES (?, ?, ?, ?)");
            try {
                for (ParserFormatForDB pDB : parserSegments) {
                    cnt = 0;
                    ps_insert.setInt(1, 1);
                    ps_insert.setInt(2, pDB.getSeq());
                    ps_insert.setString(3, pDB.getTag());
                    ps_insert.setString(4, pDB.getSession());
                    ps_insert.addBatch();
                    ++cnt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps_insert.executeBatch();
            ps_insert = conn.prepareStatement("INSERT INTO sentence (sent_id, sent_seq, sentence_text, session_id) VALUES (?, ?, ?,?)");
            try {
                for (ParserFormatForDB pDB : parserSegments) {
                    cnt = 0;
                    ps_insert.setInt(1, 1);
                    ps_insert.setInt(2, pDB.getSeq());
                    ps_insert.setString(3, pDB.getText());
                    ps_insert.setString(4, pDB.getSession());
                    ps_insert.addBatch();
                    ++cnt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps_insert.executeBatch();
            ps_insert.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

