/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.jhannanum.common.workflow;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import kaist.cilab.jhannanum.common.communication.CommObject;
import kaist.cilab.jhannanum.common.communication.PlainSentence;
import kaist.cilab.jhannanum.common.communication.Sentence;
import kaist.cilab.jhannanum.common.communication.SetOfSentences;
import kaist.cilab.jhannanum.common.exception.ResultTypeException;
import kaist.cilab.jhannanum.common.thread.MorphAnalyzerThread;
import kaist.cilab.jhannanum.common.thread.MorphemeProcThread;
import kaist.cilab.jhannanum.common.thread.PlainTextProcThread;
import kaist.cilab.jhannanum.common.thread.PosProcThread;
import kaist.cilab.jhannanum.common.thread.PosTaggerThread;
import kaist.cilab.jhannanum.plugin.major.morphanalyzer.MorphAnalyzer;
import kaist.cilab.jhannanum.plugin.major.postagger.PosTagger;
import kaist.cilab.jhannanum.plugin.supplement.MorphemeProcessor.MorphemeProcessor;
import kaist.cilab.jhannanum.plugin.supplement.PlainTextProcessor.PlainTextProcessor;
import kaist.cilab.jhannanum.plugin.supplement.PosProcessor.PosProcessor;

public class Workflow {
    public static int MAX_SUPPLEMENT_PLUGIN_NUM = 8;
    private int maxSupplementPluginNum = 0;
    private boolean isThreadMode = false;
    private int outputPhaseNum = 0;
    private int outputQueueNum = 0;
    private LinkedList<Thread> threadList = null;
    private MorphAnalyzer morphAnalyzer = null;
    private String morphDataBaseDir = "";
    private String morphAnalyzerConfFile = null;
    private PosTagger posTagger = null;
    private String posDataBaseDir = "";
    private String posTaggerConfFile = null;
    private PlainTextProcessor[] plainTextProcessors = null;
    private String[] plainTextProcessorsConfFiles = null;
    private int plainTextPluginCnt = 0;
    private MorphemeProcessor[] morphemeProcessors = null;
    private String[] morphemeProcessorsConfFiles = null;
    private int morphemePluginCnt = 0;
    private PosProcessor[] posProcessors = null;
    private String[] posProcessorConfFiles = null;
    private int posPluginCnt = 0;
    private boolean isInitialized = false;
    ArrayList<LinkedBlockingQueue<PlainSentence>> queuePhase1 = null;
    ArrayList<LinkedBlockingQueue<SetOfSentences>> queuePhase2 = null;
    ArrayList<LinkedBlockingQueue<Sentence>> queuePhase3 = null;

    public Workflow() {
        this.maxSupplementPluginNum = MAX_SUPPLEMENT_PLUGIN_NUM;
        this.plainTextProcessors = new PlainTextProcessor[this.maxSupplementPluginNum];
        this.morphemeProcessors = new MorphemeProcessor[this.maxSupplementPluginNum];
        this.posProcessors = new PosProcessor[this.maxSupplementPluginNum];
        this.plainTextProcessorsConfFiles = new String[this.maxSupplementPluginNum];
        this.morphemeProcessorsConfFiles = new String[this.maxSupplementPluginNum];
        this.posProcessorConfFiles = new String[this.maxSupplementPluginNum];
        this.queuePhase1 = new ArrayList(this.maxSupplementPluginNum);
        this.queuePhase2 = new ArrayList(this.maxSupplementPluginNum + 1);
        this.queuePhase3 = new ArrayList(this.maxSupplementPluginNum + 1);
        this.threadList = new LinkedList();
        this.isInitialized = true;
    }

    public Workflow(int maxSupplementPluginNum) {
        this.maxSupplementPluginNum = maxSupplementPluginNum;
        this.plainTextProcessors = new PlainTextProcessor[maxSupplementPluginNum];
        this.morphemeProcessors = new MorphemeProcessor[maxSupplementPluginNum];
        this.posProcessors = new PosProcessor[maxSupplementPluginNum];
        this.plainTextProcessorsConfFiles = new String[maxSupplementPluginNum];
        this.morphemeProcessorsConfFiles = new String[maxSupplementPluginNum];
        this.posProcessorConfFiles = new String[maxSupplementPluginNum];
        this.queuePhase1 = new ArrayList(maxSupplementPluginNum);
        this.queuePhase2 = new ArrayList(maxSupplementPluginNum + 1);
        this.queuePhase3 = new ArrayList(maxSupplementPluginNum + 1);
        this.threadList = new LinkedList();
        this.isInitialized = true;
    }

    public void setMorphAnalyzer(MorphAnalyzer ma, String configFile) {
        this.morphAnalyzer = ma;
        this.morphAnalyzerConfFile = configFile;
    }

    public void setMorphAnalyzer(MorphAnalyzer ma, String configFile, String morphDataBaseDir) {
        this.morphAnalyzer = ma;
        this.morphAnalyzerConfFile = configFile;
        this.morphDataBaseDir = morphDataBaseDir;
    }

    public void setPosTagger(PosTagger tagger2, String configFile) {
        this.posTagger = tagger2;
        this.posTaggerConfFile = configFile;
    }

    public void setPosTagger(PosTagger tagger2, String configFile, String posDataBaseDir) {
        this.posTagger = tagger2;
        this.posTaggerConfFile = configFile;
        this.posDataBaseDir = posDataBaseDir;
    }

    public void appendPlainTextProcessor(PlainTextProcessor plugin, String configFile) {
        this.plainTextProcessorsConfFiles[this.plainTextPluginCnt] = configFile;
        this.plainTextProcessors[this.plainTextPluginCnt++] = plugin;
    }

    public void appendMorphemeProcessor(MorphemeProcessor plugin, String configFile) {
        this.morphemeProcessorsConfFiles[this.morphemePluginCnt] = configFile;
        this.morphemeProcessors[this.morphemePluginCnt++] = plugin;
    }

    public void appendPosProcessor(PosProcessor plugin, String configFile) {
        this.posProcessorConfFiles[this.posPluginCnt] = configFile;
        this.posProcessors[this.posPluginCnt++] = plugin;
    }

    public void activateWorkflow(boolean threadMode) throws Exception {
        if (threadMode) {
            this.isThreadMode = true;
            LinkedBlockingQueue<PlainSentence> in1 = null;
            LinkedBlockingQueue<PlainSentence> out1 = new LinkedBlockingQueue<PlainSentence>();
            this.queuePhase1.add(out1);
            int i = 0;
            while (i < this.plainTextPluginCnt) {
                in1 = out1;
                out1 = new LinkedBlockingQueue();
                this.queuePhase1.add(out1);
                this.plainTextProcessors[i].initialize(this.plainTextProcessorsConfFiles[i]);
                this.threadList.add(new PlainTextProcThread(this.plainTextProcessors[i], in1, out1));
                ++i;
            }
            if (this.morphAnalyzer == null) {
                this.outputPhaseNum = 1;
                this.outputQueueNum = this.plainTextPluginCnt;
                this.runThreads();
                return;
            }
            in1 = out1;
            LinkedBlockingQueue<SetOfSentences> in2 = null;
            LinkedBlockingQueue<SetOfSentences> out2 = new LinkedBlockingQueue<SetOfSentences>();
            this.queuePhase2.add(out2);
            this.morphAnalyzer.initialize(this.morphAnalyzerConfFile, this.morphDataBaseDir);
            this.threadList.add(new MorphAnalyzerThread(this.morphAnalyzer, in1, out2));
            int i2 = 0;
            while (i2 < this.morphemePluginCnt) {
                in2 = out2;
                out2 = new LinkedBlockingQueue();
                this.queuePhase2.add(out2);
                this.morphemeProcessors[i2].initialize(this.morphemeProcessorsConfFiles[i2]);
                this.threadList.add(new MorphemeProcThread(this.morphemeProcessors[i2], in2, out2));
                ++i2;
            }
            if (this.posTagger == null) {
                this.outputPhaseNum = 2;
                this.outputQueueNum = this.morphemePluginCnt;
                this.runThreads();
                return;
            }
            in2 = out2;
            LinkedBlockingQueue<Sentence> in3 = null;
            LinkedBlockingQueue<Sentence> out3 = new LinkedBlockingQueue<Sentence>();
            this.posTagger.initialize(this.posTaggerConfFile, this.posDataBaseDir);
            this.queuePhase3.add(out3);
            this.threadList.add(new PosTaggerThread(this.posTagger, in2, out3));
            int i3 = 0;
            while (i3 < this.posPluginCnt) {
                in3 = out3;
                out3 = new LinkedBlockingQueue();
                this.queuePhase3.add(out3);
                this.posProcessors[i3].initialize(this.posProcessorConfFiles[i3]);
                this.threadList.add(new PosProcThread(this.posProcessors[i3], in3, out3));
                ++i3;
            }
            this.outputPhaseNum = 3;
            this.outputQueueNum = this.posPluginCnt;
            this.runThreads();
        } else {
            this.isThreadMode = false;
            this.queuePhase1.add(new LinkedBlockingQueue());
            int i = 0;
            while (i < this.plainTextPluginCnt) {
                this.plainTextProcessors[i].initialize(this.plainTextProcessorsConfFiles[i]);
                this.queuePhase1.add(new LinkedBlockingQueue());
                ++i;
            }
            if (this.morphAnalyzer == null) {
                this.outputPhaseNum = 1;
                this.outputQueueNum = this.plainTextPluginCnt;
                return;
            }
            this.morphAnalyzer.initialize(this.morphAnalyzerConfFile, this.morphDataBaseDir);
            this.queuePhase2.add(new LinkedBlockingQueue());
            i = 0;
            while (i < this.morphemePluginCnt) {
                this.morphemeProcessors[i].initialize(this.morphemeProcessorsConfFiles[i]);
                this.queuePhase2.add(new LinkedBlockingQueue());
                ++i;
            }
            if (this.posTagger == null) {
                this.outputPhaseNum = 2;
                this.outputQueueNum = this.morphemePluginCnt;
                return;
            }
            this.posTagger.initialize(this.posTaggerConfFile, this.posDataBaseDir);
            this.queuePhase3.add(new LinkedBlockingQueue());
            i = 0;
            while (i < this.posPluginCnt) {
                this.posProcessors[i].initialize(this.posProcessorConfFiles[i]);
                this.queuePhase3.add(new LinkedBlockingQueue());
                ++i;
            }
            this.outputPhaseNum = 3;
            this.outputQueueNum = this.posPluginCnt;
        }
    }

    private void runThreads() {
        for (Thread th : this.threadList) {
            th.start();
        }
    }

    public void close() {
        if (this.isThreadMode) {
            for (Thread th : this.threadList) {
                th.interrupt();
            }
            this.threadList.clear();
        }
    }

    public void clear() {
        this.close();
        if (this.isInitialized) {
            this.queuePhase1.clear();
            this.queuePhase2.clear();
            this.queuePhase3.clear();
            this.isThreadMode = false;
            this.outputPhaseNum = 0;
            this.outputQueueNum = 0;
            this.plainTextPluginCnt = 0;
            this.morphemePluginCnt = 0;
            this.posPluginCnt = 0;
            this.morphAnalyzer = null;
            this.posTagger = null;
        }
    }

    public void analyze(String document) {
        String[] strArray = document.split("\n");
        LinkedBlockingQueue<PlainSentence> queue = this.queuePhase1.get(0);
        if (queue == null) {
            return;
        }
        int i = 0;
        while (i < strArray.length - 1) {
            queue.add(new PlainSentence(0, i, false, strArray[i].trim()));
            ++i;
        }
        queue.add(new PlainSentence(0, strArray.length - 1, true, strArray[strArray.length - 1].trim()));
        if (!this.isThreadMode) {
            this.analyzeInSingleThread();
        }
    }

    public void analyze(File document) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(document));
        LinkedBlockingQueue<PlainSentence> queue = this.queuePhase1.get(0);
        if (queue == null) {
            return;
        }
        String line = null;
        int i = 0;
        while ((line = br.readLine()) != null) {
            if (br.ready()) {
                queue.add(new PlainSentence(0, i++, false, line.trim()));
                continue;
            }
            queue.add(new PlainSentence(0, i++, true, line.trim()));
            break;
        }
        br.close();
        if (!this.isThreadMode) {
            this.analyzeInSingleThread();
        }
    }

    public <T> T getResultOfSentence(T a) throws ResultTypeException {
        block8: {
            Class<?> objClass = a.getClass();
            try {
                if (PlainSentence.class.equals(objClass)) {
                    if (this.outputPhaseNum != 1) {
                        throw new ResultTypeException(this.outputPhaseNum);
                    }
                    LinkedBlockingQueue<PlainSentence> queue = this.queuePhase1.get(this.outputQueueNum);
                    a = queue.take();
                    break block8;
                }
                if (SetOfSentences.class.equals(objClass)) {
                    if (this.outputPhaseNum != 2) {
                        throw new ResultTypeException(this.outputPhaseNum);
                    }
                    LinkedBlockingQueue<SetOfSentences> queue = this.queuePhase2.get(this.outputQueueNum);
                    a = queue.take();
                    break block8;
                }
                if (Sentence.class.equals(objClass)) {
                    if (this.outputPhaseNum != 3) {
                        throw new ResultTypeException(this.outputPhaseNum);
                    }
                    LinkedBlockingQueue<Sentence> queue = this.queuePhase3.get(this.outputQueueNum);
                    a = queue.take();
                    break block8;
                }
                throw new ResultTypeException(this.outputPhaseNum);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return a;
    }

    public String getResultOfSentence() {
        String res = null;
        try {
            switch (this.outputPhaseNum) {
                case 1: {
                    LinkedBlockingQueue<PlainSentence> out1 = this.queuePhase1.get(this.outputQueueNum);
                    res = out1.take().toString();
                    break;
                }
                case 2: {
                    LinkedBlockingQueue<SetOfSentences> out2 = this.queuePhase2.get(this.outputQueueNum);
                    res = out2.take().toString();
                    break;
                }
                case 3: {
                    LinkedBlockingQueue<Sentence> out3 = this.queuePhase3.get(this.outputQueueNum);
                    res = out3.take().toString();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return res;
    }

    public <T> LinkedList<T> getResultOfDocument(T a) throws ResultTypeException {
        Class<?> objClass = a.getClass();
        LinkedList<CommObject> list = new LinkedList<CommObject>();
        if (PlainSentence.class.equals(objClass)) {
            if (this.outputPhaseNum != 1) {
                throw new ResultTypeException(this.outputPhaseNum);
            }
            LinkedBlockingQueue<PlainSentence> queue = this.queuePhase1.get(this.outputQueueNum);
            for (PlainSentence ps : queue) {
                list.add(ps);
            }
        } else if (SetOfSentences[].class.equals(objClass)) {
            if (this.outputPhaseNum != 2) {
                throw new ResultTypeException(this.outputPhaseNum);
            }
            LinkedBlockingQueue<SetOfSentences> queue = this.queuePhase2.get(this.outputQueueNum);
            for (SetOfSentences sos : queue) {
                list.add(sos);
            }
        } else if (Sentence[].class.equals(objClass)) {
            if (this.outputPhaseNum != 3) {
                throw new ResultTypeException(this.outputPhaseNum);
            }
            LinkedBlockingQueue<Sentence> queue = this.queuePhase3.get(this.outputQueueNum);
            for (Sentence sent : queue) {
                list.add(sent);
            }
        } else {
            throw new ResultTypeException(this.outputPhaseNum);
        }
        return list;
    }

    public String getResultOfDocument() {
        StringBuffer buf = new StringBuffer();
        try {
            switch (this.outputPhaseNum) {
                case 1: {
                    PlainSentence ps;
                    LinkedBlockingQueue<PlainSentence> out1 = this.queuePhase1.get(this.outputQueueNum);
                    do {
                        ps = out1.take();
                        buf.append(ps);
                        buf.append('\n');
                    } while (!ps.isEndOfDocument());
                    break;
                }
                case 2: {
                    SetOfSentences sos;
                    LinkedBlockingQueue<SetOfSentences> out2 = this.queuePhase2.get(this.outputQueueNum);
                    do {
                        sos = out2.take();
                        buf.append(sos);
                        buf.append('\n');
                    } while (!sos.isEndOfDocument());
                    break;
                }
                case 3: {
                    Sentence sent;
                    LinkedBlockingQueue<Sentence> out3 = this.queuePhase3.get(this.outputQueueNum);
                    do {
                        sent = out3.take();
                        buf.append(sent);
                        buf.append('\n');
                    } while (!sent.isEndOfDocument());
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    private void analyzeInSingleThread() {
        if (this.plainTextPluginCnt == 0) {
            return;
        }
        LinkedBlockingQueue<PlainSentence> inQueue1 = null;
        LinkedBlockingQueue<PlainSentence> outQueue1 = null;
        PlainSentence ps = null;
        outQueue1 = this.queuePhase1.get(0);
        int i = 0;
        while (i < this.plainTextPluginCnt) {
            inQueue1 = outQueue1;
            outQueue1 = this.queuePhase1.get(i + 1);
            while ((ps = inQueue1.poll()) != null) {
                if ((ps = this.plainTextProcessors[i].doProcess(ps)) != null) {
                    outQueue1.add(ps);
                }
                while (this.plainTextProcessors[i].hasRemainingData()) {
                    ps = this.plainTextProcessors[i].doProcess(null);
                    if (ps == null) continue;
                    outQueue1.add(ps);
                }
                ps = this.plainTextProcessors[i].flush();
                if (ps == null) continue;
                outQueue1.add(ps);
            }
            ++i;
        }
        if (this.morphAnalyzer == null) {
            return;
        }
        LinkedBlockingQueue<SetOfSentences> inQueue2 = null;
        LinkedBlockingQueue<SetOfSentences> outQueue2 = null;
        SetOfSentences sos = null;
        inQueue1 = outQueue1;
        outQueue2 = this.queuePhase2.get(0);
        while ((ps = inQueue1.poll()) != null) {
            sos = this.morphAnalyzer.morphAnalyze(ps);
            if (sos == null) continue;
            outQueue2.add(sos);
        }
        if (this.morphemePluginCnt == 0) {
            return;
        }
        int i2 = 0;
        while (i2 < this.morphemePluginCnt) {
            inQueue2 = outQueue2;
            outQueue2 = this.queuePhase2.get(i2 + 1);
            while ((sos = inQueue2.poll()) != null) {
                if ((sos = this.morphemeProcessors[i2].doProcess(sos)) == null) continue;
                outQueue2.add(sos);
            }
            ++i2;
        }
        if (this.posTagger == null) {
            return;
        }
        LinkedBlockingQueue<Sentence> inQueue3 = null;
        LinkedBlockingQueue<Sentence> outQueue3 = null;
        Sentence sent = null;
        inQueue2 = outQueue2;
        outQueue3 = this.queuePhase3.get(0);
        while ((sos = inQueue2.poll()) != null) {
            sent = this.posTagger.tagPOS(sos);
            if (sent == null) continue;
            outQueue3.add(sent);
        }
        if (this.posPluginCnt == 0) {
            return;
        }
        int i3 = 0;
        while (i3 < this.posPluginCnt) {
            inQueue3 = outQueue3;
            outQueue3 = this.queuePhase3.get(i3 + 1);
            while ((sent = inQueue3.poll()) != null) {
                if ((sent = this.posProcessors[i3].doProcess(sent)) == null) continue;
                outQueue3.add(sent);
            }
            ++i3;
        }
    }
}

