/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.resource;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.datastructure.TagSet;

public class Connection {
    private String encoding = "UTF-8";
    public String title = "";
    public String version = "";
    public String copyright = "";
    public String author = "";
    public String date = "";
    public String editor = "";
    public String startTag = "";
    private boolean[][] connectionTable = null;

    public boolean checkConnection(TagSet tagSet2, int tag1, int tag2, int len1, int len2, int nextTagType) {
        String tag1Name = tagSet2.getTagName(tag1);
        String tag2Name = tagSet2.getTagName(tag2);
        if ((tag1Name.startsWith("nc") || tag1Name.charAt(0) == 'f') && tag2Name.charAt(0) == 'n') {
            if (tag2Name.startsWith("nq")) {
                return false;
            }
            if (len1 < 4 || len2 < 2) {
                return false;
            }
        }
        return this.connectionTable[tag1][tag2] && tagSet2.checkTagType(nextTagType, tag2);
    }

    public void clear() {
        this.title = "";
        this.version = "";
        this.copyright = "";
        this.author = "";
        this.date = "";
        this.editor = "";
        this.startTag = "";
        this.connectionTable = null;
    }

    public void init(String filePath, int tagCount, TagSet tagSet2) throws IOException {
        this.readFile(filePath, tagCount, tagSet2);
    }

    private void readFile(String filePath, int tagCount, TagSet tagSet2) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), this.encoding));
        String line = null;
        HashSet<Integer> tagSetA = new HashSet<Integer>();
        HashSet<Integer> tagSetB = new HashSet<Integer>();
        this.title = "";
        this.version = "";
        this.copyright = "";
        this.author = "";
        this.date = "";
        this.editor = "";
        this.startTag = "";
        this.connectionTable = new boolean[tagCount][tagCount];
        int i = 0;
        while (i < tagCount) {
            int j = 0;
            while (j < tagCount) {
                this.connectionTable[i][j] = false;
                ++j;
            }
            ++i;
        }
        while ((line = br.readLine()) != null) {
            StringTokenizer lineTokenizer = new StringTokenizer(line, "\t");
            if (!lineTokenizer.hasMoreElements()) continue;
            String lineToken = lineTokenizer.nextToken();
            if (lineToken.startsWith("@")) {
                if ("@title".equals(lineToken)) {
                    this.title = lineTokenizer.nextToken();
                    continue;
                }
                if ("@version".equals(lineToken)) {
                    this.version = lineTokenizer.nextToken();
                    continue;
                }
                if ("@copyright".equals(lineToken)) {
                    this.copyright = lineTokenizer.nextToken();
                    continue;
                }
                if ("@author".equals(lineToken)) {
                    this.author = lineTokenizer.nextToken();
                    continue;
                }
                if ("@date".equals(lineToken)) {
                    this.date = lineTokenizer.nextToken();
                    continue;
                }
                if (!"@editor".equals(lineToken)) continue;
                this.editor = lineTokenizer.nextToken();
                continue;
            }
            if ("CONNECTION".equals(lineToken)) {
                int i2;
                int[] fullTagIDSet;
                String t;
                StringTokenizer tok;
                String tagToken;
                lineToken = lineTokenizer.nextToken();
                String[] tagLists = lineToken.split("\\*", 2);
                StringTokenizer tagTokenizer = new StringTokenizer(tagLists[0], ",()");
                while (tagTokenizer.hasMoreTokens()) {
                    tagToken = tagTokenizer.nextToken();
                    tok = new StringTokenizer(tagToken, "-");
                    while (tok.hasMoreTokens()) {
                        t = tok.nextToken();
                        fullTagIDSet = tagSet2.getTags(t);
                        if (fullTagIDSet != null) {
                            i2 = 0;
                            while (i2 < fullTagIDSet.length) {
                                tagSetA.add(fullTagIDSet[i2]);
                                ++i2;
                            }
                        } else {
                            tagSetA.add(tagSet2.getTagID(t));
                        }
                        while (tok.hasMoreTokens()) {
                            tagSetA.remove(tagSet2.getTagID(tok.nextToken()));
                        }
                    }
                }
                tagTokenizer = new StringTokenizer(tagLists[1], ",()");
                while (tagTokenizer.hasMoreTokens()) {
                    tagToken = tagTokenizer.nextToken();
                    tok = new StringTokenizer(tagToken, "-");
                    while (tok.hasMoreTokens()) {
                        t = tok.nextToken();
                        fullTagIDSet = tagSet2.getTags(t);
                        if (fullTagIDSet != null) {
                            i2 = 0;
                            while (i2 < fullTagIDSet.length) {
                                tagSetB.add(fullTagIDSet[i2]);
                                ++i2;
                            }
                        } else {
                            tagSetB.add(tagSet2.getTagID(t));
                        }
                        while (tok.hasMoreTokens()) {
                            tagSetB.remove(tagSet2.getTagID(tok.nextToken()));
                        }
                    }
                }
                Iterator iterA = tagSetA.iterator();
                while (iterA.hasNext()) {
                    int leftSide = (Integer)iterA.next();
                    Iterator iterB = tagSetB.iterator();
                    while (iterB.hasNext()) {
                        this.connectionTable[leftSide][((Integer)iterB.next()).intValue()] = true;
                    }
                }
                tagSetA.clear();
                tagSetB.clear();
                continue;
            }
            if (!"START_TAG".equals(lineToken)) continue;
            this.startTag = lineTokenizer.nextToken();
        }
        br.close();
    }
}

