/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.jhannanum.plugin.major.morphanalyzer.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import kaist.cilab.jhannanum.common.Eojeol;
import kaist.cilab.jhannanum.common.JSONReader;
import kaist.cilab.jhannanum.common.communication.PlainSentence;
import kaist.cilab.jhannanum.common.communication.SetOfSentences;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.MorphemeChart;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.PostProcessor;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.Simti;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.datastructure.TagSet;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.datastructure.Trie;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.resource.AnalyzedDic;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.resource.Connection;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.resource.ConnectionNot;
import kaist.cilab.jhannanum.morphanalyzer.chartmorphanalyzer.resource.NumberAutomata;
import kaist.cilab.jhannanum.plugin.major.morphanalyzer.MorphAnalyzer;

public class ChartMorphAnalyzer
implements MorphAnalyzer {
    private static final String MODULE_NAME = "MorphAnalyzer";
    private AnalyzedDic analyzedDic = null;
    private Trie systemDic = null;
    private Trie userDic = null;
    private NumberAutomata numDic = null;
    private TagSet tagSet = null;
    private Connection connection = null;
    private ConnectionNot connectionNot = null;
    private String fileDicAnalyzed = "";
    private String fileDicSystem = "";
    private String fileDicUser = "";
    private MorphemeChart chart = null;
    private Simti simti = null;
    private String fileConnectionsNot = "";
    private String fileConnections = "";
    private String fileTagSet = "";
    private LinkedList<Eojeol> eojeolList = null;
    private PostProcessor postProc = null;

    public String getName() {
        return MODULE_NAME;
    }

    private Eojeol[] processEojeol(String plainEojeol) {
        String analysis = this.analyzedDic.get(plainEojeol);
        this.eojeolList.clear();
        if (analysis != null) {
            StringTokenizer st = new StringTokenizer(analysis, "^");
            while (st.hasMoreTokens()) {
                String analyzed = st.nextToken();
                String[] tokens = analyzed.split("\\+|/");
                String[] morphemes = new String[tokens.length / 2];
                String[] tags = new String[tokens.length / 2];
                int i = 0;
                int j = 0;
                while (i < morphemes.length) {
                    morphemes[i] = tokens[j++];
                    tags[i] = tokens[j++];
                    ++i;
                }
                Eojeol eojeol = new Eojeol(morphemes, tags);
                this.eojeolList.add(eojeol);
            }
        } else {
            this.chart.init(plainEojeol);
            this.chart.analyze();
            this.chart.getResult();
        }
        return this.eojeolList.toArray(new Eojeol[0]);
    }

    @Override
    public SetOfSentences morphAnalyze(PlainSentence ps) {
        StringTokenizer st = new StringTokenizer(ps.getSentence(), " \t");
        String plainEojeol = null;
        int eojeolNum = st.countTokens();
        ArrayList<String> plainEojeolArray = new ArrayList<String>(eojeolNum);
        ArrayList<Eojeol[]> eojeolSetArray = new ArrayList<Eojeol[]>(eojeolNum);
        while (st.hasMoreTokens()) {
            plainEojeol = st.nextToken();
            plainEojeolArray.add(plainEojeol);
            eojeolSetArray.add(this.processEojeol(plainEojeol));
        }
        SetOfSentences sos = new SetOfSentences(ps.getDocumentID(), ps.getSentenceID(), ps.isEndOfDocument(), plainEojeolArray, eojeolSetArray);
        sos = this.postProc.doPostProcessing(sos);
        return sos;
    }

    @Override
    public void initialize(String configFile) throws Exception {
        this.initialize(configFile, "");
    }

    @Override
    public void initialize(String configFile, String dataBaseDir) throws Exception {
        JSONReader json = new JSONReader(configFile);
        this.fileDicSystem = json.getValue("dic_system");
        this.fileDicUser = json.getValue("dic_user");
        this.fileConnections = json.getValue("connections");
        this.fileConnectionsNot = json.getValue("connections_not");
        this.fileDicAnalyzed = json.getValue("dic_analyzed");
        this.fileTagSet = json.getValue("tagset");
        this.tagSet = new TagSet();
        this.tagSet.init(String.valueOf(dataBaseDir) + this.fileTagSet, 0);
        this.connection = new Connection();
        this.connection.init(String.valueOf(dataBaseDir) + this.fileConnections, this.tagSet.getTagCount(), this.tagSet);
        this.connectionNot = new ConnectionNot();
        this.connectionNot.init(String.valueOf(dataBaseDir) + this.fileConnectionsNot, this.tagSet);
        this.analyzedDic = new AnalyzedDic();
        this.analyzedDic.readDic(String.valueOf(dataBaseDir) + this.fileDicAnalyzed);
        this.systemDic = new Trie(1060000);
        this.systemDic.read_dic(String.valueOf(dataBaseDir) + this.fileDicSystem, this.tagSet);
        this.userDic = new Trie(106000);
        this.userDic.read_dic(String.valueOf(dataBaseDir) + this.fileDicUser, this.tagSet);
        this.numDic = new NumberAutomata();
        this.simti = new Simti();
        this.simti.init();
        this.eojeolList = new LinkedList();
        this.chart = new MorphemeChart(this.tagSet, this.connection, this.systemDic, this.userDic, this.numDic, this.simti, this.eojeolList);
        this.postProc = new PostProcessor();
    }

    @Override
    public void shutdown() {
    }
}

