/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.jhannanum.plugin.major.postagger.impl;

import java.util.ArrayList;
import java.util.Iterator;
import kaist.cilab.jhannanum.common.Eojeol;
import kaist.cilab.jhannanum.common.JSONReader;
import kaist.cilab.jhannanum.common.communication.Sentence;
import kaist.cilab.jhannanum.common.communication.SetOfSentences;
import kaist.cilab.jhannanum.plugin.major.postagger.PosTagger;
import kaist.cilab.jhannanum.postagger.hmmpostagger.PhraseTag;
import kaist.cilab.jhannanum.postagger.hmmpostagger.ProbabilityDBM;

public class HMMTagger
implements PosTagger {
    public static int MAXLINE = 10000;
    public static int TRUE = 1;
    public static int FALSE = 0;
    public static double SF = -4.605170185988092;
    public static String EOS = "eos";
    public static String BNK = "bnk";
    public WPhead[] wp = null;
    public int wp_end = 0;
    public MNode[] mn = null;
    public int mn_end = 0;
    public ProbabilityDBM pwt_pos_tf = null;
    public ProbabilityDBM ptt_pos_tf = null;
    public ProbabilityDBM ptt_wp_tf = null;
    public String PWT_POS_TDBM_FILE;
    public String PTT_POS_TDBM_FILE;
    public String PTT_WP_TDBM_FILE;
    public boolean view = false;
    public String wtag = null;
    static final double PCONSTANT = -20.0;
    static final double LAMBDA = 0.9;
    static final double Lambda1 = 0.9;
    static final double Lambda2 = 0.09999999999999998;

    @Override
    public Sentence tagPOS(SetOfSentences sos) {
        int v = 0;
        int prev_v = 0;
        int w = 0;
        ArrayList<String> plainEojeolArray = sos.getPlainEojeolArray();
        ArrayList<Eojeol[]> eojeolSetArray = sos.getEojeolSetArray();
        this.reset();
        Iterator<String> plainEojeolIter = plainEojeolArray.iterator();
        for (Eojeol[] eojeolSet : eojeolSetArray) {
            String plainEojeol = null;
            if (!plainEojeolIter.hasNext()) break;
            plainEojeol = plainEojeolIter.next();
            w = this.new_wp(plainEojeol);
            int i = 0;
            while (i < eojeolSet.length) {
                String now_tag = PhraseTag.getPhraseTag(eojeolSet[i].getTags());
                double probability = this.compute_wt(eojeolSet[i]);
                v = this.new_mnode(eojeolSet[i], now_tag, probability);
                if (i == 0) {
                    this.wp[w].mnode = v;
                    prev_v = v;
                } else {
                    this.mn[prev_v].sibling = v;
                    prev_v = v;
                }
                ++i;
            }
        }
        return this.end_sentence(sos);
    }

    @Override
    public void initialize(String configFile) throws Exception {
        this.initialize(configFile, "");
    }

    @Override
    public void initialize(String configFile, String dataBaseDir) throws Exception {
        this.wp = new WPhead[5000];
        int i = 0;
        while (i < 5000) {
            this.wp[i] = new WPhead();
            ++i;
        }
        this.wp_end = 1;
        this.mn = new MNode[40000];
        i = 0;
        while (i < 40000) {
            this.mn[i] = new MNode();
            ++i;
        }
        this.mn_end = 1;
        JSONReader json = new JSONReader(configFile);
        this.PWT_POS_TDBM_FILE = json.getValue("pwt.pos");
        this.PTT_POS_TDBM_FILE = json.getValue("ptt.pos");
        this.PTT_WP_TDBM_FILE = json.getValue("ptt.wp");
        this.pwt_pos_tf = new ProbabilityDBM(String.valueOf(dataBaseDir) + this.PWT_POS_TDBM_FILE);
        this.ptt_wp_tf = new ProbabilityDBM(String.valueOf(dataBaseDir) + this.PTT_WP_TDBM_FILE);
        this.ptt_pos_tf = new ProbabilityDBM(String.valueOf(dataBaseDir) + this.PTT_POS_TDBM_FILE);
    }

    @Override
    public void shutdown() {
    }

    private double compute_wt(Eojeol eojeol) {
        double current = 0.0;
        String tag = eojeol.getTag(0);
        String bitag = "bnk-" + tag;
        double[] prob = null;
        prob = this.ptt_pos_tf.get(bitag);
        double tbigram = prob != null ? prob[0] : -20.0;
        prob = this.ptt_pos_tf.get(tag);
        double tunigram = prob != null ? prob[0] : -20.0;
        prob = this.pwt_pos_tf.get(String.valueOf(eojeol.getMorpheme(0)) + "/" + tag);
        double lexicon = prob != null ? prob[0] : -20.0;
        current = lexicon + tbigram - tunigram;
        String oldtag = tag;
        int i = 1;
        while (i < eojeol.length) {
            tag = eojeol.getTag(i);
            bitag = String.valueOf(oldtag) + "-" + tag;
            prob = this.ptt_pos_tf.get(bitag);
            tbigram = prob != null ? prob[0] : -20.0;
            prob = this.pwt_pos_tf.get(String.valueOf(eojeol.getMorpheme(i)) + "/" + tag);
            lexicon = prob != null ? prob[0] : -20.0;
            prob = this.ptt_pos_tf.get(tag);
            tunigram = prob != null ? prob[0] : -20.0;
            current += lexicon + tbigram - tunigram;
            oldtag = tag;
            ++i;
        }
        bitag = String.valueOf(tag) + "-bnk";
        prob = this.ptt_pos_tf.get(bitag);
        tbigram = prob != null ? prob[0] : -20.0;
        prob = this.ptt_pos_tf.get("bnk");
        tunigram = prob != null ? prob[0] : -20.0;
        return current += 0.0 + tbigram - tunigram;
    }

    private Sentence end_sentence(SetOfSentences sos) {
        int k;
        int i = this.new_wp(" ");
        this.wp[i].mnode = this.new_mnode(null, "SF", 0.0);
        i = 1;
        while (i < this.wp_end - 1) {
            int j = this.wp[i].mnode;
            while (j != 0) {
                k = this.wp[i + 1].mnode;
                while (k != 0) {
                    this.update_prob_score(j, k);
                    k = this.mn[k].sibling;
                }
                j = this.mn[j].sibling;
            }
            ++i;
        }
        i = sos.length;
        Eojeol[] eojeols = new Eojeol[i];
        k = this.wp[i].mnode;
        while (k != 0) {
            eojeols[--i] = this.mn[k].eojeol;
            k = this.mn[k].backptr;
        }
        return new Sentence(sos.getDocumentID(), sos.getSentenceID(), sos.isEndOfDocument(), sos.getPlainEojeolArray().toArray(new String[0]), eojeols);
    }

    private int new_mnode(Eojeol eojeol, String wp_tag, double prob) {
        this.mn[this.mn_end].eojeol = eojeol;
        this.mn[this.mn_end].wp_tag = wp_tag;
        this.mn[this.mn_end].prob_wt = prob;
        this.mn[this.mn_end].backptr = 0;
        this.mn[this.mn_end].sibling = 0;
        return this.mn_end++;
    }

    public int new_wp(String str) {
        this.wp[this.wp_end].mnode = 0;
        return this.wp_end++;
    }

    private void reset() {
        this.wp_end = 1;
        this.mn_end = 1;
    }

    public void update_prob_score(int from, int to) {
        double[] prob = null;
        prob = this.ptt_wp_tf.get(String.valueOf(this.mn[from].wp_tag) + "-" + this.mn[to].wp_tag);
        double PTT = prob == null ? SF : prob[0];
        prob = this.ptt_wp_tf.get(this.mn[to].wp_tag);
        if (prob != null) {
            PTT -= prob[0];
        }
        if (this.mn[from].backptr == 0) {
            this.mn[from].prob = this.mn[from].prob_wt;
        }
        double P = this.mn[from].prob + PTT + this.mn[to].prob_wt;
        if (this.mn[to].backptr == 0 || P > this.mn[to].prob) {
            this.mn[to].backptr = from;
            this.mn[to].prob = P;
        }
    }

    private class MNode {
        Eojeol eojeol;
        String wp_tag;
        double prob_wt;
        double prob;
        int backptr;
        int sibling;

        private MNode() {
        }
    }

    private class WPhead {
        int mnode;

        private WPhead() {
        }
    }
}

