/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.jhannanum.plugin.supplement.PlainTextProcessor.SentenceSegmentor;

import java.io.FileNotFoundException;
import java.io.IOException;
import kaist.cilab.jhannanum.common.communication.PlainSentence;
import kaist.cilab.jhannanum.plugin.supplement.PlainTextProcessor.PlainTextProcessor;

public class SentenceSegmentor
implements PlainTextProcessor {
    private int documentID = 0;
    private int sentenceID = 0;
    private boolean hasRemainingData = false;
    private String bufRes = null;
    private String[] bufEojeols = null;
    private int bufEojeolsIdx = 0;
    private boolean endOfDocument = false;

    private boolean isSym(char c) {
        switch (c) {
            case ')': {
                return true;
            }
            case ']': {
                return true;
            }
            case '}': {
                return true;
            }
            case '?': {
                return true;
            }
            case '!': {
                return true;
            }
            case '.': {
                return true;
            }
            case '\'': {
                return true;
            }
            case '\"': {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public PlainSentence doProcess(PlainSentence ps) {
        String[] eojeols = null;
        String res = null;
        boolean isFirstEojeol = true;
        boolean isEOS = false;
        int i = 0;
        int j = 0;
        if (this.bufEojeols != null) {
            eojeols = this.bufEojeols;
            i = this.bufEojeolsIdx;
            this.bufEojeols = null;
            this.bufEojeolsIdx = 0;
        } else {
            if (ps == null) {
                return null;
            }
            if (this.documentID != ps.getDocumentID()) {
                this.documentID = ps.getDocumentID();
                this.sentenceID = 0;
            }
            String str = null;
            str = ps.getSentence();
            if (str == null) {
                return null;
            }
            eojeols = str.split("\\s");
            this.endOfDocument = ps.isEndOfDocument();
        }
        while (!isEOS && i < eojeols.length) {
            block31: {
                block32: {
                    if (eojeols[i].matches(".*(\\.|\\!|\\?).*")) break block32;
                    if (isFirstEojeol) {
                        res = eojeols[i];
                        isFirstEojeol = false;
                        break block31;
                    } else {
                        res = String.valueOf(res) + " " + eojeols[i];
                    }
                    break block31;
                }
                char[] ca = eojeols[i].toCharArray();
                j = 0;
                while (!isEOS && j < ca.length) {
                    block33: {
                        switch (ca[j]) {
                            case '.': {
                                if (!(j == 1 || j > 0 && (Character.isLowerCase(ca[j - 1]) || Character.isUpperCase(ca[j - 1])) || j < ca.length - 1 && Character.isDigit(ca[j + 1]))) {
                                    isEOS = true;
                                    break;
                                }
                                break block33;
                            }
                            case '!': {
                                isEOS = true;
                                break;
                            }
                            case '?': {
                                isEOS = true;
                            }
                        }
                        if (isEOS) {
                            if (isFirstEojeol) {
                                res = String.valueOf(eojeols[i].substring(0, j)) + " " + ca[j];
                                isFirstEojeol = false;
                            } else {
                                res = String.valueOf(res) + " " + eojeols[i].substring(0, j) + " " + ca[j];
                            }
                            while (j < ca.length - 1) {
                                if (!this.isSym(ca[j + 1])) break;
                                res = String.valueOf(res) + ca[++j];
                            }
                        }
                    }
                    ++j;
                }
                if (!isEOS) {
                    if (isFirstEojeol) {
                        res = eojeols[i];
                        isFirstEojeol = false;
                    } else {
                        res = String.valueOf(res) + " " + eojeols[i];
                    }
                }
            }
            ++i;
        }
        --i;
        --j;
        if (isEOS) {
            boolean bl;
            if (j + 1 < eojeols[i].length()) {
                eojeols[i] = eojeols[i].substring(j + 1);
                this.bufEojeols = eojeols;
                this.bufEojeolsIdx = i;
                this.hasRemainingData = true;
            } else if (i == eojeols.length - 1) {
                this.hasRemainingData = false;
            } else {
                this.bufEojeols = eojeols;
                this.bufEojeolsIdx = i + 1;
                this.hasRemainingData = true;
            }
            if (this.bufRes == null) {
                boolean bl2;
                if (!this.hasRemainingData && this.endOfDocument) {
                    bl2 = true;
                    return new PlainSentence(this.documentID, this.sentenceID++, bl2, res);
                }
                bl2 = false;
                return new PlainSentence(this.documentID, this.sentenceID++, bl2, res);
            }
            res = String.valueOf(this.bufRes) + " " + res;
            this.bufRes = null;
            if (!this.hasRemainingData && this.endOfDocument) {
                bl = true;
                return new PlainSentence(this.documentID, this.sentenceID++, bl, res);
            }
            bl = false;
            return new PlainSentence(this.documentID, this.sentenceID++, bl, res);
        }
        if (res != null && res.length() > 0) {
            this.bufRes = res;
        }
        this.hasRemainingData = false;
        return null;
    }

    @Override
    public void initialize(String configFile) throws FileNotFoundException, IOException {
    }

    @Override
    public void initialize(String configFile, String dataBaseDir) throws Exception {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public PlainSentence flush() {
        if (this.bufRes != null) {
            String res = this.bufRes;
            this.bufRes = null;
            this.hasRemainingData = false;
            return new PlainSentence(this.documentID, this.sentenceID++, !this.hasRemainingData && this.endOfDocument, res);
        }
        return null;
    }

    @Override
    public boolean hasRemainingData() {
        return this.hasRemainingData;
    }
}

