/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.berkeleyadaptation;

import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.GrammarTester;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Numberer;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import kaist.cilab.db.ParserFormatForDB;
import kaist.cilab.parser.berkeleyadaptation.Eojeol;
import kaist.cilab.parser.berkeleyadaptation.HanNanumMorphAnalWrapper;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.ParseTree;
import kaist.cilab.tripleextractor.util.Configuration;
import kaist.cilab.tripleextractor.util.DBMgr;

public class BerkeleyParserWrapper {
    private CoarseToFineMaxRuleParser parser;

    public BerkeleyParserWrapper(String grammarName) {
        String args = "-in " + grammarName;
        OptionParser optParser = new OptionParser(GrammarTester.Options.class);
        GrammarTester.Options opts = (GrammarTester.Options)optParser.parse(args.split(" "), true);
        String inFileName = opts.inFileName;
        System.out.println("Loading grammar from " + inFileName + ".");
        int finalLevel = opts.finalLevel;
        boolean viterbiParse = opts.viterbi;
        boolean doVariational = false;
        boolean useGoldPOS = opts.useGoldPOS;
        ParserData pData2 = ParserData.Load(inFileName);
        if (pData2 == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData2.getGrammar();
        grammar.splitRules();
        Lexicon lexicon = pData2.getLexicon();
        Numberer.setNumberers(pData2.getNumbs());
        this.parser = new CoarseToFineMaxRuleParser(grammar, lexicon, opts.unaryPenalty, finalLevel, viterbiParse, false, false, opts.accurate, doVariational, useGoldPOS, true);
        this.parser.binarization = pData2.getBinarization();
    }

    public String parse(String data) {
        try {
            data = HanNanumMorphAnalWrapper.getInstance().getSpacedresult(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Tree<String> parsedTree = null;
        List<String> posTags = null;
        boolean[][][][] allowedStates = null;
        StringTokenizer tok = new StringTokenizer(data, " ");
        LinkedList<String> testSentence = new LinkedList<String>();
        while (tok.hasMoreElements()) {
            String abc = tok.nextToken();
            testSentence.add(abc);
        }
        parsedTree = this.parser.getBestConstrainedParse(testSentence, posTags, allowedStates);
        parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
        String ret = Trees.PennTreeRenderer.render(parsedTree);
        return ret;
    }

    public static void main(String[] args) {
        Configuration.hanBaseDir = "./models/ma/";
        BerkeleyParserWrapper bpw = new BerkeleyParserWrapper("KorGrammar_BerkF_FIN");
        String result = bpw.parse("\uc2e0\ub77c\uba74\uc740 1\uac1c\uc5d0 505\uce7c\ub85c\ub9ac\uc758 \uc5f4\ub7c9\uc744 \uac16\uace0 \uc788\ub2e4.");
        System.out.println(result);
    }

    public void morphemeAnalysis2(String str) {
        PrintWriter pw = null;
        Eojeol[] ret = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("MorpResult.txt"), "UTF-8"));
            String tmp = str;
            str = HanNanumMorphAnalWrapper.getInstance().getSpacedresult(str);
            ret = HanNanumMorphAnalWrapper.getInstance().getAnalysisResult(tmp);
            int i = 0;
            while (i < ret.length) {
                System.out.println(ret[i]);
                System.out.println("=================================");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Tree<String> parsedTree = null;
        List<String> posTags = null;
        boolean[][][][] allowedStates = null;
        StringTokenizer tok = new StringTokenizer(str, " ");
        LinkedList<String> testSentence = new LinkedList<String>();
        LinkedList<String> testSentence2 = new LinkedList<String>();
        while (tok.hasMoreElements()) {
            String tmp = tok.nextToken();
            testSentence.add(tmp);
        }
        int i = 0;
        while (i < ret.length) {
            pw.println(ret[i].toString2());
            ++i;
        }
        parsedTree = this.parser.getBestConstrainedParse(testSentence2, posTags, allowedStates);
        parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
        String result = Trees.PennTreeRenderer.render(parsedTree);
        pw.close();
    }

    public void morphemeAnalysis(String str) {
        PrintWriter pw = null;
        Eojeol[] ret = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("MorpResult.txt"), "UTF-8"));
            String tmp = str;
            str = HanNanumMorphAnalWrapper.getInstance().getSpacedresult(str);
            ret = HanNanumMorphAnalWrapper.getInstance().getAnalysisResult(tmp);
            int i = 0;
            while (i < ret.length) {
                System.out.println(ret[i]);
                System.out.println("=================================");
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Tree<String> parsedTree = null;
        List<String> posTags = null;
        boolean[][][][] allowedStates = null;
        StringTokenizer tok = new StringTokenizer(str, " ");
        LinkedList<String> testSentence = new LinkedList<String>();
        LinkedList<String> testSentence2 = new LinkedList<String>();
        while (tok.hasMoreElements()) {
            String tmp = tok.nextToken();
            testSentence.add(tmp);
            pw.println(tmp);
        }
        parsedTree = this.parser.getBestConstrainedParse(testSentence2, posTags, allowedStates);
        parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
        String result = Trees.PennTreeRenderer.render(parsedTree);
        pw.close();
    }

    public void morpAna2paring(List<String> tmpList) {
        List<String> tmpSent = tmpList;
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("ParseResult.txt"), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Tree<String> parsedTree = null;
        List<String> posTags = null;
        boolean[][][][] allowedStates = null;
        parsedTree = this.parser.getBestConstrainedParse(tmpSent, posTags, allowedStates);
        parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
        String result = Trees.PennTreeRenderer.render(parsedTree);
        List<Tree<String>> tr = parsedTree.getNonTerminals();
        for (Tree<String> tmp : tr) {
            System.out.println("=============" + tmp.toString());
            tmp.getPreTerminals();
        }
        System.out.println(result);
        result = result.replaceAll("\\(", "[");
        result = result.replaceAll("\\)", "]");
        pw.println("Start#");
        pw.print(result);
        pw.println("End#");
        pw.close();
    }

    public void morpAna2paringToDB(List<String> tmpList) {
        List<String> tmpSent = tmpList;
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("ParseResult.txt"), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Tree<String> parsedTree = null;
        List<String> posTags = null;
        boolean[][][][] allowedStates = null;
        parsedTree = this.parser.getBestConstrainedParse(tmpSent, posTags, allowedStates);
        parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
        String result = Trees.PennTreeRenderer.render(parsedTree);
        List<Tree<String>> tr = parsedTree.getNonTerminals();
        List<Tree<String>> trTmp = null;
        LinkedList<ParserFormatForDB> parserSegments = new LinkedList<ParserFormatForDB>();
        String resultTextset = "";
        int countTree = 0;
        for (Tree<String> tmp : tr) {
            String phraseStr = tmp.toString().substring(1);
            if (phraseStr.indexOf(40) > 0) {
                ParserFormatForDB pdb = new ParserFormatForDB();
                String[] phrases = tmp.toString().split(" ");
                pdb.setTag(phrases[0].replaceAll("\\(", ""));
                trTmp = tmp.getTerminals();
                for (Tree<String> tmp2 : trTmp) {
                    resultTextset = String.valueOf(resultTextset) + tmp2.toString() + " ";
                }
                pdb.setText(resultTextset);
                pdb.setSeq(countTree);
                parserSegments.add(pdb);
                ++countTree;
            }
            resultTextset = "";
        }
        this.doInsert(parserSegments);
        System.out.println(result);
        result = result.replaceAll("\\(", "[");
        result = result.replaceAll("\\)", "]");
        pw.println("Start#");
        pw.print(result);
        pw.println("End#");
        pw.close();
    }

    public String parseDB(String data) {
        PrintWriter pw = null;
        try {
            data = HanNanumMorphAnalWrapper.getInstance().getSpacedresult(data);
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("ParseResult.txt"), "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Tree<String> parsedTree = null;
        List<String> posTags = null;
        boolean[][][][] allowedStates = null;
        StringTokenizer tok = new StringTokenizer(data, " ");
        LinkedList<String> testSentence = new LinkedList<String>();
        while (tok.hasMoreElements()) {
            String abc = tok.nextToken();
            testSentence.add(abc);
            System.out.println(abc);
        }
        parsedTree = this.parser.getBestConstrainedParse(testSentence, posTags, allowedStates);
        parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
        String result = Trees.PennTreeRenderer.render(parsedTree);
        this.insertParseSegment(parsedTree);
        System.out.println(result);
        result = result.replaceAll("\\(", "[");
        result = result.replaceAll("\\)", "]");
        pw.println("Start#");
        pw.print(result);
        pw.println("End#");
        pw.close();
        return result;
    }

    private void insertParseSegment(Tree<String> parsedTree) {
        List<Tree<String>> tr = parsedTree.getNonTerminals();
        List<Tree<String>> trTmp = null;
        LinkedList<ParserFormatForDB> parserSegments = new LinkedList<ParserFormatForDB>();
        String resultTextset = "";
        int countTree = 0;
        for (Tree<String> tmp : tr) {
            String phraseStr = tmp.toString().substring(1);
            if (phraseStr.indexOf(40) > 0) {
                ParserFormatForDB pdb = new ParserFormatForDB();
                String[] phrases = tmp.toString().split(" ");
                pdb.setTag(phrases[0].replaceAll("\\(", ""));
                trTmp = tmp.getTerminals();
                for (Tree<String> tmp2 : trTmp) {
                    resultTextset = String.valueOf(resultTextset) + tmp2.toString() + " ";
                }
                pdb.setText(resultTextset);
                pdb.setSeq(countTree);
                parserSegments.add(pdb);
                ++countTree;
            }
            resultTextset = "";
        }
        this.doInsert(parserSegments);
    }

    public void readParseTree(String result) {
        LinkedList<ParseTree> constTrees = new LinkedList<ParseTree>();
        ParseTree tmppt = new ParseTree("test", result, 0, true);
        System.out.println("====\uc9c4\uc785\uc810");
        System.out.println(tmppt.getOrigExp());
        constTrees.add(tmppt);
    }

    public void doInsert(LinkedList<ParserFormatForDB> parserSegments) {
        try {
            int cnt;
            DBMgr.openConnection(Configuration.database, Configuration.dbSchema, Configuration.dbID, Configuration.dbPasswd);
            Connection conn = DBMgr.getConnection();
            PreparedStatement ps_insert = conn.prepareStatement("delete from sentence_Tag");
            ps_insert.executeUpdate();
            ps_insert = conn.prepareStatement("delete from sentence");
            ps_insert.executeUpdate();
            ps_insert = conn.prepareStatement("INSERT INTO sentence_Tag (sent_id, sent_seq, Tag) VALUES (?, ?, ?)");
            try {
                for (ParserFormatForDB pDB : parserSegments) {
                    cnt = 0;
                    ps_insert.setInt(1, 1);
                    ps_insert.setInt(2, pDB.getSeq());
                    ps_insert.setString(3, pDB.getTag());
                    ps_insert.addBatch();
                    ++cnt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps_insert.executeBatch();
            ps_insert = conn.prepareStatement("INSERT INTO sentence (sent_id, sent_seq, sentence_text) VALUES (?, ?, ?)");
            try {
                for (ParserFormatForDB pDB : parserSegments) {
                    cnt = 0;
                    ps_insert.setInt(1, 1);
                    ps_insert.setInt(2, pDB.getSeq());
                    ps_insert.setString(3, pDB.getText());
                    ps_insert.addBatch();
                    ++cnt;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ps_insert.executeBatch();
            ps_insert.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

