/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.berkeleyadaptation;

import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.ConstrainedArrayParser;
import edu.berkeley.nlp.PCFGLA.Corpus;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.GrammarTester;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.parser.EnglishPennTreebankParseEvaluator;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Numberer;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class Tester {
    public double[] doTest(List<Tree<String>> testTrees, String grammarName, PrintWriter goldPrint, PrintWriter sysPrint) {
        double[] ret;
        String args = "-in " + grammarName;
        OptionParser optParser = new OptionParser(GrammarTester.Options.class);
        GrammarTester.Options opts = (GrammarTester.Options)optParser.parse(args.split(" "), true);
        int maxSentenceLength = opts.maxSentenceLength;
        boolean[][][][][] cons = null;
        String inFileName = opts.inFileName;
        System.out.println("Loading grammar from " + inFileName + ".");
        int finalLevel = opts.finalLevel;
        boolean viterbiParse = opts.viterbi;
        boolean doVariational = false;
        boolean useGoldPOS = opts.useGoldPOS;
        CoarseToFineMaxRuleParser parser = null;
        EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String> eval = new EnglishPennTreebankParseEvaluator.LabeledConstituentEval<String>(new HashSet<String>(Arrays.asList("ROOT", "PSEUDO")), new HashSet<String>(Arrays.asList("''", "``", ".", ":", ",")));
        System.out.println("The computed F1,LP,LR scores are just a rough guide. They are typically 0.1-0.2 lower than the official EVALB scores.");
        ParserData pData2 = ParserData.Load(inFileName);
        if (pData2 == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData2.getGrammar();
        grammar.splitRules();
        Lexicon lexicon = pData2.getLexicon();
        Numberer.setNumberers(pData2.getNumbs());
        parser = new CoarseToFineMaxRuleParser(grammar, lexicon, opts.unaryPenalty, finalLevel, viterbiParse, false, false, opts.accurate, doVariational, useGoldPOS, true);
        parser.binarization = pData2.getBinarization();
        int i = 0;
        for (Tree<String> testTree : testTrees) {
            List<String> testSentence = testTree.getYield();
            int sentenceLength = testSentence.size();
            if (sentenceLength > maxSentenceLength) {
                System.out.println("()\n");
                continue;
            }
            List<String> posTags = null;
            if (useGoldPOS) {
                posTags = testTree.getPreTerminalYield();
            }
            boolean[][][][] allowedStates = null;
            if (cons != null) {
                if (cons[i] == null) {
                    ++i;
                    continue;
                }
                if (!opts.doNOTprojectConstraints) {
                    parser.projectConstraints(cons[i], opts.allSubstatesAllowed);
                }
                allowedStates = cons[i];
            }
            Tree<String> parsedTree = null;
            parsedTree = ((ConstrainedArrayParser)parser).getBestConstrainedParse(testSentence, posTags, allowedStates);
            parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
            if (goldPrint != null) {
                goldPrint.println(Trees.PennTreeRenderer.render(testTree));
                sysPrint.println(Trees.PennTreeRenderer.render(parsedTree));
            }
            eval.evaluate(parsedTree, testTree);
            if (++i > opts.maxSentences) break;
        }
        ret = new double[]{(double)eval.correctEvents / (double)eval.guessedEvents, (double)eval.correctEvents / (double)eval.goldEvents, 2.0 * ret[0] * ret[1] / (ret[0] + ret[1])};
        System.out.println(String.valueOf(ret[0]) + "\t" + ret[1] + "\t" + ret[2]);
        return ret;
    }

    public static void main(String[] args) {
        String path = "C:\test";
        Corpus corpus = new Corpus(path, Corpus.TreeBankType.KOREAN, 1.0, false, -1, false, false);
        List<Tree<String>> trees = corpus.getTrainTrees();
        Tester tester = new Tester();
        double[] performance = tester.doTest(trees, "KorGrammar_BerkF_FIN", null, null);
        System.out.println("P: " + performance[0] + ", R: " + performance[1] + ", F: " + performance[2]);
    }
}

