/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.ParseTree;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TerminalNode;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TreeNode;

public class NonterminalNode
extends TreeNode {
    private String phraseTag = null;
    private LinkedList<TreeNode> children = new LinkedList();
    public static HashSet<String> phraseTags = new HashSet();

    public NonterminalNode(ParseTree myTree) {
        super(myTree);
    }

    public NonterminalNode(ParseTree myTree, String phraseTag) {
        this(myTree);
        this.phraseTag = phraseTag;
    }

    public void setPhraseTag(String phraseTag) {
        this.phraseTag = phraseTag;
    }

    public String getPhraseTag() {
        return this.phraseTag;
    }

    public int readInformation(String ptExp, int idx) {
        int phraseTagIdx = this.getPhrasalIndex(ptExp, idx);
        this.phraseTag = ptExp.substring(idx, phraseTagIdx).trim();
        idx = phraseTagIdx + 1;
        phraseTags.add(this.phraseTag);
        try {
            while (ptExp.charAt(idx) != ')' || idx != ptExp.length() - 1 && ptExp.charAt(idx + 1) == '/') {
                if (ptExp.charAt(idx) == '(' && ptExp.charAt(idx + 1) != '/') {
                    NonterminalNode child = new NonterminalNode(this.myTree);
                    idx = child.readInformation(ptExp, idx + 1);
                    this.addChild(child);
                    continue;
                }
                int lastTerminalPart = idx;
                int i = idx;
                while (i < ptExp.length()) {
                    if (!(ptExp.charAt(i) != ')' && ptExp.charAt(i) != '(' || i != ptExp.length() - 1 && ptExp.charAt(i + 1) == '/')) {
                        lastTerminalPart = i;
                        break;
                    }
                    ++i;
                }
                String terminalPart = ptExp.substring(idx, lastTerminalPart);
                String[] ad = terminalPart.split("\\+");
                int i2 = 0;
                while (i2 < ad.length) {
                    if (!ad[i2].trim().equals("")) {
                        TerminalNode tn = new TerminalNode(ad[i2], this.myTree);
                        this.addChild(tn);
                    }
                    ++i2;
                }
                idx = lastTerminalPart;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(this.getTree().getOrigSen());
            System.out.println(this.getSejongForm(0));
            System.out.println(ptExp);
            System.exit(1);
        }
        return idx + 1;
    }

    public int readPennInformation(String ptExp, int idx) {
        int phraseTagIdx = this.getPennPhrasalIndex(ptExp, idx);
        this.phraseTag = ptExp.substring(idx, phraseTagIdx).trim();
        idx = phraseTagIdx;
        phraseTags.add(this.phraseTag);
        while (ptExp.charAt(idx) != ')' || idx != ptExp.length() - 1 && ptExp.charAt(idx + 1) == '/') {
            if (ptExp.charAt(idx) == '(' && ptExp.charAt(idx + 1) != '/') {
                int tmpVal = ptExp.indexOf(41, idx);
                String phraseStr = ptExp.substring(idx + 1, tmpVal);
                if (phraseStr.indexOf(40) > 0) {
                    NonterminalNode child = new NonterminalNode(this.myTree);
                    idx = child.readPennInformation(ptExp, idx + 1);
                    this.addChild(child);
                    continue;
                }
                TerminalNode tn = new TerminalNode(phraseStr, this.myTree, true);
                this.addChild(tn);
                idx = tmpVal + 1;
                continue;
            }
            if (ptExp.charAt(idx) != ' ') continue;
            ++idx;
        }
        return idx + 1;
    }

    private int getPennPhrasalIndex(String ptExp, int idx) {
        int index = ptExp.indexOf("(", idx);
        return index;
    }

    private int getPhrasalIndex(String ptExp, int idx) {
        int indexTab = ptExp.indexOf("\t", idx);
        int indexSpace = ptExp.indexOf(" ", idx);
        if (indexTab == -1) {
            return indexSpace;
        }
        if (indexSpace == -1) {
            return indexTab;
        }
        if (indexTab < indexSpace) {
            return indexTab;
        }
        if (indexSpace + 1 == indexTab) {
            return indexTab;
        }
        return indexSpace;
    }

    public LinkedList<TreeNode> getChildren() {
        return this.children;
    }

    @Override
    public void printTree(int depth) {
        int i = 0;
        while (i < depth) {
            System.out.print("\t");
            ++i;
        }
        System.out.println(this.phraseTag);
        for (TreeNode tn : this.children) {
            tn.printTree(depth + 1);
        }
    }

    @Override
    public void printInTreebankForm(String depth) {
        System.out.print(String.valueOf(depth) + " (" + this.phraseTag);
        for (TreeNode tn : this.children) {
            if (tn instanceof TerminalNode) {
                tn.printInTreebankForm(depth);
                continue;
            }
            System.out.println("");
            tn.printInTreebankForm(String.valueOf(depth) + "  ");
        }
        System.out.print(")");
    }

    @Override
    public void printInTreebankForm(PrintWriter pw, String depth) {
        pw.print(String.valueOf(depth) + " (" + this.phraseTag);
        for (TreeNode tn : this.children) {
            if (tn instanceof TerminalNode) {
                tn.printInTreebankForm(pw, depth);
                continue;
            }
            pw.println("");
            tn.printInTreebankForm(pw, String.valueOf(depth) + "  ");
        }
        pw.print(")");
    }

    @Override
    public void printInReducedTreebankForm(PrintWriter pw, String depth) {
        pw.print(String.valueOf(depth) + " (" + this.phraseTag);
        if (this.children.get(0) instanceof TerminalNode) {
            String firstPOS = null;
            String word = "";
            for (TreeNode tn : this.children) {
                TerminalNode ttn = (TerminalNode)tn;
                if (firstPOS == null) {
                    firstPOS = ttn.getPOS();
                }
                word = String.valueOf(word) + ttn.getWord();
            }
            pw.print(" (" + firstPOS + " " + word + ")");
        } else {
            for (TreeNode tn : this.children) {
                pw.println("");
                tn.printInReducedTreebankForm(pw, String.valueOf(depth) + "  ");
            }
        }
        pw.print(")");
    }

    public void getConstituentInformation(Hashtable<String, LinkedList<NonterminalNode>> emergenceInfo) {
        String constituentThis = this.getConstituent();
        LinkedList<NonterminalNode> nn = emergenceInfo.get(constituentThis);
        if (nn == null) {
            nn = new LinkedList();
            emergenceInfo.put(constituentThis, nn);
        }
        nn.add(this);
        for (TreeNode tn : this.children) {
            if (!(tn instanceof NonterminalNode)) continue;
            ((NonterminalNode)tn).getConstituentInformation(emergenceInfo);
        }
    }

    private String getConstituent() {
        String leftSide = this.refineTag(this.phraseTag);
        String rightSide = "";
        for (TreeNode tn : this.children) {
            rightSide = tn instanceof NonterminalNode ? String.valueOf(rightSide) + this.refineTag(((NonterminalNode)tn).phraseTag) + " " : String.valueOf(rightSide) + this.refineTag(((TerminalNode)tn).getPOS()) + " ";
        }
        return String.valueOf(leftSide) + " --> " + rightSide.trim();
    }

    private String refineTag(String tag) {
        char lastChar;
        if (tag.indexOf(45) > 0 && tag.charAt(0) != '-') {
            tag = tag.substring(0, tag.indexOf(45));
        }
        if ((lastChar = tag.charAt(tag.length() - 1)) >= '0' && lastChar <= '9') {
            tag = tag.substring(0, tag.length() - 2);
        }
        return tag;
    }

    public String[] getChildrenContents() {
        String[] ret = new String[this.children.size()];
        int cnt = 0;
        for (TreeNode tn : this.children) {
            ret[cnt++] = tn.getStringContents();
        }
        return ret;
    }

    @Override
    public String getStringContents() {
        String ret = "";
        for (TreeNode tn : this.children) {
            ret = String.valueOf(ret) + tn.getStringContents();
        }
        return String.valueOf(ret) + " ";
    }

    @Override
    public String getSejongForm(int depth) {
        String ret = "";
        ret = String.valueOf(ret) + "(" + this.phraseTag;
        Iterator tnIter = this.children.iterator();
        boolean isFirst = true;
        boolean prevTerminal = false;
        while (tnIter.hasNext()) {
            TreeNode tn = (TreeNode)tnIter.next();
            if (tn instanceof TerminalNode) {
                if (prevTerminal) {
                    ret = String.valueOf(ret) + " +";
                }
                ret = String.valueOf(ret) + tn.getSejongForm(depth + 1);
                prevTerminal = true;
                continue;
            }
            prevTerminal = false;
            if (isFirst) {
                ret = String.valueOf(ret) + "\t" + tn.getSejongForm(depth + 1);
            } else {
                ret = String.valueOf(ret) + "\n";
                int i = 0;
                while (i < depth + 1) {
                    ret = String.valueOf(ret) + "\t";
                    ++i;
                }
                ret = String.valueOf(ret) + tn.getSejongForm(depth + 1);
            }
            isFirst = false;
        }
        ret = String.valueOf(ret) + ")";
        return ret;
    }

    public void addToNonterminalList(LinkedList<NonterminalNode> ans) {
        ans.add(this);
        for (TreeNode nn : this.children) {
            if (!(nn instanceof NonterminalNode)) continue;
            ((NonterminalNode)nn).addToNonterminalList(ans);
        }
    }

    public void addToTerminalList(LinkedList<TerminalNode> ans) {
        for (TreeNode nn : this.children) {
            if (nn instanceof NonterminalNode) {
                ((NonterminalNode)nn).addToTerminalList(ans);
                continue;
            }
            ans.add((TerminalNode)nn);
        }
    }

    public void assignStartPos() {
        for (TreeNode nn : this.children) {
            if (!(nn instanceof NonterminalNode)) continue;
            ((NonterminalNode)nn).assignStartPos();
        }
        this.startPos = this.children.get((int)0).startPos;
    }

    public void addToPrePreTerminalList(LinkedList<NonterminalNode> ans) {
        boolean amI = false;
        for (TreeNode nn : this.children) {
            if (nn instanceof TerminalNode) {
                amI = true;
                continue;
            }
            ((NonterminalNode)nn).addToPrePreTerminalList(ans);
        }
        if (amI) {
            ans.add(this);
        }
    }

    public void addChild(TreeNode tn) {
        tn.setParent(this);
        this.children.add(tn);
    }

    public void replaceChildrenWith(LinkedList<TreeNode> newChildren) {
        this.children = new LinkedList();
        for (TreeNode tn : newChildren) {
            this.addChild(tn);
        }
    }

    @Override
    public LinkedList<TerminalNode> getMyTerminals() {
        LinkedList<TerminalNode> ret = new LinkedList<TerminalNode>();
        for (TreeNode tn : this.children) {
            LinkedList<TerminalNode> tmp = tn.getMyTerminals();
            for (TerminalNode tmn : tmp) {
                ret.add(tmn);
            }
        }
        return ret;
    }

    public void removeChild(TreeNode tn) {
        this.children.remove(tn);
    }
}

