/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.LinkedList;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.NonterminalNode;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TerminalNode;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TreeNode;

public class ParseTree {
    private NonterminalNode head;
    private String origFileName;
    private String origSen;
    private int senID;
    private String origExp;
    private LinkedList<NonterminalNode> ntNodes;
    private TerminalNode[] tNodes = null;

    public ParseTree(String origSen, String ptExp, int senID) {
        this.origSen = origSen;
        this.senID = senID;
        this.head = new NonterminalNode(this);
        this.origExp = ptExp;
        int lastIdx = this.head.readInformation(ptExp, 1);
        if (lastIdx != ptExp.length()) {
            System.err.println("Parenthesis does not match: " + ptExp + "\t" + ptExp.length() + "\t" + lastIdx);
        }
        this.ntNodes = null;
        this.tNodes = null;
    }

    public ParseTree(String fileName, String ptExp, int senID, boolean isTreebank) {
        this.origSen = fileName;
        this.senID = senID;
        this.head = new NonterminalNode(this);
        this.origExp = ptExp;
        int lastIdx = this.head.readPennInformation(ptExp, 1);
        if (lastIdx != ptExp.length()) {
            System.err.println(this.origSen);
            System.err.println("Parenthesis does not match: " + ptExp + "\t" + ptExp.length() + "\t" + lastIdx);
            System.err.flush();
            this.printInTreebankForm();
            System.exit(1);
        }
        this.head = (NonterminalNode)this.head.getChildren().get(0);
        this.ntNodes = null;
        this.tNodes = null;
    }

    public int getSenID() {
        return this.senID;
    }

    public String getOrigSen() {
        return this.origSen;
    }

    public String getOrigExp() {
        return this.origExp;
    }

    public TreeNode getHead() {
        return this.head;
    }

    public void printTree() {
        System.out.println("Original Expression: " + this.origExp);
        System.out.println("PARSE TREE: ");
        this.head.printTree(0);
    }

    public void printInTreebankForm() {
        System.out.print("(");
        this.head.printInTreebankForm("");
        System.out.println(")");
    }

    public void printInTreebankForm(PrintWriter pw) {
        pw.print("(");
        this.head.printInTreebankForm(pw, "");
        pw.println(")");
    }

    public void printInReducedTreebankForm(PrintWriter pw) {
        pw.print("(");
        this.head.printInReducedTreebankForm(pw, "");
        pw.println(")");
    }

    public void getConstituentInformation(Hashtable<String, LinkedList<NonterminalNode>> emergenceInfo) {
        this.head.getConstituentInformation(emergenceInfo);
    }

    public String getSejongForm() {
        return this.head.getSejongForm(0);
    }

    public String getOrigFileName() {
        return this.origFileName;
    }

    public void setOrigFileName(String origFileName) {
        this.origFileName = origFileName;
    }

    public LinkedList<NonterminalNode> getNonterminalNodes() {
        this.ntNodes = new LinkedList();
        this.head.addToNonterminalList(this.ntNodes);
        return this.ntNodes;
    }

    public TerminalNode[] getTerminalNodes() {
        if (this.tNodes == null) {
            LinkedList<TerminalNode> tnList = new LinkedList<TerminalNode>();
            this.head.addToTerminalList(tnList);
            this.tNodes = new TerminalNode[tnList.size()];
            int cnt = 0;
            for (TerminalNode tn : tnList) {
                this.tNodes[cnt++] = tn;
            }
        }
        return this.tNodes;
    }

    public LinkedList<NonterminalNode> getPrePreTerminalNodes() {
        LinkedList<NonterminalNode> pptList = new LinkedList<NonterminalNode>();
        this.head.addToPrePreTerminalList(pptList);
        return pptList;
    }

    public int printInDeccaForm(int sentenceID, int baseTokenNum, PrintWriter corpusFile, PrintWriter constituentFile) {
        TerminalNode[] tnArr = this.getTerminalNodes();
        int i = 0;
        while (i < tnArr.length) {
            tnArr[i].startPos = i + 1;
            corpusFile.println("s" + sentenceID + "_" + (i + 1) + "\t" + tnArr[i].getWord() + "\t" + tnArr[i].getPOS());
            ++i;
        }
        this.head.assignStartPos();
        LinkedList<NonterminalNode> nnList = this.getNonterminalNodes();
        for (NonterminalNode nn : nnList) {
            String pTag = nn.getPhraseTag();
            if (pTag.indexOf(45) > 0) {
                pTag = pTag.substring(0, pTag.indexOf(45));
            }
            constituentFile.print(String.valueOf(baseTokenNum + nn.startPos) + "\t" + pTag + "\t");
            LinkedList<TerminalNode> terminals = nn.getMyTerminals();
            for (TerminalNode tn : terminals) {
                constituentFile.print(tn.getWord());
                if (tn == terminals.peekLast()) continue;
                constituentFile.print("\t");
            }
            constituentFile.println("");
        }
        return baseTokenNum + tnArr.length;
    }
}

