/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree;

import java.io.PrintWriter;
import java.util.LinkedList;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.ParseTree;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TreeNode;

public class TerminalNode
extends TreeNode {
    private String POS;
    private String word;

    public TerminalNode(String POS, String word, ParseTree myTree) {
        super(myTree);
        this.POS = POS;
        this.word = word;
    }

    public TerminalNode(String exp, ParseTree myTree) {
        super(myTree);
        try {
            if (exp.indexOf(47) < 0) {
                exp = String.valueOf(exp) + "/PSU";
            }
            this.word = exp.substring(0, exp.lastIndexOf(47)).trim();
            this.POS = exp.substring(exp.lastIndexOf(47) + 1).trim();
            this.word = this.word.replaceAll("/", "\\\\/");
            this.word = this.word.replaceAll("\\(\\/SS", "-LRB-");
            this.word = this.word.replaceAll("\\)\\/SS", "-RRB-");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(exp);
            System.out.println(myTree.getOrigFileName());
            System.out.println(myTree.getOrigSen());
            System.out.println(myTree.getOrigExp());
            System.exit(1);
        }
    }

    public TerminalNode(String exp, ParseTree myTree, boolean isPennForm) {
        super(myTree);
        exp = exp.trim();
        this.POS = exp.substring(0, exp.indexOf(32)).trim();
        this.word = exp.substring(exp.indexOf(32) + 1).trim();
    }

    public void setPOS(String newPOS) {
        this.POS = newPOS;
    }

    @Override
    public void printTree(int depth) {
        int i = 0;
        while (i < depth) {
            System.out.print("\t");
            ++i;
        }
        System.out.println(String.valueOf(this.word) + "/" + this.POS);
    }

    @Override
    public void printInTreebankForm(String depth) {
        System.out.print(" (" + this.POS + " " + this.word + ")");
    }

    @Override
    public String getSejongForm(int depth) {
        return " " + this.word + "/" + this.POS;
    }

    @Override
    public void printInTreebankForm(PrintWriter pw, String depth) {
        pw.print(" (" + this.POS + " " + this.word + ")");
    }

    @Override
    public void printInReducedTreebankForm(PrintWriter pw, String depth) {
    }

    public String getWord() {
        return this.word;
    }

    public String getPOS() {
        return this.POS;
    }

    @Override
    public String getStringContents() {
        return this.getWord();
    }

    @Override
    public LinkedList<TerminalNode> getMyTerminals() {
        LinkedList<TerminalNode> ret = new LinkedList<TerminalNode>();
        ret.add(this);
        return ret;
    }
}

