/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.dependency;

import java.util.Hashtable;
import java.util.LinkedList;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.NonterminalNode;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.ParseTree;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TerminalNode;
import kaist.cilab.parser.dependency.DNode;

public class DTree {
    private int sent_id;
    private Hashtable<NonterminalNode, DNode> dNodeMap = new Hashtable();
    private DNode[] nodeList;

    public DTree(int numNode, ParseTree pt) {
        this.nodeList = new DNode[numNode];
        if (numNode == 1) {
            this.nodeList[0] = new DNode((NonterminalNode)pt.getHead(), 0);
        }
    }

    public DTree(int numNode, ParseTree pt, int sent_id) {
        this.nodeList = new DNode[numNode];
        this.sent_id = sent_id;
        if (numNode == 1) {
            this.nodeList[0] = new DNode((NonterminalNode)pt.getHead(), 0);
        }
    }

    public void addDependency(NonterminalNode from, NonterminalNode to, int fromIdx, int toIdx) {
        DNode fromNode = this.getNode(from, fromIdx);
        DNode toNode = this.getNode(to, toIdx);
        fromNode.setHead(toNode);
    }

    private DNode getNode(NonterminalNode node, int nodeIdx) {
        DNode ret = this.dNodeMap.get(node);
        if (ret == null) {
            this.nodeList[nodeIdx] = ret = new DNode(node, nodeIdx);
            this.dNodeMap.put(node, ret);
        }
        return ret;
    }

    public void generateLinkTypes() {
        int i = 0;
        while (i < this.nodeList.length) {
            if (this.nodeList[i].getHead() == null) {
                this.nodeList[i].setdType("ROOT");
            } else {
                String ptag = this.nodeList[i].getCorrespondingPhrase().getPhraseTag();
                if (ptag.contains("-")) {
                    this.nodeList[i].setdType(ptag.substring(ptag.indexOf(45) + 1));
                    this.nodeList[i].getCorrespondingPhrase().setPhraseTag(ptag.substring(0, ptag.indexOf(45)));
                } else if (ptag.equals("AP")) {
                    this.nodeList[i].setdType("ADV");
                } else {
                    String parentTag = this.nodeList[i].getHead().getCorrespondingPhrase().getPhraseTag();
                    if (parentTag.startsWith("AP")) {
                        this.nodeList[i].setdType("AMOD");
                    } else if (parentTag.startsWith("DP")) {
                        this.nodeList[i].setdType("DMOD");
                    } else if (parentTag.startsWith("NP")) {
                        this.nodeList[i].setdType("NMOD");
                    } else if (parentTag.startsWith("VP") || parentTag.startsWith("VNP") || parentTag.startsWith("IP")) {
                        this.nodeList[i].setdType("VMOD");
                    } else {
                        this.nodeList[i].setdType("DEP");
                    }
                }
            }
            ++i;
        }
    }

    public void processCNJ() {
        int i = 0;
        while (i < this.nodeList.length) {
            if (this.nodeList[i].getdType().equals("CNJ")) {
                int searchTo = this.nodeList[i].getHead().getWordIdx();
                int j = i + 1;
                while (j < searchTo) {
                    if (this.nodeList[j].getdType().equals("CNJ")) {
                        this.nodeList[i].setHead(this.nodeList[j]);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public String toString() {
        String ret = "";
        int i = 0;
        while (i < this.nodeList.length) {
            String line = "";
            line = String.valueOf(line) + (i + 1) + "\t";
            LinkedList<TerminalNode> terminals = this.nodeList[i].getCorrespondingPhrase().getMyTerminals();
            for (TerminalNode tn : terminals) {
                line = String.valueOf(line) + tn.getWord() + "/" + tn.getPOS();
                if (tn == terminals.peekLast()) continue;
                line = String.valueOf(line) + "+";
            }
            line = String.valueOf(line) + "\t";
            line = this.nodeList[i].getHead() == null ? String.valueOf(line) + "0\t" : String.valueOf(line) + (this.nodeList[i].getHead().getWordIdx() + 1) + "\t";
            line = String.valueOf(line) + this.nodeList[i].getCorrespondingPhrase().getPhraseTag() + "\t";
            line = String.valueOf(line) + this.nodeList[i].getdType();
            ret = String.valueOf(ret) + line + "\n";
            ++i;
        }
        return ret;
    }

    public Hashtable<NonterminalNode, DNode> getdNodeMap() {
        return this.dNodeMap;
    }

    public void setdNodeMap(Hashtable<NonterminalNode, DNode> dNodeMap) {
        this.dNodeMap = dNodeMap;
    }

    public DNode[] getNodeList() {
        return this.nodeList;
    }

    public void setNodeList(DNode[] nodeList) {
        this.nodeList = nodeList;
    }

    public int getSent_id() {
        return this.sent_id;
    }

    public void setSent_id(int sent_id) {
        this.sent_id = sent_id;
    }
}

