/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.parser.psg2dg;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.LinkedList;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.NonterminalNode;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.ParseTree;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TerminalNode;
import kaist.cilab.parser.corpusconverter.sejong2treebank.sejongtree.TreeNode;
import kaist.cilab.parser.dependency.DTree;
import kaist.cilab.parser.util.KoreanHeadFinder;

public class Converter {
    public void convert(String nifStr) throws Exception {
        LinkedList<ParseTree> constTrees = new LinkedList<ParseTree>();
        ParseTree tmppt = new ParseTree("test", nifStr, 0, true);
        constTrees.add(tmppt);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("Converted.txt"), "UTF-8"));
        LinkedList<DTree> result = new LinkedList<DTree>();
        for (ParseTree pt : constTrees) {
            DTree newTree = this.convert(pt);
            System.out.println(newTree.toString());
            pw.print(newTree.toString());
            result.add(newTree);
        }
        pw.close();
    }

    public ParseTree convertParseTree(String nifStr) throws Exception {
        ParseTree tmppt = new ParseTree("test", nifStr, 0, true);
        return tmppt;
    }

    private boolean isMixed(NonterminalNode nn) {
        boolean haveTerminal = false;
        boolean haveNon = false;
        LinkedList<TreeNode> children = nn.getChildren();
        for (TreeNode tn : children) {
            if (tn instanceof TerminalNode) {
                haveTerminal = true;
            }
            if (!(tn instanceof NonterminalNode)) continue;
            haveNon = true;
        }
        return haveTerminal && haveNon;
    }

    public DTree convert(ParseTree pt) {
        LinkedList<NonterminalNode> nnList = pt.getNonterminalNodes();
        for (NonterminalNode nn : nnList) {
            if (!this.isMixed(nn)) continue;
            LinkedList<TreeNode> newChild = new LinkedList<TreeNode>();
            for (TreeNode tn : nn.getChildren()) {
                if (tn instanceof TerminalNode) {
                    if (!((TerminalNode)tn).getPOS().equals("NP")) continue;
                    NonterminalNode newNode = new NonterminalNode(pt);
                    newNode.setPhraseTag("NP");
                    newNode.addChild(tn);
                    newChild.add(newNode);
                    continue;
                }
                newChild.add(tn);
            }
            nn.replaceChildrenWith(newChild);
        }
        LinkedList<NonterminalNode> linkTarget = pt.getPrePreTerminalNodes();
        Hashtable<NonterminalNode, Integer> indexTbl = new Hashtable<NonterminalNode, Integer>();
        int cnt = 0;
        for (NonterminalNode nn : linkTarget) {
            indexTbl.put(nn, cnt);
            ++cnt;
        }
        DTree newTree = new DTree(linkTarget.size(), pt, pt.getSenID());
        this.detectLinkIter((NonterminalNode)pt.getHead(), newTree, indexTbl);
        newTree.generateLinkTypes();
        newTree.processCNJ();
        return newTree;
    }

    private void detectLinkIter(NonterminalNode parent, DTree newTree, Hashtable<NonterminalNode, Integer> indexTbl) {
        if (parent.getChildren().get(0) instanceof TerminalNode) {
            return;
        }
        TreeNode headNode = null;
        if (parent.getPhraseTag().contains("-")) {
            for (TreeNode child : parent.getChildren()) {
                if (!((NonterminalNode)child).getPhraseTag().equals(parent.getPhraseTag())) continue;
                headNode = child;
            }
        }
        if (headNode == null) {
            headNode = KoreanHeadFinder.getInstance().determineHead(parent);
        }
        NonterminalNode actualHead = (NonterminalNode)KoreanHeadFinder.getInstance().determinePrepreterminalHead(headNode);
        LinkedList<TreeNode> children = parent.getChildren();
        for (TreeNode tn : children) {
            if (tn == headNode) continue;
            NonterminalNode actualFrom = (NonterminalNode)KoreanHeadFinder.getInstance().determinePrepreterminalHead(tn);
            newTree.addDependency(actualFrom, actualHead, indexTbl.get(actualFrom), indexTbl.get(actualHead));
        }
        for (TreeNode tn : children) {
            this.detectLinkIter((NonterminalNode)tn, newTree, indexTbl);
        }
    }

    public static void main(String[] args) {
        try {
            String result = "";
            if (args != null) {
                int i = 0;
                while (i < args.length) {
                    result = String.valueOf(result) + args[i] + " ";
                    ++i;
                }
            }
            result = result.trim();
            result = result.replaceAll("\\[", "(");
            result = result.replaceAll("\\]", ")");
            result = Converter.functionTagReForm(result);
            System.out.println(result);
            Converter cv = new Converter();
            cv.convert(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String functionTagReForm(String str) {
        str = str.replaceAll("AJT", "-AJT");
        str = str.replaceAll("CMP", "-CMP");
        str = str.replaceAll("CNJ", "-CNJ");
        str = str.replaceAll("INT", "-INT");
        str = str.replaceAll("OBJ", "-OBJ");
        str = str.replaceAll("PRN", "-PRN");
        str = str.replaceAll("SBJ", "-SBJ");
        str = str.replaceAll("MOD", "-MOD");
        return str;
    }

    public String StringforDepformat(String str) {
        String result = "";
        String[] strArr = str.split("\n");
        int i = 0;
        while (i < strArr.length) {
            result = String.valueOf(result) + strArr[i] + " ";
            ++i;
        }
        result = result.trim();
        return result;
    }
}

