/*
 * Decompiled with CFR 0.152.
 */
package kaist.cilab.tripleextractor.dbpedia;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.LinkedList;
import kaist.cilab.tripleextractor.dbpedia.Triple;
import kaist.cilab.tripleextractor.util.Configuration;

public class TripleRetriever {
    public static LinkedList<Triple> getTriples(String DBpediaPath) {
        LinkedList<Triple> ret = new LinkedList<Triple>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(DBpediaPath), "UTF-8"));
            String str = "";
            while ((str = in.readLine()) != null) {
                String[] data = str.split("\t");
                Triple tp = new Triple();
                if (data.length < 3) continue;
                tp.subject = URLDecoder.decode(data[0], "UTF-8").replaceAll("_", " ").trim();
                try {
                    tp.predicate = URLDecoder.decode(data[1], "UTF-8").replaceAll("_", " ").trim();
                }
                catch (Exception e) {
                    tp.predicate = data[1].replaceAll("_", " ").trim();
                }
                try {
                    tp.object = URLDecoder.decode(data[2], "UTF-8").replaceAll("_", " ").trim();
                }
                catch (Exception e) {
                    tp.object = data[2].replaceAll("_", " ").trim();
                }
                ret.add(tp);
                if (ret.size() % 500 != 0) continue;
                System.out.println(ret.size());
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void main(String[] args) {
        LinkedList<Triple> tpList = TripleRetriever.getTriples(Configuration.dbPedia);
        System.out.println("Total List Size: " + tpList.size());
    }
}

