/*
 * Decompiled with CFR 0.152.
 */
package net_alchim31_livereload;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import net_alchim31_livereload.LRProtocol;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketHandler;

class LRWebSocketHandler
extends WebSocketHandler {
    final ConcurrentLinkedQueue<LRWebSocket> _broadcast = new ConcurrentLinkedQueue();
    final LRProtocol _protocol = new LRProtocol();

    LRWebSocketHandler() {
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        if ("/livereload".equals(request.getPathInfo())) {
            return new LRWebSocket();
        }
        return new WebSocket(){

            public void onOpen(WebSocket.Connection connection) {
                connection.close();
            }

            public void onClose(int code, String msg) {
            }
        };
    }

    public void notifyChange(String path) throws Exception {
        String msg = this._protocol.reload(path);
        for (LRWebSocket ws : this._broadcast) {
            try {
                ws._connection.sendMessage(msg);
            }
            catch (IOException e) {
                this._broadcast.remove(ws);
                e.printStackTrace();
            }
        }
    }

    class LRWebSocket
    implements WebSocket.OnTextMessage {
        protected WebSocket.Connection _connection;

        LRWebSocket() {
        }

        public void onOpen(WebSocket.Connection connection) {
            this._connection = connection;
            LRWebSocketHandler.this._broadcast.add(this);
        }

        public void onClose(int code, String message) {
            LRWebSocketHandler.this._broadcast.remove(this);
        }

        public void onMessage(String data) {
            try {
                if (LRWebSocketHandler.this._protocol.isHello(data)) {
                    this._connection.sendMessage(LRWebSocketHandler.this._protocol.hello());
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }
}

