/*
 * Decompiled with CFR 0.152.
 */
package net_alchim31_livereload;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net_alchim31_livereload.LRWebSocketHandler;

public class Watcher
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Watcher.class.getName());
    private final WatchService _watcher;
    private final Map<WatchKey, Path> _keys;
    private final Path _docroot;
    private final AtomicBoolean _running = new AtomicBoolean(false);
    public LRWebSocketHandler listener = null;
    private List<Pattern> _patterns;

    public Watcher(Path docroot) throws Exception {
        this._docroot = docroot;
        this._watcher = docroot.getFileSystem().newWatchService();
        this._keys = new HashMap<WatchKey, Path>();
        this.registerAll(this._docroot);
    }

    private void notify(String path) throws Exception {
        if (this._patterns != null) {
            for (Pattern p : this._patterns) {
                LOG.finer("Testing pattern: " + p + " against string: " + path);
                if (!p.matcher(path).matches()) continue;
                LOG.fine("Skipping file: " + path + " thanks to pattern: " + p);
                return;
            }
        }
        LOG.fine("File " + path + " changed, triggering refresh");
        LRWebSocketHandler l = this.listener;
        if (l != null) {
            l.notifyChange(path);
        }
    }

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this._watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this._keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Watcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    void start() throws Exception {
        if (this._running.compareAndSet(false, true)) {
            Thread t = new Thread(this);
            t.setDaemon(true);
            t.start();
        }
    }

    void stop() throws Exception {
        this._running.set(false);
        this._watcher.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this._running.get()) {
                WatchKey key = this._watcher.take();
                Path dir = this._keys.get(key);
                if (dir == null) {
                    System.err.println("WatchKey not recognized!!");
                    continue;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    WatchEvent.Kind<?> kind = event.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                    WatchEvent ev = Watcher.cast(event);
                    Path name = (Path)ev.context();
                    Path child = dir.resolve(name);
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.notify(this._docroot.relativize(child).toString());
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_CREATE || !Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerAll(child);
                }
                boolean valid = key.reset();
                if (valid) continue;
                this._keys.remove(key);
                if (!this._keys.isEmpty()) continue;
                break;
            }
        }
        catch (InterruptedException | ClosedWatchServiceException exc) {
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        finally {
            this._running.set(false);
        }
    }

    public void set_patterns(List<Pattern> _patterns) {
        this._patterns = _patterns;
    }

    public List<Pattern> get_patterns() {
        return this._patterns;
    }
}

