/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_executions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.StringUtils;
import scala_maven_executions.JavaMainCallerSupport;
import scala_maven_executions.MainHelper;
import scala_maven_executions.SpawnMonitor;

public class JavaMainCallerInProcess
extends JavaMainCallerSupport {
    private ClassLoader _cl = null;

    public JavaMainCallerInProcess(AbstractMojo requester, String mainClassName, String classpath, String[] jvmArgs, String[] args) throws Exception {
        super(requester, mainClassName, "", jvmArgs, args);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath.split(File.pathSeparator)) {
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                requester.getLog().error((Throwable)e);
            }
        }
        this._cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)null);
    }

    @Override
    public void addJvmArgs(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.requester.getLog().warn((CharSequence)("jvmArgs are ignored when run in process :" + arg));
            }
        }
    }

    @Override
    public boolean run(boolean displayCmd, boolean throwFailure) throws Exception {
        try {
            this.runInternal(displayCmd);
            return true;
        }
        catch (Exception e) {
            if (throwFailure) {
                throw e;
            }
            return false;
        }
    }

    @Override
    public SpawnMonitor spawn(final boolean displayCmd) throws Exception {
        final Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    JavaMainCallerInProcess.this.runInternal(displayCmd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        return new SpawnMonitor(){

            @Override
            public boolean isRunning() throws Exception {
                return t.isAlive();
            }
        };
    }

    private void runInternal(boolean displayCmd) throws Exception {
        Object[] argArray = this.args.toArray(new String[this.args.size()]);
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd : " + this.mainClassName + "(" + StringUtils.join((Object[])argArray, (String)",") + ")"));
        }
        MainHelper.runMain(this.mainClassName, this.args, this._cl);
    }

    @Override
    public void redirectToLog() {
        this.requester.getLog().warn((CharSequence)"redirection to log is not supported for 'inProcess' mode");
    }
}

