/*
 * Decompiled with CFR 0.152.
 */
package sbt_inc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import sbt.internal.inc.RawCompiler;
import sbt.internal.inc.ScalaInstance;
import sbt.io.AllPassFilter$;
import sbt.io.IO;
import sbt.io.NameFilter;
import sbt.util.Logger;
import sbt_inc.MavenLoggerSbtAdapter;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.jdk.CollectionConverters;
import scala_maven.MavenArtifactResolver;
import scala_maven.VersionNumber;
import util.FileUtils;
import xsbti.compile.ClasspathOptionsUtil;

public final class CompilerBridgeFactory {
    private static final String SBT_GROUP_ID = "org.scala-sbt";
    private static final String SBT_GROUP_ID_SCALA3 = "org.scala-lang";
    private static final String JAVA_CLASS_VERSION = System.getProperty("java.class.version");
    private static final File DEFAULT_SECONDARY_CACHE_DIR = Paths.get(System.getProperty("user.home"), ".sbt", "1.0", "zinc", "org.scala-sbt").toFile();

    private CompilerBridgeFactory() {
    }

    static File getCompiledBridgeJar(VersionNumber scalaVersion, ScalaInstance scalaInstance, File secondaryCacheDir, MavenArtifactResolver resolver, Log mavenLogger) throws Exception {
        String bridgeArtifactId = CompilerBridgeFactory.compilerBridgeArtifactId(scalaVersion.toString());
        if (secondaryCacheDir == null) {
            secondaryCacheDir = DEFAULT_SECONDARY_CACHE_DIR;
        }
        secondaryCacheDir.mkdirs();
        return scalaVersion.major == 3 ? CompilerBridgeFactory.getScala3CompilerBridgeJar(scalaVersion, bridgeArtifactId, resolver) : CompilerBridgeFactory.getScala2CompilerBridgeJar(scalaInstance, scalaVersion, bridgeArtifactId, resolver, secondaryCacheDir, mavenLogger);
    }

    private static String compilerBridgeArtifactId(String scalaVersion) {
        if (scalaVersion.startsWith("2.10.")) {
            return "compiler-bridge_2.10";
        }
        if (scalaVersion.startsWith("2.11.")) {
            return "compiler-bridge_2.11";
        }
        if (scalaVersion.startsWith("2.12.") || scalaVersion.equals("2.13.0-M1")) {
            return "compiler-bridge_2.12";
        }
        if (scalaVersion.startsWith("2.13.")) {
            return "compiler-bridge_2.13";
        }
        return "scala3-sbt-bridge";
    }

    private static File getScala3CompilerBridgeJar(VersionNumber scalaVersion, String bridgeArtifactId, MavenArtifactResolver resolver) {
        return resolver.getJar(SBT_GROUP_ID_SCALA3, bridgeArtifactId, scalaVersion.toString(), "").getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getScala2CompilerBridgeJar(ScalaInstance scalaInstance, VersionNumber scalaVersion, String bridgeArtifactId, MavenArtifactResolver resolver, File secondaryCacheDir, Log mavenLogger) throws IOException {
        Properties properties = new Properties();
        try (InputStream is = CompilerBridgeFactory.class.getClassLoader().getResourceAsStream("incrementalcompiler.version.properties");){
            properties.load(is);
        }
        String zincVersion = properties.getProperty("version");
        String timestamp = properties.getProperty("timestamp");
        String cacheFileName = "org.scala-sbt-" + bridgeArtifactId + '-' + zincVersion + "-bin_" + scalaVersion + "__" + JAVA_CLASS_VERSION + '-' + zincVersion + '_' + timestamp + ".jar";
        File cachedCompiledBridgeJar = new File(secondaryCacheDir, cacheFileName);
        if (mavenLogger.isInfoEnabled()) {
            mavenLogger.info((CharSequence)("Compiler bridge file: " + cachedCompiledBridgeJar));
        }
        if (!cachedCompiledBridgeJar.exists()) {
            mavenLogger.info((CharSequence)"Compiler bridge file is not installed yet");
            RawCompiler rawCompiler = new RawCompiler((xsbti.compile.ScalaInstance)scalaInstance, ClasspathOptionsUtil.auto(), (Logger)new MavenLoggerSbtAdapter(mavenLogger));
            File bridgeSources = resolver.getJar(SBT_GROUP_ID, bridgeArtifactId, zincVersion, "sources").getFile();
            Set bridgeSourcesDependencies = resolver.getJarAndDependencies(SBT_GROUP_ID, bridgeArtifactId, zincVersion, "sources").stream().filter(artifact -> artifact.getScope() != null && !artifact.getScope().equals("provided")).map(Artifact::getFile).map(File::toPath).collect(Collectors.toSet());
            bridgeSourcesDependencies.addAll(((Stream)Arrays.stream(scalaInstance.allJars()).sequential()).map(File::toPath).collect(Collectors.toList()));
            Path sourcesDir = Files.createTempDirectory("scala-maven-plugin-compiler-bridge-sources", new FileAttribute[0]);
            Path classesDir = Files.createTempDirectory("scala-maven-plugin-compiler-bridge-classes", new FileAttribute[0]);
            IO.unzip((File)bridgeSources, (File)sourcesDir.toFile(), (NameFilter)AllPassFilter$.MODULE$, (boolean)true);
            List<Path> bridgeSourcesScalaFiles = FileUtils.listDirectoryContent(sourcesDir, file -> Files.isRegularFile(file, new LinkOption[0]) && file.getFileName().toString().endsWith(".scala"));
            List<Path> bridgeSourcesNonScalaFiles = FileUtils.listDirectoryContent(sourcesDir, file -> Files.isRegularFile(file, new LinkOption[0]) && !file.getFileName().toString().endsWith(".scala") && !file.getFileName().toString().equals("MANIFEST.MF"));
            try {
                rawCompiler.apply(CollectionConverters.IterableHasAsScala(bridgeSourcesScalaFiles).asScala().toSeq(), CollectionConverters.IterableHasAsScala(bridgeSourcesDependencies).asScala().toSeq(), classesDir, CollectionConverters.IterableHasAsScala(Collections.emptyList()).asScala().toSeq());
                Manifest manifest = new Manifest();
                Path sourcesManifestFile = sourcesDir.resolve("META-INF").resolve("MANIFEST.MF");
                try (InputStream is = Files.newInputStream(sourcesManifestFile, new OpenOption[0]);){
                    manifest.read(is);
                }
                List<Tuple2<File, String>> scalaCompiledClasses = CompilerBridgeFactory.computeZipEntries(FileUtils.listDirectoryContent(classesDir, file -> true), classesDir);
                List<Tuple2<File, String>> resources = CompilerBridgeFactory.computeZipEntries(bridgeSourcesNonScalaFiles, sourcesDir);
                ArrayList<Tuple2<File, String>> allZipEntries = new ArrayList<Tuple2<File, String>>();
                allZipEntries.addAll(scalaCompiledClasses);
                allZipEntries.addAll(resources);
                IO.jar((Iterable)CollectionConverters.IterableHasAsScala((java.lang.Iterable)allZipEntries.stream().map(x -> Tuple2.apply((Object)x._1, (Object)x._2)).collect(Collectors.toList())).asScala(), (File)cachedCompiledBridgeJar, (Manifest)manifest);
                mavenLogger.info((CharSequence)"Compiler bridge installed");
            }
            finally {
                FileUtils.deleteDirectory(sourcesDir);
                FileUtils.deleteDirectory(classesDir);
            }
        }
        return cachedCompiledBridgeJar;
    }

    private static List<Tuple2<File, String>> computeZipEntries(List<Path> paths, Path rootDir) {
        int rootDirLength = rootDir.toString().length();
        Stream<Tuple2> stream = paths.stream().map(path -> {
            String zipPath = path.toString().substring(rootDirLength + 1).replace(File.separator, "/");
            if (Files.isDirectory(path, new LinkOption[0])) {
                zipPath = zipPath + "/";
            }
            return new Tuple2((Object)path.toFile(), (Object)zipPath);
        });
        return stream.collect(Collectors.toList());
    }
}

