/*
 * Decompiled with CFR 0.152.
 */
package net.di2e.ecdr.search.transform.response.rss;

import com.rometools.rome.feed.synd.SyndContent;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import ddf.catalog.data.Metacard;
import ddf.catalog.data.Result;
import ddf.catalog.data.impl.MetacardImpl;
import ddf.catalog.data.impl.ResultImpl;
import ddf.catalog.operation.QueryRequest;
import ddf.catalog.operation.SourceResponse;
import ddf.catalog.operation.impl.SourceResponseImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import net.di2e.ecdr.api.queryresponse.SearchResponseTransformer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSSResponseTransformer
implements SearchResponseTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSSResponseTransformer.class);

    public SourceResponse processSearchResponse(InputStream inputStream, QueryRequest request, String siteName) {
        ArrayList<Result> resultList = new ArrayList<Result>();
        Map responseProperties = null;
        SyndFeedInput input = new SyndFeedInput();
        try {
            SyndFeed feed = input.build((Reader)new XmlReader(inputStream));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Marshaled response into feed object: \n{}", (Object)feed.toString());
            }
            for (SyndEntry entry : feed.getEntries()) {
                resultList.add(this.convertEntryToResult(entry, siteName));
            }
        }
        catch (FeedException | IOException e) {
            LOGGER.warn("Could not transform response to metacards, returning 0 results.", e);
        }
        int totalResults = resultList.size();
        return new SourceResponseImpl(request, responseProperties, resultList, (long)totalResults);
    }

    private Result convertEntryToResult(SyndEntry entry, String siteName) {
        ResultImpl result = new ResultImpl();
        result.setMetacard(this.convertEntryToMetacard(entry, siteName));
        return result;
    }

    private Metacard convertEntryToMetacard(SyndEntry entry, String siteName) {
        SyndContent content;
        MetacardImpl metacard = new MetacardImpl();
        String id = entry.getUri();
        String link = entry.getLink();
        id = StringUtils.deleteWhitespace((String)id);
        metacard.setId(id);
        if (entry.getLink() != null) {
            try {
                metacard.setResourceURI(new URI(link));
            }
            catch (URISyntaxException use) {
                LOGGER.warn("Could not set URI due to bad link in data.", (Throwable)use);
            }
        }
        metacard.setSourceId(siteName);
        metacard.setTitle(entry.getTitle());
        metacard.setCreatedDate(entry.getPublishedDate());
        if (entry.getUpdatedDate() != null) {
            metacard.setModifiedDate(entry.getUpdatedDate());
        }
        if ((content = entry.getDescription()).getType().equals("text/xml")) {
            metacard.setMetadata(content.getValue());
        } else {
            metacard.setMetadata("<xml-fragment>" + content.getValue() + "</xml-fragment>");
        }
        return metacard;
    }
}

