/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.ripple;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import net.fortytwo.ripple.RippleException;
import net.fortytwo.ripple.RippleProperties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public final class Ripple {
    private static final Logger LOGGER = Logger.getLogger(Ripple.class);
    public static final String RANDOM_URN_PREFIX = "urn:uuid:";
    public static final String BUFFER_QUERY_RESULTS = "net.fortytwo.ripple.cli.bufferQueryResults";
    public static final String RESULT_VIEW_SHOW_EDGES = "net.fortytwo.ripple.cli.resultViewShowEdges";
    public static final String RESULT_VIEW_DEDUPLICATE_OBJECTS = "net.fortytwo.ripple.cli.resultViewDeduplicateObjects";
    public static final String RESULT_VIEW_MAX_OBJECTS = "net.fortytwo.ripple.cli.resultViewMaxObjects";
    public static final String RESULT_VIEW_MAX_PREDICATES = "net.fortytwo.ripple.cli.resultViewMaxPredicates";
    public static final String RESULT_VIEW_PRINT_ENTIRE_STACK = "net.fortytwo.ripple.cli.resultViewPrintEntireStack";
    public static final String MAX_WORKER_THREADS = "net.fortytwo.ripple.control.maxWorkerThreads";
    public static final String ALLEGROSAIL_HOST = "net.fortytwo.ripple.demo.allegroSailHost";
    public static final String ALLEGROSAIL_PORT = "net.fortytwo.ripple.demo.allegroSailPort";
    public static final String ALLEGROSAIL_START = "net.fortytwo.ripple.demo.allegroSailStart";
    public static final String ALLEGROSAIL_NAME = "net.fortytwo.ripple.demo.allegroSailName";
    public static final String ALLEGROSAIL_DIRECTORY = "net.fortytwo.ripple.demo.allegroSailDirectory";
    public static final String LINKEDDATASAIL_BASE_SAIL = "net.fortytwo.ripple.demo.linkedDataSailBaseSail";
    public static final String MEMORYSTORE_PERSIST_FILE = "net.fortytwo.ripple.demo.memoryStorePersistFile";
    public static final String NATIVESTORE_DIRECTORY = "net.fortytwo.ripple.demo.nativeStoreDirectory";
    public static final String NATIVESTORE_INDEXES = "net.fortytwo.ripple.demo.nativeStoreIndexes";
    public static final String SPARQL_ENDPOINTURL = "net.fortytwo.ripple.demo.sparqlEndpointUrl";
    public static final String READ_ONLY = "net.fortytwo.ripple.demo.readOnly";
    public static final String SAIL_TYPE = "net.fortytwo.ripple.demo.sailType";
    public static final String ALLOW_DUPLICATE_NAMESPACES = "net.fortytwo.ripple.io.allowDuplicateNamespaces";
    public static final String PREFER_NEWEST_NAMESPACE_DEFINITIONS = "net.fortytwo.ripple.io.preferNewestNamespaceDefinitions";
    public static final String HTTPCONNECTION_COURTESY_INTERVAL = "net.fortytwo.ripple.io.httpConnectionCourtesyInterval";
    public static final String HTTPCONNECTION_TIMEOUT = "net.fortytwo.ripple.io.httpConnectionTimeout";
    public static final String USE_BLANK_NODES = "net.fortytwo.ripple.model.useBlankNodes";
    public static final String MEMOIZE_LISTS_FROM_RDF = "net.fortytwo.ripple.model.memoizeListsFromRdf";
    public static final String DEFAULT_NAMESPACE = "net.fortytwo.ripple.model.defaultNamespace";
    public static final String VERSION = "net.fortytwo.ripple.version";
    public static final String USE_ASYNCHRONOUS_QUERIES = "";
    public static final String RIPPLE_ONTO_BASEURI = "http://fortytwo.net/2007/03/ripple/schema#";
    private static final String RIPPLE_PROPERTIES = "default.properties";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static boolean initialized = false;
    private static RippleProperties CONFIGURATION;
    private static boolean useAsynchronousQueries;
    private static boolean quiet;

    private Ripple() {
    }

    public static void initialize(Properties ... configuration) throws RippleException {
        if (!initialized) {
            PropertyConfigurator.configure((URL)Ripple.class.getResource(LOG4J_PROPERTIES));
            Properties props = new Properties();
            try {
                props.load(Ripple.class.getResourceAsStream(RIPPLE_PROPERTIES));
            }
            catch (IOException e) {
                throw new RippleException("unable to load properties file default.properties");
            }
            for (Properties p : configuration) {
                if (null == p) {
                    throw new IllegalArgumentException("null Properties");
                }
                props.putAll((Map<?, ?>)p);
            }
            CONFIGURATION = new RippleProperties(props);
            initialized = true;
        }
    }

    public static RippleProperties getConfiguration() throws RippleException {
        if (!initialized) {
            Ripple.initialize(new Properties[0]);
        }
        return CONFIGURATION;
    }

    public static String getName() {
        return "Ripple";
    }

    public static String getVersion() {
        try {
            return Ripple.getConfiguration().getProperty(VERSION);
        }
        catch (RippleException e) {
            LOGGER.warn((Object)("could not determine Ripple version: " + e.getMessage()));
            return "?";
        }
    }

    public static boolean getQuiet() {
        return quiet;
    }

    public static void setQuiet(boolean q) {
        quiet = q;
    }

    public static boolean asynchronousQueries() {
        return useAsynchronousQueries;
    }

    public static void enableAsynchronousQueries(boolean enable) {
        useAsynchronousQueries = enable;
    }

    static {
        useAsynchronousQueries = true;
        quiet = false;
    }
}

