/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.ripple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class RippleException
extends Exception {
    private static final long serialVersionUID = 2498405641024203574L;
    private static final Logger LOGGER = Logger.getLogger(RippleException.class);

    public RippleException(Throwable cause) {
        super(cause);
    }

    public RippleException(String msg) {
        super(msg);
    }

    public void logError(boolean includeStackTrace) {
        String description;
        if (includeStackTrace) {
            if (null == this.getCause()) {
                description = this.getMessage();
            } else {
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(os);
                    this.getCause().printStackTrace(ps);
                    description = os.toString();
                    ps.close();
                    os.close();
                }
                catch (IOException e) {
                    System.err.println("Failed to create error message. A stack trace of the secondary error follows.");
                    e.printStackTrace(System.err);
                    return;
                }
            }
        } else {
            description = null == this.getCause() ? this.getMessage() : this.getCause().getMessage();
        }
        try {
            LOGGER.error((Object)description);
        }
        catch (Throwable t) {
            System.err.println("Failed to log an exception. A stack trace of the secondary error follows.");
            t.printStackTrace(System.err);
        }
    }

    public void logError() {
        this.logError(true);
    }
}

